/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.bo.FscPageRspBo;
import com.tydic.fsc.settle.busi.api.DzcsInvoiceReturnApplyManageQueryService;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnApplyManageQueryReqBO;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnApplyManageQueryRspBO;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnSaleInvoiceInfoRspBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnDetailMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.InvoiceReturn;
import com.tydic.fsc.settle.dao.vo.DzcsInvoiceReturnDetailVO;
import com.tydic.fsc.settle.dao.vo.InvoiceReturnVO;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.InvoiceClasses;
import com.tydic.fsc.settle.enums.InvoiceReturnStatus;
import com.tydic.fsc.settle.enums.InvoiceReturnType;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.fsc.settle.utils.FileUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DzcsInvoiceReturnApplyManageQueryServiceImpl
implements DzcsInvoiceReturnApplyManageQueryService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsInvoiceReturnApplyManageQueryServiceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    private static final Map<String, List<String>> statusType = new HashMap<String, List<String>>();
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public FscPageRspBo<DzcsInvoiceReturnApplyManageQueryRspBO> query(DzcsInvoiceReturnApplyManageQueryReqBO reqBO) {
        if (isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u7535\u5b50\u8d85\u5e02\u9000\u7968\u7ba1\u7406\u5217\u8868\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u8bf7\u6c42\u5165\u53c2\u4e3a\u7a7a");
        }
        if ("0".equals(reqBO.getIsOperUnit()) && null == reqBO.getPurchaseProjectId()) {
            throw new BusinessException("1001", "\u91c7\u8d2d\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceReturnVO queryBO = new InvoiceReturnVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryBO);
        if ("0".equals(reqBO.getIsOperUnit())) {
            queryBO.setPurchaseProjectId(reqBO.getPurchaseProjectId());
        } else {
            queryBO.setOperUnitNo(reqBO.getCompanyId());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getTabId())) {
            queryBO.setStatusList(statusType.get(reqBO.getTabId()));
        }
        if (reqBO.getInvoiceNo() != null || reqBO.getInvoiceCode() != null || reqBO.getInvoiceDateStart() != null || reqBO.getInvoiceDateEnd() != null || reqBO.getMinAmt() != null || reqBO.getMaxAmt() != null || reqBO.getInvoiceStatus() != null) {
            queryBO.setFlagQueryInvoice(true);
        }
        queryBO.setOrderBy(" CREATE_DATE desc");
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<InvoiceReturn> resultList = this.invoiceReturnMapper.selectPageList(queryBO, (Page<Map<String, Object>>)page);
        ArrayList<DzcsInvoiceReturnApplyManageQueryRspBO> rows = new ArrayList<DzcsInvoiceReturnApplyManageQueryRspBO>();
        for (InvoiceReturn returnBO : resultList) {
            String billNo = returnBO.getBillNo();
            DzcsInvoiceReturnApplyManageQueryRspBO queryRspBO = new DzcsInvoiceReturnApplyManageQueryRspBO();
            BeanUtils.copyProperties((Object)returnBO, (Object)queryRspBO);
            queryRspBO.setTypeDescr(this.enumsService.getDescr(InvoiceReturnType.getInstance(returnBO.getType())));
            queryRspBO.setStatusDescr(this.enumsService.getDescr(InvoiceReturnStatus.getInstance(returnBO.getStatus())));
            queryRspBO.setPurchaseProjectName(this.organizationInfoService.queryProjectName(returnBO.getPurchaseProjectId()).getAccountName());
            ArrayList<DzcsInvoiceReturnSaleInvoiceInfoRspBO> irInvoices = new ArrayList<DzcsInvoiceReturnSaleInvoiceInfoRspBO>();
            queryRspBO.setInvoices(irInvoices);
            DzcsInvoiceReturnDetailVO vo = new DzcsInvoiceReturnDetailVO();
            vo.setBillNo(billNo);
            List<DzcsInvoiceReturnSaleInvoiceInfoRspBO> invoices = this.invoiceReturnDetailMapper.selectDzcsAllInvoice(vo);
            for (DzcsInvoiceReturnSaleInvoiceInfoRspBO invoice : invoices) {
                if (StringUtils.hasText((String)invoice.getInvoiceNo1())) {
                    invoice.setInvoiceUrl1(FileUtils.obtainOSSUrl(invoice.getElectronicInvoiceName1()));
                    invoice.setInvoiceStatusDescr1(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(invoice.getInvoiceStatus1())));
                }
                if (StringUtils.hasText((String)invoice.getApplyNo1())) {
                    BillApplyInfo apply1 = this.billApplyInfoMapper.selectByPrimaryKey(invoice.getApplyNo1());
                    invoice.setApplyNo1(apply1.getApplyNo());
                    invoice.setApplyAmt1(apply1.getAmt());
                    invoice.setApplyDate1(apply1.getApplyDate());
                    invoice.setBillStatus1(apply1.getBillStatus());
                    invoice.setBillStatusDescr1(this.enumsService.getDescr(BillStatus.getInstance(apply1.getBillStatus())));
                    invoice.setInvoiceType1(apply1.getInvoiceType());
                    invoice.setInvoiceTypeDescr1(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(apply1.getInvoiceType()))));
                    invoice.setInvoiceClasses1(apply1.getInvoiceClasses());
                    invoice.setInvoiceClassesDescr1(this.enumsService.getDescr(InvoiceClasses.getInstance(apply1.getInvoiceClasses())));
                    invoice.setInvoceName1(apply1.getInvoceName());
                    invoice.setTaxNo1(apply1.getTaxNo());
                    invoice.setAddress1(apply1.getAddr());
                    invoice.setPhone1(apply1.getPhone());
                    invoice.setBankName1(apply1.getBankName());
                }
                if (StringUtils.hasText((String)invoice.getInvoiceNo2())) {
                    invoice.setInvoiceUrl2(FileUtils.obtainOSSUrl(invoice.getElectronicInvoiceName2()));
                    invoice.setInvoiceStatusDescr2(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(invoice.getInvoiceStatus2())));
                }
                if (StringUtils.hasText((String)invoice.getApplyNo2())) {
                    BillApplyInfo apply2 = this.billApplyInfoMapper.selectByPrimaryKey(invoice.getApplyNo2());
                    invoice.setApplyNo2(apply2.getApplyNo());
                    invoice.setApplyAmt2(apply2.getAmt());
                    invoice.setApplyDate2(apply2.getApplyDate());
                    invoice.setBillStatus2(apply2.getBillStatus());
                    invoice.setBillStatusDescr2(this.enumsService.getDescr(BillStatus.getInstance(apply2.getBillStatus())));
                    invoice.setInvoiceType2(apply2.getInvoiceType());
                    invoice.setInvoiceTypeDescr2(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(apply2.getInvoiceType()))));
                    invoice.setInvoiceClasses2(apply2.getInvoiceClasses());
                    invoice.setInvoiceClassesDescr2(this.enumsService.getDescr(InvoiceClasses.getInstance(apply2.getInvoiceClasses())));
                    invoice.setInvoceName2(apply2.getInvoceName());
                    invoice.setTaxNo2(apply2.getTaxNo());
                    invoice.setAddress2(apply2.getAddr());
                    invoice.setPhone2(apply2.getPhone());
                    invoice.setBankName2(apply2.getBankName());
                }
                if (StringUtils.hasText((String)invoice.getInvoiceNo3())) {
                    invoice.setInvoiceUrl3(FileUtils.obtainOSSUrl(invoice.getElectronicInvoiceName3()));
                    invoice.setInvoiceStatusDescr3(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(invoice.getInvoiceStatus3())));
                }
                if (!StringUtils.hasText((String)invoice.getApplyNo3())) continue;
                BillApplyInfo apply3 = this.billApplyInfoMapper.selectByPrimaryKey(invoice.getApplyNo3());
                invoice.setApplyNo3(apply3.getApplyNo());
                invoice.setApplyAmt3(apply3.getAmt());
                invoice.setApplyDate3(apply3.getApplyDate());
                invoice.setBillStatus3(apply3.getBillStatus());
                invoice.setBillStatusDescr3(this.enumsService.getDescr(BillStatus.getInstance(apply3.getBillStatus())));
                invoice.setInvoiceType3(apply3.getInvoiceType());
                invoice.setInvoiceTypeDescr3(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(apply3.getInvoiceType()))));
                invoice.setInvoiceClasses3(apply3.getInvoiceClasses());
                invoice.setInvoiceClassesDescr3(this.enumsService.getDescr(InvoiceClasses.getInstance(apply3.getInvoiceClasses())));
                invoice.setInvoceName3(apply3.getInvoceName());
                invoice.setTaxNo3(apply3.getTaxNo());
                invoice.setAddress3(apply3.getAddr());
                invoice.setPhone3(apply3.getPhone());
                invoice.setBankName3(apply3.getBankName());
            }
            irInvoices.addAll(invoices);
            rows.add(queryRspBO);
        }
        FscPageRspBo resultRspBO = new FscPageRspBo();
        resultRspBO.setRows(rows);
        resultRspBO.setRecordsTotal(page.getTotalCount());
        resultRspBO.setTotal(page.getTotalPages());
        resultRspBO.setPageNo(page.getPageNo());
        return resultRspBO;
    }

    static {
        statusType.put(InvoiceReturnStatus.TO_APPROVE.getCode(), Arrays.asList(InvoiceReturnStatus.TO_APPROVE.getCode()));
        statusType.put(InvoiceReturnStatus.TO_RETURN.getCode(), Arrays.asList(InvoiceReturnStatus.TO_RETURN.getCode(), InvoiceReturnStatus.RETURNING.getCode()));
        statusType.put(InvoiceReturnStatus.RETURNED.getCode(), Arrays.asList(InvoiceReturnStatus.RETURNED.getCode()));
        statusType.put(InvoiceReturnStatus.REJECTED.getCode(), Arrays.asList(InvoiceReturnStatus.REJECTED.getCode(), InvoiceReturnStatus.CANCELED.getCode()));
        statusType.put(InvoiceReturnStatus.TO_BILL.getCode(), Arrays.asList(InvoiceReturnStatus.TO_BILL.getCode(), InvoiceReturnStatus.BILLING.getCode()));
        statusType.put(InvoiceReturnStatus.BILLED.getCode(), Arrays.asList(InvoiceReturnStatus.BILLED.getCode()));
    }
}

