/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.BillSNService;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.busi.api.DzcsInvoiceReturnApplyRedInvoiceService;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnApplyRedInvoiceReqBO;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnApplyRedInvoiceRspBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnDetailMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.InvoiceReturn;
import com.tydic.fsc.settle.dao.po.InvoiceReturnDetail;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.vo.InvoiceReturnDetailVO;
import com.tydic.fsc.settle.dao.vo.InvoiceReturnVO;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.BillType;
import com.tydic.fsc.settle.enums.InvoiceClasses;
import com.tydic.fsc.settle.enums.InvoiceReturnStatus;
import com.tydic.fsc.settle.enums.RedBlue;
import com.tydic.fsc.settle.enums.YesNo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DzcsInvoiceReturnApplyRedInvoiceServiceImpl
implements DzcsInvoiceReturnApplyRedInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsInvoiceReturnApplyRedInvoiceServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private BillSNService billSNService;

    public DzcsInvoiceReturnApplyRedInvoiceRspBO process(DzcsInvoiceReturnApplyRedInvoiceReqBO reqBO) {
        InvoiceReturnDetailVO vo;
        String billNo;
        List billNos;
        if (logger.isDebugEnabled()) {
            logger.debug("\u7ea2\u5b57\u5f00\u7968\u7533\u8bf7\u670d\u52a1\uff08\u7535\u5b50\u8d85\u5e02\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)(billNos = reqBO.getBillNos()))) {
            throw new BusinessException("1001", "\u8bf7\u52fe\u9009");
        }
        InvoiceReturnVO invoiceReturnVO = new InvoiceReturnVO();
        invoiceReturnVO.setBillNos(billNos);
        List<InvoiceReturn> invoiceReturns = this.invoiceReturnMapper.selectListBy(invoiceReturnVO);
        for (InvoiceReturn invoiceReturn : invoiceReturns) {
            billNo = invoiceReturn.getBillNo();
            if (!InvoiceReturnStatus.TO_RETURN.getCode().equals(invoiceReturn.getStatus())) {
                throw new BusinessException("1001", "\u72b6\u6001\u5fc5\u987b\u662f\uff1a" + this.enumsService.getDescr(InvoiceReturnStatus.TO_RETURN));
            }
            vo = new InvoiceReturnDetailVO();
            vo.setBillNo(billNo);
            List<InvoiceReturnDetail> invoiceReturnDetails = this.invoiceReturnDetailMapper.selectList(vo);
            for (InvoiceReturnDetail invoiceReturnDetail : invoiceReturnDetails) {
                BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(invoiceReturnDetail.getApplyNo1());
                if (InvoiceClasses.PAPER_INVOICE.getCode().equals(billApplyInfo.getInvoiceClasses())) continue;
                throw new BusinessException("1001", "\u539f\u7968\u7684\u53d1\u7968\u7c7b\u522b\u5fc5\u987b\u662f\uff1a" + this.enumsService.getDescr(InvoiceClasses.PAPER_INVOICE));
            }
        }
        for (InvoiceReturn invoiceReturn : invoiceReturns) {
            billNo = invoiceReturn.getBillNo();
            vo = new InvoiceReturnDetailVO();
            vo.setBillNo(billNo);
            vo.setApplyNo2IsNull("1");
            List<InvoiceReturnDetail> details = this.invoiceReturnDetailMapper.selectList(vo);
            if (details.isEmpty()) continue;
            HashMap applyNo1Map = new HashMap();
            for (InvoiceReturnDetail invoiceReturnDetail : details) {
                if (applyNo1Map.containsKey(invoiceReturnDetail.getApplyNo1())) {
                    ((List)applyNo1Map.get(invoiceReturnDetail.getApplyNo1())).add(invoiceReturnDetail.getInvoiceNo1());
                    continue;
                }
                ArrayList<String> invoiceNo1s = new ArrayList<String>();
                invoiceNo1s.add(invoiceReturnDetail.getInvoiceNo1());
                applyNo1Map.put(invoiceReturnDetail.getApplyNo1(), invoiceNo1s);
            }
            for (Map.Entry entry : applyNo1Map.entrySet()) {
                String applyNo1 = (String)entry.getKey();
                List invoiceNo1s = (List)entry.getValue();
                SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
                saleInvoiceInfoVO.setApplyNo(applyNo1);
                saleInvoiceInfoVO.setInvoiceNoList(invoiceNo1s);
                List<SaleInvoiceInfo> invoices = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
                if (invoices.size() != invoiceNo1s.size()) {
                    throw new BusinessException("1001", "\u539f\u53d1\u7968\u6570\u636e\u6709\u8bef");
                }
                BigDecimal amt = BigDecimal.ZERO;
                for (SaleInvoiceInfo invoice : invoices) {
                    amt = amt.add(invoice.getAmt());
                }
                BillApplyInfo billApplyInfo1 = this.billApplyInfoMapper.selectByPrimaryKey(applyNo1);
                String applyNo2 = this.billSNService.getSnAsString(BillType.INVOICE_APPLICATION);
                BillApplyInfo billApplyInfo2 = new BillApplyInfo();
                BeanUtils.copyProperties((Object)billApplyInfo1, (Object)billApplyInfo2);
                billApplyInfo2.setApplyNo(applyNo2);
                billApplyInfo2.setApplyDate(new Date());
                billApplyInfo2.setAmt(amt.negate());
                billApplyInfo2.setBillStatus(BillStatus.APPLIED.getCode());
                billApplyInfo2.setUserId(reqBO.getUserId());
                billApplyInfo2.setReturnBillNo(billNo);
                billApplyInfo2.setRedBlue(RedBlue.RED.getCode());
                billApplyInfo2.setUrgedInvoice(YesNo.NO.getCode());
                billApplyInfo2.setRemark(null);
                this.billApplyInfoMapper.insert(billApplyInfo2);
                InvoiceReturnDetailVO whereRecord = new InvoiceReturnDetailVO();
                whereRecord.setBillNo(billNo);
                whereRecord.setApplyNo1(applyNo1);
                InvoiceReturnDetailVO valueRecord = new InvoiceReturnDetailVO();
                valueRecord.setApplyNo2(applyNo2);
                this.invoiceReturnDetailMapper.updateBy(whereRecord, valueRecord);
            }
            invoiceReturn = new InvoiceReturn();
            invoiceReturn.setBillNo(billNo);
            invoiceReturn.setStatus(InvoiceReturnStatus.RETURNING.getCode());
            this.invoiceReturnMapper.updateByPrimaryKeySelective(invoiceReturn);
        }
        DzcsInvoiceReturnApplyRedInvoiceRspBO rspBO = new DzcsInvoiceReturnApplyRedInvoiceRspBO();
        return rspBO;
    }
}

