/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.BillSNService;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.busi.api.DzcsInvoiceReturnPreApplyService;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnFileRspBO;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnInvoiceRspBO;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnPreApplyReqBO;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnPreApplyRspBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.InvoiceReturn;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.BillType;
import com.tydic.fsc.settle.enums.DzcsInvoiceReturnFileType;
import com.tydic.fsc.settle.enums.InvoiceClasses;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.fsc.settle.utils.FileUtils;
import com.tydic.fsc.settle.utils.FscStringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DzcsInvoiceReturnPreApplyServiceImpl
implements DzcsInvoiceReturnPreApplyService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsInvoiceReturnPreApplyServiceImpl.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    public DzcsInvoiceReturnPreApplyRspBO process(DzcsInvoiceReturnPreApplyReqBO reqBO) {
        List applyNos;
        if (logger.isDebugEnabled()) {
            logger.debug("\u9000\u7968\u9884\u7533\u8bf7\u670d\u52a1\uff08\u7535\u5b50\u8d85\u5e02\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)(applyNos = reqBO.getApplyNos()))) {
            throw new BusinessException("8888", "\u8bf7\u52fe\u9009");
        }
        String invoiceClasses = null;
        String invoiceType = null;
        String billNo = this.billSNService.getSnAsString(BillType.INVOICE_RETURN);
        String applyNo1 = FscStringUtils.list2String(applyNos, ",");
        DzcsInvoiceReturnPreApplyRspBO rspBO = new DzcsInvoiceReturnPreApplyRspBO();
        ArrayList<DzcsInvoiceReturnInvoiceRspBO> invoices = new ArrayList<DzcsInvoiceReturnInvoiceRspBO>();
        rspBO.setInvoices(invoices);
        for (String applyNo : applyNos) {
            BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
            invoiceClasses = billApplyInfo.getInvoiceClasses();
            invoiceType = billApplyInfo.getInvoiceType();
            SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setApplyNo(applyNo);
            List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
            for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfos) {
                DzcsInvoiceReturnInvoiceRspBO invoice = new DzcsInvoiceReturnInvoiceRspBO();
                invoices.add(invoice);
                BeanUtils.copyProperties((Object)billApplyInfo, (Object)invoice);
                invoice.setMatchFlag("0");
                invoice.setSupplierName(this.organizationInfoService.querySupplierName(billApplyInfo.getSupplierNo()));
                invoice.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(billApplyInfo.getInvoiceType()))));
                invoice.setOperUnitName(this.organizationInfoService.queryOrgName(billApplyInfo.getOperUnitNo()));
                invoice.setInvoiceClassesDescr(this.enumsService.getDescr(InvoiceClasses.getInstance(billApplyInfo.getInvoiceClasses())));
                invoice.setInvoiceNo(saleInvoiceInfo.getInvoiceNo());
                invoice.setInvoiceCode(saleInvoiceInfo.getInvoiceCode());
                invoice.setInvoiceDate(saleInvoiceInfo.getInvoiceDate());
                invoice.setUntaxAmt(saleInvoiceInfo.getUntaxAmt());
                invoice.setTaxAmt(saleInvoiceInfo.getTaxAmt());
                invoice.setAmt(saleInvoiceInfo.getAmt());
                invoice.setInvoiceStatusDescr(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(saleInvoiceInfo.getInvoiceStatus())));
                invoice.setPurchaseProjectName(this.organizationInfoService.queryProjectName(billApplyInfo.getPurchaseProjectId()).getAccountName());
            }
        }
        rspBO.setBillNo(billNo);
        rspBO.setCreateUser(this.userInfoService.queryUserNameByUserId(reqBO.getUserId()));
        rspBO.setCreatePhone(reqBO.getCellphone());
        rspBO.setCreateOrg(this.organizationInfoService.queryOrgName(reqBO.getCompanyId()));
        rspBO.setInvoiceClasses(invoiceClasses);
        rspBO.setNoticeItem(this.enumsService.queryDzcsInvoiceReturnNoticeItem());
        ArrayList<DzcsInvoiceReturnFileRspBO> files = new ArrayList<DzcsInvoiceReturnFileRspBO>();
        rspBO.setFiles(files);
        if (InvoiceType.SPECIAL.getCode().toString().equals(invoiceType)) {
            DzcsInvoiceReturnFileRspBO file = new DzcsInvoiceReturnFileRspBO();
            file.setFileType(DzcsInvoiceReturnFileType.LICENSE_FILE.getCode());
            file.setItemname(DzcsInvoiceReturnFileType.LICENSE_FILE.getDescr());
            file.setFilename("");
            file.setFilenameUrl("");
            file.setShowFilenameUrl("0");
            file.setTemplateUrl("");
            file.setShowTemplateUrl("0");
            file.setShowUpload("1");
            file.setShowDelete("0");
            files.add(file);
            file = new DzcsInvoiceReturnFileRspBO();
            file.setFileType(DzcsInvoiceReturnFileType.APPLY_FILE.getCode());
            file.setItemname(DzcsInvoiceReturnFileType.APPLY_FILE.getDescr());
            file.setFilename("");
            file.setFilenameUrl("");
            file.setShowFilenameUrl("0");
            file.setTemplateUrl(FileUtils.obtainOSSUrl(this.enumsService.queryInvoiceReturnTemplate1()));
            file.setShowTemplateUrl("1");
            file.setShowUpload("1");
            file.setShowDelete("0");
            files.add(file);
            file = new DzcsInvoiceReturnFileRspBO();
            file.setFileType(DzcsInvoiceReturnFileType.REMARK_FILE.getCode());
            file.setItemname(DzcsInvoiceReturnFileType.REMARK_FILE.getDescr());
            file.setFilename("");
            file.setFilenameUrl("");
            file.setShowFilenameUrl("0");
            file.setTemplateUrl(FileUtils.obtainOSSUrl(this.enumsService.queryInvoiceReturnTemplate2()));
            file.setShowTemplateUrl("1");
            file.setShowUpload("1");
            file.setShowDelete("0");
            files.add(file);
            file = new DzcsInvoiceReturnFileRspBO();
            file.setFileType(DzcsInvoiceReturnFileType.RED_FILE.getCode());
            file.setItemname(DzcsInvoiceReturnFileType.RED_FILE.getDescr());
            file.setFilename("");
            file.setFilenameUrl("");
            file.setShowFilenameUrl("0");
            file.setTemplateUrl("");
            file.setShowTemplateUrl("0");
            file.setShowUpload("1");
            file.setShowDelete("0");
            files.add(file);
            file = new DzcsInvoiceReturnFileRspBO();
            file.setFileType(DzcsInvoiceReturnFileType.INVOICE_FILE.getCode());
            file.setItemname(DzcsInvoiceReturnFileType.INVOICE_FILE.getDescr());
            file.setFilename("");
            file.setFilenameUrl("");
            file.setShowFilenameUrl("0");
            file.setTemplateUrl("");
            file.setShowTemplateUrl("0");
            file.setShowUpload("1");
            file.setShowDelete("0");
            files.add(file);
        }
        InvoiceReturn invoiceReturn = new InvoiceReturn();
        invoiceReturn.setBillNo(billNo);
        invoiceReturn.setApplyNo1(applyNo1);
        try {
            this.invoiceReturnMapper.insert(invoiceReturn);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        return rspBO;
    }
}

