/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.tydic.fsc.settle.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.settle.busi.api.bo.FscDictionaryBusiReqBo;
import com.tydic.fsc.settle.busi.api.bo.FscDictionaryBusiRspBo;
import com.tydic.fsc.settle.busi.api.bo.FscDictionaryBusiRspDataBo;
import com.tydic.fsc.settle.busi.api.bo.FscDictionaryCreateBusiReqBO;
import com.tydic.fsc.settle.busi.api.bo.FscDictionaryCreateBusiRspBO;
import com.tydic.fsc.settle.busi.api.bo.FscDictionaryDeleteBusiReqBO;
import com.tydic.fsc.settle.busi.api.bo.FscDictionaryDeleteBusiRspBO;
import com.tydic.fsc.settle.busi.api.bo.FscDictionaryUpdateBusiReqBO;
import com.tydic.fsc.settle.busi.api.bo.FscDictionaryUpdateBusiRspBO;
import com.tydic.fsc.settle.dao.DicDictionaryMapper;
import com.tydic.fsc.settle.dao.bo.DicDictionaryPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscDictionaryBusiServiceImpl
implements FscDictionaryBusiService {
    @Autowired
    private DicDictionaryMapper dicDictionaryMapper;
    private static final Integer EFFECTIVE = 0;
    private static final Integer INVALID = 1;
    private static final String SYS_CODE = "FSC";

    public FscDictionaryBusiRspBo qryDic(FscDictionaryBusiReqBo reqBo) {
        FscDictionaryBusiRspBo retBo = new FscDictionaryBusiRspBo();
        String validateArgStr = this.validateQryArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("2005");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        ArrayList<FscDictionaryBusiRspDataBo> datas = new ArrayList<FscDictionaryBusiRspDataBo>();
        DicDictionaryPO qryPo = new DicDictionaryPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryPo);
        qryPo.setDelFlag(EFFECTIVE);
        List<DicDictionaryPO> listByCondition = this.dicDictionaryMapper.getListByCondition(qryPo);
        for (DicDictionaryPO po : listByCondition) {
            if (po == null) continue;
            FscDictionaryBusiRspDataBo dictionaryBusiRspDataBo = new FscDictionaryBusiRspDataBo();
            BeanUtils.copyProperties((Object)po, (Object)dictionaryBusiRspDataBo);
            datas.add(dictionaryBusiRspDataBo);
        }
        retBo.setRows(datas);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateQryArg(FscDictionaryBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getpCode())) {
            return "pCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    public FscDictionaryCreateBusiRspBO createDic(FscDictionaryCreateBusiReqBO reqBO) {
        int insert;
        FscDictionaryCreateBusiRspBO rspBO = new FscDictionaryCreateBusiRspBO();
        String validateArgStr = this.validateCreateArg(reqBO);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBO.setRespCode("2006");
            rspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBO;
        }
        DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)dicDictionaryPO);
        dicDictionaryPO.setDelFlag(EFFECTIVE);
        dicDictionaryPO.setCreateUid(reqBO.getUserId());
        dicDictionaryPO.setCreateTm(new Date());
        dicDictionaryPO.setSysCode(SYS_CODE);
        if (null == dicDictionaryPO.getOrderId()) {
            DicDictionaryPO dictionaryPO = new DicDictionaryPO();
            dictionaryPO.setPCode(reqBO.getpCode());
            dictionaryPO.setCode(reqBO.getCode());
            Integer max = this.dicDictionaryMapper.getMaxOrderId(dictionaryPO);
            dicDictionaryPO.setOrderId(null == max ? 0 : max + 1);
        }
        if ((insert = this.dicDictionaryMapper.insert(dicDictionaryPO)) < 1) {
            rspBO.setRespCode("2006");
            rspBO.setRespDesc("\u65b0\u589e\u5b57\u5178\u503c\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String validateCreateArg(FscDictionaryCreateBusiReqBO reqBO) {
        if (reqBO == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getpCode())) {
            return "pCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getCode())) {
            return "code\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getTitle())) {
            return "title\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    public FscDictionaryUpdateBusiRspBO updateDic(FscDictionaryUpdateBusiReqBO reqBO) {
        FscDictionaryUpdateBusiRspBO rspBO = new FscDictionaryUpdateBusiRspBO();
        String validateArgStr = this.validateUpdateArg(reqBO);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBO.setRespCode("2007");
            rspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBO;
        }
        DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)dicDictionaryPO);
        dicDictionaryPO.setUpdateTm(new Date());
        dicDictionaryPO.setUpdateUid(reqBO.getUserId());
        int update = this.dicDictionaryMapper.updateByCondition(dicDictionaryPO);
        if (update < 1) {
            rspBO.setRespCode("2007");
            rspBO.setRespDesc("\u4fee\u6539\u5b57\u5178\u503c\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String validateUpdateArg(FscDictionaryUpdateBusiReqBO reqBO) {
        if (reqBO == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getpCode())) {
            return "pCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getCode())) {
            return "code\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getDescrip()) && !StringUtils.hasText((String)reqBO.getTitle()) && null == reqBO.getOrderId()) {
            return "descrip\u3001title\u3001orderId\u4e0d\u80fd\u90fd\u4e3a\u7a7a";
        }
        return null;
    }

    public FscDictionaryDeleteBusiRspBO deleteDic(FscDictionaryDeleteBusiReqBO reqBO) {
        FscDictionaryDeleteBusiRspBO rspBO = new FscDictionaryDeleteBusiRspBO();
        String validateArgStr = this.validateDeleteArg(reqBO);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBO.setRespCode("2008");
            rspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBO;
        }
        DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
        dicDictionaryPO.setCode(reqBO.getCode());
        dicDictionaryPO.setPCode(reqBO.getpCode());
        dicDictionaryPO.setUpdateUid(reqBO.getUserId());
        dicDictionaryPO.setUpdateTm(new Date());
        dicDictionaryPO.setDelFlag(INVALID);
        int update = this.dicDictionaryMapper.updateByCondition(dicDictionaryPO);
        if (update < 1) {
            rspBO.setRespCode("2008");
            rspBO.setRespDesc("\u5220\u9664\u5b57\u5178\u503c\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String validateDeleteArg(FscDictionaryDeleteBusiReqBO reqBO) {
        if (reqBO == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getpCode())) {
            return "pCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getCode())) {
            return "code\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

