/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.busi.api.FscQryAuditDetailBusiService;
import com.tydic.fsc.settle.busi.api.bo.AuditLogDetailBO;
import com.tydic.fsc.settle.busi.api.bo.FscQryAuditDetailBusiReqBO;
import com.tydic.fsc.settle.busi.api.bo.FscQryAuditDetailBusiRspBO;
import com.tydic.fsc.supplier.bo.UserDetailInfoBO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.uac.dao.task.UacOrdTaskCandidateMapper;
import com.tydic.uac.po.task.OrdTaskCandidatePO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="fscQryAuditDetailBusiService")
public class FscQryAuditDetailBusiServiceImpl
implements FscQryAuditDetailBusiService {
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    private OrganizationInfoService organizationInfoService;
    private UserInfoService userInfoService;
    private UacOrdTaskCandidateMapper uacOrdTaskCandidateMapper;

    @Autowired
    private FscQryAuditDetailBusiServiceImpl(UacQryAuditLogAbilityService uacQryAuditLogAbilityService, OrganizationInfoService organizationInfoService, UserInfoService userInfoService, UacOrdTaskCandidateMapper uacOrdTaskCandidateMapper) {
        this.uacQryAuditLogAbilityService = uacQryAuditLogAbilityService;
        this.organizationInfoService = organizationInfoService;
        this.userInfoService = userInfoService;
        this.uacOrdTaskCandidateMapper = uacOrdTaskCandidateMapper;
    }

    public FscQryAuditDetailBusiRspBO qryAuditDetail(FscQryAuditDetailBusiReqBO reqBO) {
        FscQryAuditDetailBusiRspBO rspBO = new FscQryAuditDetailBusiRspBO();
        String validateArgStr = this.validateArg(reqBO);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBO.setRespCode("7777");
            rspBO.setRespDesc(validateArgStr);
            return rspBO;
        }
        UacQryAuditLogReqBO auditQryLogAbilityReqBO = new UacQryAuditLogReqBO();
        auditQryLogAbilityReqBO.setOrderId(Long.valueOf(reqBO.getProcInstId()));
        UacQryAuditLogRspBO auditQryLogAbilityRspBO = this.uacQryAuditLogAbilityService.qryLog(auditQryLogAbilityReqBO);
        if (!"0000".equals(auditQryLogAbilityRspBO.getRespCode())) {
            rspBO.setRespCode("2004");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5ba1\u6279\u8be6\u60c5");
            return rspBO;
        }
        ArrayList<AuditLogDetailBO> auditLogDetailBOList = new ArrayList<AuditLogDetailBO>();
        List rows = auditQryLogAbilityRspBO.getRows();
        for (ApprovalLogBO approvalLogBO : rows) {
            UserDetailInfoBO userDetailInfoBO;
            AuditLogDetailBO auditLogDetailBO = new AuditLogDetailBO();
            BeanUtils.copyProperties((Object)approvalLogBO, (Object)auditLogDetailBO);
            String orgName = "";
            if (StringUtils.hasText((String)auditLogDetailBO.getOperid()) && null != (userDetailInfoBO = this.userInfoService.queryUserInfoByUserId(Long.valueOf(auditLogDetailBO.getOperid())))) {
                orgName = this.organizationInfoService.queryOrgName(userDetailInfoBO.getOrgId());
            }
            auditLogDetailBO.setOperDept(orgName);
            if (null == auditLogDetailBO.getFinish() || !UacCommConstant.FINISH_FLAG.COMPLETION.equals(auditLogDetailBO.getFinish())) {
                OrdTaskCandidatePO taskCandidatePO = new OrdTaskCandidatePO();
                taskCandidatePO.setOrderId(auditLogDetailBO.getOrderId());
                taskCandidatePO.setTaskId(auditLogDetailBO.getNextStepId());
                List list = this.uacOrdTaskCandidateMapper.getList(taskCandidatePO);
                StringBuilder name = new StringBuilder();
                for (OrdTaskCandidatePO candidatePO : list) {
                    String userName;
                    if (!StringUtils.hasText((String)candidatePO.getOperId()) || !StringUtils.hasText((String)(userName = this.userInfoService.queryUserNameByUserId(Long.valueOf(candidatePO.getOperId()))))) continue;
                    name.append(userName).append(",");
                }
                auditLogDetailBO.setNextOperName(name.length() > 0 ? name.substring(0, name.length() - 1) : "");
            } else {
                auditLogDetailBO.setNextStepName("\u6d41\u7a0b\u7ed3\u675f\u8282\u70b9");
                auditLogDetailBO.setNextStepDesc("\u6d41\u7a0b\u7ed3\u675f\u8282\u70b9");
                auditLogDetailBO.setNextOperName("\u6d41\u7a0b\u7ed3\u675f");
            }
            auditLogDetailBOList.add(auditLogDetailBO);
        }
        auditLogDetailBOList.sort(Comparator.comparing(AuditLogDetailBO::getDealTime));
        rspBO.setRows(auditLogDetailBOList);
        rspBO.setPageNo(auditQryLogAbilityRspBO.getPageNo().intValue());
        rspBO.setRecordsTotal(auditQryLogAbilityRspBO.getTotalRecords().intValue());
        rspBO.setTotal(auditQryLogAbilityRspBO.getTotalPages().intValue());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u5ba1\u6279\u8be6\u60c5\u6210\u529f");
        return rspBO;
    }

    private String validateArg(FscQryAuditDetailBusiReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getProcInstId())) {
            return "\u6d41\u7a0b\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

