/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.busi.api.PayPlatfUseFeeRecordListService;
import com.tydic.fsc.settle.busi.api.bo.PayPlatfUseFeeRecordListReqBO;
import com.tydic.fsc.settle.busi.api.bo.PayPlatfUseFeeRecordListRspBO;
import com.tydic.fsc.settle.busi.api.bo.PayPlatfUseFeeRecordRspBO;
import com.tydic.fsc.settle.dao.InquiryPayOrderMapper;
import com.tydic.fsc.settle.dao.InquiryTranInfoMapper;
import com.tydic.fsc.settle.dao.po.InquiryPayOrder;
import com.tydic.fsc.settle.dao.po.InquiryPayOrderExt;
import com.tydic.fsc.settle.dao.po.InquiryTranInfoPO;
import com.tydic.fsc.settle.dao.vo.InquiryTranInfoVO;
import com.tydic.fsc.settle.enums.InquiryPayFeeType;
import com.tydic.fsc.settle.enums.InquiryPayPass;
import com.tydic.fsc.settle.enums.InquiryTradeState;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayPlatfUseFeeRecordListServiceImpl
implements PayPlatfUseFeeRecordListService {
    @Autowired
    private InquiryTranInfoMapper inquiryTranInfoMapper;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private EnumsService enumsService;

    public PayPlatfUseFeeRecordListRspBO platfUseFeeRecordList(PayPlatfUseFeeRecordListReqBO reqBO) {
        if (null == reqBO.getSupId()) {
            throw new BusinessException("1001", "\u4f9b\u5e94\u5546\u7f16\u53f7[supId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayPlatfUseFeeRecordListRspBO rspBO = new PayPlatfUseFeeRecordListRspBO();
        int idx = (reqBO.getPageNo() - 1) * reqBO.getPageSize();
        if (idx < 0) {
            idx = 0;
        }
        int total = 0;
        InquiryTranInfoPO inquiryTranInfoPO = new InquiryTranInfoPO();
        inquiryTranInfoPO.setInquiryNo(reqBO.getInquiryNo());
        inquiryTranInfoPO.setTradeState(reqBO.getTradeState());
        inquiryTranInfoPO.setSupplierId(reqBO.getSupId());
        inquiryTranInfoPO.setPayFeeType(InquiryPayFeeType.PLAT_USE_FEE.getCode());
        int recordsTotal = this.inquiryTranInfoMapper.queryCountByConditions(inquiryTranInfoPO);
        if (recordsTotal > 0) {
            total = recordsTotal / reqBO.getPageSize() + (recordsTotal % reqBO.getPageSize() > 0 ? 1 : 0);
        }
        ArrayList<PayPlatfUseFeeRecordRspBO> rows = new ArrayList<PayPlatfUseFeeRecordRspBO>();
        InquiryTranInfoVO inquiryTranInfoVO = new InquiryTranInfoVO();
        BeanUtils.copyProperties((Object)inquiryTranInfoPO, (Object)inquiryTranInfoVO);
        inquiryTranInfoVO.setRowIndex(idx);
        inquiryTranInfoVO.setPageSize(reqBO.getPageSize());
        inquiryTranInfoVO.setSortOrder("MER_DATE desc");
        List<InquiryTranInfoPO> tranList = this.inquiryTranInfoMapper.queryListByConditions(inquiryTranInfoVO);
        if (null != tranList && !tranList.isEmpty()) {
            for (InquiryTranInfoPO tranInfo : tranList) {
                PayPlatfUseFeeRecordRspBO ppu = new PayPlatfUseFeeRecordRspBO();
                BeanUtils.copyProperties((Object)tranInfo, (Object)ppu);
                InquiryPayOrderExt inquiryPayOrderExt = new InquiryPayOrderExt();
                inquiryPayOrderExt.setInquiryNo(ppu.getInquiryNo());
                InquiryPayOrder inquiryPayOrder = this.inquiryPayOrderMapper.selectByPrimaryKey(inquiryPayOrderExt);
                if (inquiryPayOrder != null) {
                    ppu.setMaterialsClass(inquiryPayOrder.getMaterialsClass());
                }
                ppu.setTradeStateDesc(this.enumsService.getDescr(InquiryTradeState.getInstance(tranInfo.getTradeState())));
                ppu.setPayPassDesc(this.enumsService.getDescr(InquiryPayPass.getInstance(tranInfo.getPayType())));
                ppu.setPayOrderNo(tranInfo.getGoodsId());
                rows.add(ppu);
            }
        }
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(total);
        rspBO.setRows(rows);
        return rspBO;
    }
}

