/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.QueryReceiptInfoService;
import com.tydic.fsc.settle.busi.api.bo.BusiReceiptInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.QueryReceiptInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.ReceiptInfoBO;
import com.tydic.fsc.settle.dao.EntryInfoMapper;
import com.tydic.fsc.settle.dao.ReceiptInfoMapper;
import com.tydic.fsc.settle.dao.po.EntryInfoPO;
import com.tydic.fsc.settle.dao.po.ReceiptInfoPO;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryReceiptInfoServiceImpl
implements QueryReceiptInfoService {
    private static final Logger logger = LoggerFactory.getLogger(QueryReceiptInfoServiceImpl.class);
    @Autowired
    private ReceiptInfoMapper receiptInfoMapper;
    @Autowired
    private EntryInfoMapper entryInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public BusiReceiptInfoRspBO<ReceiptInfoBO> queryListPage(QueryReceiptInfoReqBO queryReceiptInfoReqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5165\u5e93\u8be6\u60c5\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + queryReceiptInfoReqBO.toString());
        }
        if (queryReceiptInfoReqBO.getEntryNo() == null || StringUtils.isEmpty((CharSequence)queryReceiptInfoReqBO.getEntryNo())) {
            throw new BusinessException("1002", "\u5165\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orderBy = "t.ENTRY_DATE DESC";
        BusiReceiptInfoRspBO rspPageBO = new BusiReceiptInfoRspBO();
        ReceiptInfoPO receiptInfoPO = new ReceiptInfoPO();
        BeanUtils.copyProperties((Object)queryReceiptInfoReqBO, (Object)receiptInfoPO);
        Page page = new Page(queryReceiptInfoReqBO.getPageNo(), queryReceiptInfoReqBO.getPageSize());
        EntryInfoPO entryInfoPO = new EntryInfoPO();
        entryInfoPO.setEntryNo(queryReceiptInfoReqBO.getEntryNo());
        try {
            entryInfoPO = this.entryInfoMapper.getModelBy(entryInfoPO);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5165\u5e93\u5355\u53f7\u67e5\u8be2\u5165\u5e93\u5355\u8bb0\u5f55\u5931\u8d25\uff0c\u5165\u5e93\u5355\u53f7\u4e3a\uff1a" + queryReceiptInfoReqBO.getEntryNo(), (Throwable)e);
            throw new BusinessException("1002", "\u6839\u636e\u5165\u5e93\u5355\u53f7\u67e5\u8be2\u5165\u5e93\u5355\u8bb0\u5f55\u5931\u8d25");
        }
        rspPageBO.setEntryDate(entryInfoPO.getEntryDate());
        rspPageBO.setNotificationNo(entryInfoPO.getNotificationNo());
        rspPageBO.setTotalNotTaxAmt(entryInfoPO.getNotTaxAmt());
        rspPageBO.setTaxAmt(entryInfoPO.getTax());
        rspPageBO.setTotalAmt(entryInfoPO.getAmt());
        rspPageBO.setEntryNo(entryInfoPO.getEntryNo());
        String purchaseName = this.organizationInfoService.querySupplierName(entryInfoPO.getPurchaseId());
        logger.info("\u4f9b\u5e94\u5546ID\u4e3a\uff1a" + entryInfoPO.getPurchaseId() + "\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546\u540d\u79f0\u4e3a\uff1a" + purchaseName);
        rspPageBO.setPurchaseName(purchaseName);
        List<ReceiptInfoBO> receiptInfoBOs = null;
        try {
            receiptInfoBOs = this.receiptInfoMapper.getListPage(receiptInfoPO, (Page<Map<String, Object>>)page, orderBy);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5165\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u5165\u5e93\u5355\u8be6\u60c5\u8bb0\u5f55\u5931\u8d25\uff0c\u5165\u5e93\u5355\u53f7\u4e3a\uff1a" + queryReceiptInfoReqBO.getEntryNo(), (Throwable)e);
            throw new BusinessException("1002", "\u67e5\u8be2\u5165\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u5165\u5e93\u5355\u8be6\u60c5\u8bb0\u5f55\u5931\u8d25");
        }
        if (null == receiptInfoBOs || receiptInfoBOs.isEmpty()) {
            logger.error("\u627e\u4e0d\u5230\u5165\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u5165\u5e93\u8be6\u60c5\u8bb0\u5f55\uff0c\u5165\u5e93\u5355\u53f7\u4e3a\uff1a" + queryReceiptInfoReqBO.getEntryNo());
            return rspPageBO;
        }
        logger.info("\u6210\u529f\u67e5\u8be2\u5230\u5165\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u5165\u5e93\u5355\u8be6\u60c5\uff0ccount=" + receiptInfoBOs.size() + "\u5177\u4f53\u7684\u5165\u5e93\u5355\u8be6\u60c5\u4e3a\uff1a" + receiptInfoBOs.toString());
        rspPageBO.setRows(receiptInfoBOs);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }
}

