/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.ReconcilitionBatchAddService;
import com.tydic.fsc.settle.busi.api.bo.ReconcilitionBatchAddReqBO;
import com.tydic.fsc.settle.busi.api.bo.ReconcilitionBatchAddRspBO;
import com.tydic.fsc.settle.busi.api.bo.ReconcilitionDetailImportRedisAddItemReqBO;
import com.tydic.fsc.settle.dao.ReconcilitionHisTempMapper;
import com.tydic.fsc.settle.dao.po.ReconcilitionListTempPo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ReconcilitionBatchAddServiceImpl
implements ReconcilitionBatchAddService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReconcilitionBatchAddServiceImpl.class);
    private final ReconcilitionHisTempMapper reconcilitionHisTempMapper;

    public ReconcilitionBatchAddServiceImpl(ReconcilitionHisTempMapper reconcilitionHisTempMapper) {
        this.reconcilitionHisTempMapper = reconcilitionHisTempMapper;
    }

    public ReconcilitionBatchAddRspBO addReconcilitionBatch(ReconcilitionBatchAddReqBO reqBO) {
        ReconcilitionBatchAddRspBO rspBO = new ReconcilitionBatchAddRspBO();
        try {
            List reconcilitionDetailImportRedisAddItemReqBOs = reqBO.getReconcilitionDetailImportRedisAddItemReqBOs();
            ArrayList<ReconcilitionListTempPo> list = new ArrayList<ReconcilitionListTempPo>();
            Integer versionNo = this.reconcilitionHisTempMapper.selectVersion();
            if (versionNo == null) {
                versionNo = 0;
            }
            this.assemblePurchaseData(list, reconcilitionDetailImportRedisAddItemReqBOs, versionNo);
            for (ReconcilitionListTempPo po : list) {
                this.reconcilitionHisTempMapper.insertSelective(po);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6279\u91cf\u63d2\u5165\u6210\u529f");
            rspBO.setVersionNo(((ReconcilitionListTempPo)list.get(0)).getVersionNo());
        }
        catch (Exception e) {
            LOGGER.error("\u5bf9\u8d26-\u6279\u91cf\u65b0\u589e\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("8888", "\u5bf9\u8d26-\u6279\u91cf\u65b0\u589e\u670d\u52a1\u5f02\u5e38");
        }
        return rspBO;
    }

    private void assemblePurchaseData(List<ReconcilitionListTempPo> list, List<ReconcilitionDetailImportRedisAddItemReqBO> reconcilitionDetailImportRedisAddItemReqBOs, Integer versionNo) {
        for (ReconcilitionDetailImportRedisAddItemReqBO itemReqBO : reconcilitionDetailImportRedisAddItemReqBOs) {
            Integer versionNum = versionNo + 1;
            ReconcilitionListTempPo reconcilitionListTempPo = new ReconcilitionListTempPo();
            BeanUtils.copyProperties((Object)itemReqBO, (Object)reconcilitionListTempPo);
            reconcilitionListTempPo.setVersionNo(versionNum);
            if (null != itemReqBO.getOutAmt()) {
                reconcilitionListTempPo.setOutAmt(itemReqBO.getOutAmt());
            }
            list.add(reconcilitionListTempPo);
        }
    }
}

