/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.WorkFlowFinishEvent;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.WorkFlowFinishProcessService2;
import com.tydic.fsc.settle.busi.api.bo.WorkFlowFinishProcessReqBO;
import com.tydic.fsc.settle.dao.WorkFlowDataMapper;
import com.tydic.fsc.settle.dao.po.WorkFlowDataInfo;
import com.tydic.fsc.settle.dao.vo.WorkFlowDataInfoVO;
import com.tydic.fsc.settle.enums.FinancialStatus;
import com.tydic.fsc.settle.enums.WFBillType;
import com.tydic.fsc.settle.utils.SpringApplicationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.StringUtils;

@Service
public class WorkFlowFinishProcessService2Impl
implements WorkFlowFinishProcessService2 {
    private static final Logger logger = LoggerFactory.getLogger(WorkFlowFinishProcessService2Impl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private WorkFlowDataMapper workFlowDataMapper;

    public FscBaseRspBo process(WorkFlowFinishProcessReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5de5\u4f5c\u6d41\u7ed3\u675f\u5904\u7406\u670d\u52a1\uff08\u4e0d\u53d1\u9001\u8d22\u52a1\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        WorkFlowDataInfoVO vo = new WorkFlowDataInfoVO();
        ArrayList<String> billTypeIn = new ArrayList<String>();
        billTypeIn.add(WFBillType.HANDMADE_COLLECTION.getCode());
        vo.setBillTypeIn(billTypeIn);
        vo.setProcInstId(reqBO.getProcInstId());
        vo.setStatus("02");
        vo.setFinancialStatus("'01','22'");
        List<WorkFlowDataInfo> list = this.workFlowDataMapper.selectListByVO(vo);
        int size = list.size();
        if (size == 0) {
            return new FscBaseRspBo();
        }
        int maxThreadSize = this.enumsService.queryMaxThreadSize();
        ExecutorService executorService = Executors.newFixedThreadPool(size > maxThreadSize ? maxThreadSize : size);
        for (WorkFlowDataInfo eachWf : list) {
            WorkFlowFinishEvent event;
            final WorkFlowDataInfo wf = eachWf;
            String service = wf.getFinishEvtService();
            if (!StringUtils.hasLength((String)service) || (event = (WorkFlowFinishEvent)SpringApplicationContext.getBean(service)) == null) continue;
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    Exception exception = null;
                    try {
                        event.process(wf, wf.getBillType(), wf.getBillNo());
                    }
                    catch (Exception e) {
                        logger.error("\u5de5\u4f5c\u6d41\u5b8c\u6210\u540e\u5904\u7406\u5931\u8d25\u3002\u6d41\u7a0b\u5b9e\u4f8bID:" + wf.getProcInstId(), (Throwable)e);
                        exception = e;
                    }
                    WorkFlowDataInfo workFlowData = new WorkFlowDataInfo();
                    workFlowData.setProcInstId(wf.getProcInstId());
                    if (exception != null) {
                        workFlowData.setFinancialStatus(FinancialStatus.FAIL.getCode());
                        workFlowData.setResultdesc(exception.getMessage());
                        if (StringUtils.hasText((String)workFlowData.getResultdesc()) && workFlowData.getResultdesc().length() > 500) {
                            workFlowData.setResultdesc(workFlowData.getResultdesc().substring(0, 500));
                        }
                    } else {
                        workFlowData.setFinancialStatus(FinancialStatus.SUCCESS.getCode());
                        workFlowData.setResultdesc("\u6210\u529f");
                    }
                    DataSourceTransactionManager transactionManager = SpringApplicationContext.getTransactionManager();
                    DefaultTransactionDefinition transDefinition = new DefaultTransactionDefinition();
                    transDefinition.setPropagationBehavior(3);
                    TransactionStatus transactionStatus = transactionManager.getTransaction((TransactionDefinition)transDefinition);
                    try {
                        WorkFlowFinishProcessService2Impl.this.workFlowDataMapper.updateByPrimaryKeySelective(workFlowData);
                        transactionManager.commit(transactionStatus);
                    }
                    catch (Exception e2) {
                        logger.error("\u66f4\u65b0\u5de5\u4f5c\u6d41\u72b6\u6001\u5931\u8d25\u3002\u6d41\u7a0b\u5b9e\u4f8bID:" + wf.getProcInstId(), (Throwable)e2);
                        transactionManager.rollback(transactionStatus);
                    }
                    if (exception != null) {
                        throw new BusinessException("1002", exception.getMessage());
                    }
                }
            });
        }
        executorService.shutdown();
        return new FscBaseRspBo();
    }
}

