/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.impl.OrderSequenceImpl;
import com.ohaotian.plugin.loader.PropertiesFileLoader;
import com.tydic.fsc.settle.config.FscProperties;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FscSequenceConfig {
    private final FscProperties fscProperties;
    private final DruidDataSource dataSource;
    private final PropertiesFileLoader propertiesFileLoader;

    public FscSequenceConfig(FscProperties fscProperties, @Qualifier(value="orderDataSource") DruidDataSource dataSource, @Qualifier(value="propertiesFileLoader") PropertiesFileLoader propertiesFileLoader) {
        this.fscProperties = fscProperties;
        this.dataSource = dataSource;
        this.propertiesFileLoader = propertiesFileLoader;
    }

    @Bean(value={"propertyConfigurer"})
    public Properties propertyConfigurer() {
        return this.propertiesFileLoader.getProperties();
    }

    @Bean
    public OrderSequence generalSequence() {
        return new OrderSequenceImpl(this.fscProperties.getGeneralSequenceName(), this.dataSource);
    }

    @Bean
    public OrderSequence biTxnSeq() {
        return new OrderSequenceImpl("BI_TXN", this.dataSource);
    }

    @Bean
    public OrderSequence acctTransInfoSeq() {
        return new OrderSequenceImpl("ACCT", this.dataSource);
    }

    @Bean
    public OrderSequence pinganReq() {
        return new OrderSequenceImpl("PINGAN_REQ", this.dataSource);
    }

    @Bean
    public OrderSequence recAmtConfirmReq() {
        return new OrderSequenceImpl("D_REC_AMT_CONFIRM_DOCNUM", this.dataSource);
    }

    @Bean
    public OrderSequence advanceReveiveReq() {
        return new OrderSequenceImpl("D_ADVANCE_RECEIVE_SEQ", this.dataSource);
    }

    @Bean(value={"invoiceApplication"})
    public OrderSequence invoiceApplicationReq() {
        return new OrderSequenceImpl("INVOICE_APPLICATION", this.dataSource);
    }

    @Bean(value={"payApplicationSeq"})
    public OrderSequence payApplicationSeq() {
        return new OrderSequenceImpl("FKSQ", this.dataSource);
    }

    @Bean(value={"materialSeq"})
    public OrderSequence materialSeq() {
        return new OrderSequenceImpl("MATERIAL_COLLECT", this.dataSource);
    }

    @Bean(value={"invoiceNotificationSeq"})
    public OrderSequence invoiceNotificationSeq() {
        return new OrderSequenceImpl("INVOICE_NOTIFICATION_SEQ", this.dataSource);
    }

    @Bean(value={"payableSeq"})
    public OrderSequence payableSeq() {
        return new OrderSequenceImpl("PAYABLE", this.dataSource);
    }

    @Bean(value={"recvableSeq"})
    public OrderSequence recvableSeq() {
        return new OrderSequenceImpl("RECVABLE", this.dataSource);
    }

    @Bean(value={"purchaseStorageSeq"})
    public OrderSequence purchaseStorageSeq() {
        return new OrderSequenceImpl("PURCHASE_STORAGE", this.dataSource);
    }

    @Bean(value={"stockOutSeq"})
    public OrderSequence stockOutSeq() {
        return new OrderSequenceImpl("STOCK_OUT", this.dataSource);
    }

    @Bean(value={"orderIdSeq"})
    public OrderSequence orderIdSeq() {
        return new OrderSequenceImpl("ORDER_ID", this.dataSource);
    }

    @Bean(value={"publicSeqNoService"})
    public OrderSequence publicSeqNoService() {
        return new OrderSequenceImpl("PUBLIC", this.dataSource);
    }

    @Bean(value={"publicSeqNoService2"})
    public OrderSequence publicSeqNoService2() {
        return new OrderSequenceImpl("PUBLIC2", this.dataSource);
    }

    @Bean
    public OrderSequence billNotificationBatchNoSeq() {
        return new OrderSequenceImpl("BILL_NOTIFICATION_BATCHNO_SEQ", this.dataSource);
    }

    @Bean
    public OrderSequence advanceReceiveSeq() {
        return new OrderSequenceImpl("ADVANCE_RECEIVE_SEQ", this.dataSource);
    }
}

