/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.PayInvoiceInfo;
import com.tydic.fsc.settle.dao.po.PayItemInfo;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.enums.InvoiceMailStatus;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import com.tydic.fsc.settle.enums.OrderStatus;
import com.tydic.fsc.settle.utils.FscStringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payInvoiceService")
public class PayInvoiceService {
    private static final Log log = LogFactory.getLog(PayInvoiceService.class);
    @Autowired
    private BillNotificationInfoMapper notificationInfomapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;

    public void createInvoice(PayInvoiceInfo invoiceInfo) {
        String notificationNo = invoiceInfo.getNotificationNo();
        BigDecimal amt = BigDecimal.ZERO;
        HashSet<String> invoiceNos = new HashSet<String>();
        Date invoiceDate = null;
        if (invoiceInfo.getInvoiceCode() == null || invoiceInfo.getInvoiceNo() == null) {
            log.error((Object)("InvoiceCode\u6216InvoiceNo\u4e3a\u7a7a\uff0c\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo));
            throw new BusinessException("18000", "InvoiceCode\u6216InvoiceNo\u4e3a\u7a7a\uff0c\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo);
        }
        BillNotificationInfo billNotificationInfo = this.notificationInfomapper.selectByPrimaryKey(notificationNo);
        if (billNotificationInfo == null) {
            log.error((Object)("\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355\u3010\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo + "\u3011"));
            throw new BusinessException("18000", "\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355\u3010\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo + "\u3011");
        }
        List<PayInvoiceInfo> payInvoiceInfoList = this.payInvoiceInfoMapper.selectByNotifyNo(notificationNo);
        for (PayInvoiceInfo invoice : payInvoiceInfoList) {
            if (invoice.getInvoiceNo().contains(invoiceInfo.getInvoiceNo())) {
                this.payInvoiceInfoMapper.deleteByPrimaryKey(invoice.getInvoiceCode(), invoice.getInvoiceNo(), invoice.getInvoiceDate());
                continue;
            }
            amt = amt.add(invoice.getAmt());
            invoiceNos.add(invoice.getInvoiceNo());
            if (invoiceDate != null && !invoiceDate.before(invoice.getInvoiceDate())) continue;
            invoiceDate = invoice.getInvoiceDate();
        }
        amt = amt.add(invoiceInfo.getAmt());
        invoiceNos.add(invoiceInfo.getInvoiceNo());
        if (invoiceDate == null || invoiceDate.before(invoiceInfo.getInvoiceDate())) {
            invoiceDate = invoiceInfo.getInvoiceDate();
        }
        this.payInvoiceInfoMapper.insert(invoiceInfo);
        if (amt.compareTo(billNotificationInfo.getAmt()) >= 0) {
            billNotificationInfo = new BillNotificationInfo();
            billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.HAS_MAKE.getCode());
            billNotificationInfo.setInvoiceDate(invoiceDate);
            billNotificationInfo.setNotificationNo(notificationNo);
            int cnt = this.notificationInfomapper.updateByPrimaryKeySelective(billNotificationInfo);
            log.debug((Object)("\u4fee\u6539\u901a\u77e5\u5355\u53f7\u7684\u72b6\u6001\u4e3a\u5df2\u5f00\u7968,\u901a\u77e5\u5355\u53f7=" + notificationNo + " \u66f4\u65b0\u6570=" + cnt));
            PayPurchaseOrderInfo payOrderUpd = new PayPurchaseOrderInfo();
            payOrderUpd.setNotificationNo(notificationNo);
            payOrderUpd.setOrderStatus(OrderStatus.SEND_BILL.getCode());
            cnt = this.payPurchaseOrderInfoMapper.updateStatus(payOrderUpd);
            log.debug((Object)("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u5f00\u7968(02),\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo + ",\u6570\u91cf=" + cnt));
            PayItemInfo payItemUpd = new PayItemInfo();
            payItemUpd.setNotificationNo(notificationNo);
            payItemUpd.setItemStatus(OrderStatus.SEND_BILL.getCode());
            payItemUpd.setInvoiceCode(invoiceInfo.getInvoiceCode());
            String invoiceNo = FscStringUtils.list2String(new ArrayList(invoiceNos), ",");
            payItemUpd.setInvoiceNo(invoiceNo);
            cnt = this.payItemInfoMapper.updateByPrimaryKeySelective(payItemUpd);
            log.debug((Object)("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u72b6\u6001\u4e3a\u5df2\u5f00\u7968(02),\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo + ",\u6570\u91cf=" + cnt));
        }
    }

    public void updateMailSendStatus(PayInvoiceInfo updateInvoice, String mailInfo) {
        updateInvoice.setMailStatus(InvoiceMailStatus.NOT_SIGNED.getCode());
        this.payInvoiceInfoMapper.updateMailStatus(updateInvoice);
        BillNotificationInfo billNotificationInfo = new BillNotificationInfo();
        billNotificationInfo.setNotificationNo(updateInvoice.getNotificationNo());
        billNotificationInfo.setMailDesc(mailInfo);
        this.notificationInfomapper.updateByConditions(billNotificationInfo);
    }
}

