/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.SourceMappingService;
import com.tydic.fsc.settle.dao.SourceMappingMapper;
import com.tydic.fsc.settle.dao.po.SourceMapping;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.SourceMappingType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SourceMappingServiceImpl
implements SourceMappingService {
    private static final Logger logger = LoggerFactory.getLogger(SourceMappingServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private SourceMappingMapper sourceMappingMapper;

    @Override
    public String queryAccountingTargetSource(String source) {
        String mappingType = SourceMappingType.MAPPING_TYPE_SUB.getCode();
        SourceMapping sourceMapping = this.sourceMappingMapper.selectByPrimaryKey(source, mappingType);
        if (sourceMapping == null) {
            String sourceName = this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)source));
            logger.error("\u6765\u6e90[" + sourceName + "]\u672a\u914d\u7f6e\u8bb0\u8d26\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u914d\u7f6e");
            throw new BusinessException("18000", "\u6765\u6e90[" + sourceName + "]\u672a\u914d\u7f6e\u8bb0\u8d26\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u914d\u7f6e");
        }
        return sourceMapping.getSourceTarget();
    }

    @Override
    public String queryYuanguangTargetSource(String source) {
        String mappingType = SourceMappingType.MAPPING_TYPE_YUANGUANG.getCode();
        SourceMapping sourceMapping = this.sourceMappingMapper.selectByPrimaryKey(source, mappingType);
        if (sourceMapping == null) {
            String sourceName = this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)source));
            logger.error("\u6765\u6e90[" + sourceName + "]\u672a\u914d\u7f6e\u8fdc\u5149\u53c2\u6570\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u914d\u7f6e");
            throw new BusinessException("18000", "\u6765\u6e90[" + sourceName + "]\u672a\u914d\u7f6e\u8fdc\u5149\u53c2\u6570\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u914d\u7f6e");
        }
        return sourceMapping.getSourceTarget();
    }
}

