/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.fsc.settle.atom.CurrencyService;
import com.tydic.fsc.settle.atom.SequenceNoService;
import com.tydic.fsc.settle.atom.SubAccountService;
import com.tydic.fsc.settle.atom.TransactionService;
import com.tydic.fsc.settle.dao.AcctTranInfoMapper;
import com.tydic.fsc.settle.dao.TranDetailMapper;
import com.tydic.fsc.settle.dao.bo.AcctTranInfoVO;
import com.tydic.fsc.settle.dao.po.AcctTranInfo;
import com.tydic.fsc.settle.dao.po.TranDetail;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="transactionServiceImpl")
public class TransactionServiceImpl
implements TransactionService {
    private static final Log logger = LogFactory.getLog(TransactionServiceImpl.class);
    @Autowired
    private TranDetailMapper tranDetailMapper;
    @Autowired
    private AcctTranInfoMapper acctTranInfoMapper;
    @Autowired
    private SequenceNoService seqNoService;
    @Autowired
    private SubAccountService subAcctService;
    @Autowired
    @Qualifier(value="biTxnSeq")
    private OrderSequence biTxnSeq;
    private static final String NOT_CHANGE_SUB_ACCT = "NOT_CHANGE_SUB_ACCT";

    @Override
    public TranDetail transfer(TranDetail tranDetail, boolean needInformBank, Map<String, Object> extraData) {
        return this.transfer(tranDetail, true, needInformBank, extraData);
    }

    @Override
    public TranDetail transfer(TranDetail tranDetail, boolean allowOverdraft, boolean needInformBank, Map<String, Object> extraData) {
        String ssn;
        if (tranDetail == null) {
            throw new BusinessException("18000", "\u4ea4\u6613\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String bizType = tranDetail.getBusinessType();
        if (bizType == null || bizType.length() == 0) {
            throw new BusinessException("18000", "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fromAcctNo = tranDetail.getPayAcctNo();
        String toAcctNo = tranDetail.getRecvAcctNo();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(">>\u8f6c\u8d26\u4ea4\u6613\u5f00\u59cb,BusinessType=" + bizType + ",fromAcctNo=" + fromAcctNo + ",toAcctNo=" + toAcctNo + ",amount=" + tranDetail.getTranAmt()));
        }
        long seqNo = 0L;
        try {
            seqNo = this.biTxnSeq.nextId();
        }
        catch (SQLException e) {
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u4ea7\u751f\u4ea4\u6613\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        tranDetail.setCcy(CurrencyService.getCcy(tranDetail.getCcy()));
        tranDetail.setTxnNo(seqNo);
        tranDetail.setPostDate(new Date());
        if (tranDetail.getServiceNo() == null) {
            tranDetail.setServiceNo("" + seqNo);
        }
        boolean needChangeSubAcct = true;
        if (extraData != null && extraData.containsKey(NOT_CHANGE_SUB_ACCT)) {
            needChangeSubAcct = false;
        }
        if ((ssn = this.subAcctService.accountTransfer(fromAcctNo, toAcctNo, tranDetail.getTranAmt(), seqNo, tranDetail.getRemark(), allowOverdraft, needInformBank, needChangeSubAcct)) != null) {
            tranDetail.setSsn(ssn);
        }
        tranDetail.setTranDate(new Date());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(">>\u8f6c\u8d26\u4ea4\u6613,businessType=" + tranDetail.getBusinessType() + ",txnNo=" + seqNo + ",fromAcctNo=" + fromAcctNo + ",toAcctNo=" + toAcctNo + ",amount=" + tranDetail.getTranAmt() + ",allowOverdraft=" + allowOverdraft + ",needInformBank=" + needInformBank + " ssn=" + tranDetail.getSsn()));
        }
        if (needInformBank) {
            try {
                int cnt = this.tranDetailMapper.insertPingAnHis(tranDetail);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u5e73\u5b89\u6210\u529f\u4ea4\u6613\u5386\u53f2\u4fdd\u5b58\u6210\u529f(" + cnt + "),txnNo=" + tranDetail.getTxnNo() + ",fromAcctNo=" + tranDetail.getPayAcctNo() + ",toAcctNo=" + tranDetail.getRecvAcctNo() + ",amt=" + tranDetail.getTranAmt() + ",ssn=" + tranDetail.getSsn()));
                }
            }
            catch (Exception e) {
                logger.error((Object)("\u5e73\u5b89\u94f6\u884c\u6210\u529f\u4ea4\u6613\u5386\u53f2\u8bb0\u5f55\u5931\u8d25,\u4e1a\u52a1\u6d41\u6c34\u53f7:" + seqNo), (Throwable)e);
            }
        }
        if (tranDetail.getTxnNo() != null) {
            AcctTranInfoVO vo = new AcctTranInfoVO();
            vo.setTxnNo(tranDetail.getTxnNo());
            List<AcctTranInfo> acctTranInfos = this.acctTranInfoMapper.selectBy(vo);
            for (AcctTranInfo acctTranInfo : acctTranInfos) {
                AcctTranInfo acctTranInfo2 = new AcctTranInfo();
                acctTranInfo2.setSeq(acctTranInfo.getSeq());
                acctTranInfo2.setBusinessType(tranDetail.getBusinessType());
                acctTranInfo2.setServiceNo(tranDetail.getServiceNo());
                this.acctTranInfoMapper.updateByPrimaryKeySelective(acctTranInfo2);
            }
        }
        this.tranDetailMapper.insert(tranDetail);
        tranDetail.setRespCode("0000");
        tranDetail.setRespDesc("\u6210\u529f");
        return tranDetail;
    }

    @Override
    public int linkBusiAndCoreSsn(String coreSsn, String busiSsn) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u7528\u6838\u5fc3\u6d41\u6c34[" + coreSsn + "]\u5173\u8054\u4e1a\u52a1\u53d7\u7406\u6d41\u6c34[" + busiSsn + "]"));
        }
        if (!StringUtils.hasText((String)coreSsn) || !StringUtils.hasText((String)busiSsn)) {
            return 0;
        }
        TranDetail param = new TranDetail();
        param.setSsn(coreSsn);
        param.setBusiSsn(busiSsn);
        try {
            int cnt = this.tranDetailMapper.linkBusiSSn(param);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6838\u5fc3\u6d41\u6c34\u7ed1\u5b9a\u6210\u529f,CoreLinkBusiSsn=" + busiSsn + " link to " + coreSsn + ",\u66f4\u65b0\u6570=" + cnt));
            }
            return cnt;
        }
        catch (Exception e) {
            logger.error((Object)("\u4e1a\u52a1\u6d41\u6c34\u7ed1\u5b9a\u6838\u5fc3\u5931\u8d25,CoreLinkFailed with busissn" + busiSsn), (Throwable)e);
            return 0;
        }
    }
}

