/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.BusiCheckAccountBalanceApplyInfoService;
import com.tydic.fsc.settle.busi.api.bo.BusiCheckAccountBalanceApplyInfoPageRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiCheckAccountBalanceApplyInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiCheckAccountBalanceApplyInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.SubAcctInfoMapper;
import com.tydic.fsc.settle.dao.TranDetailMapper;
import com.tydic.fsc.settle.dao.bo.TranDetailExt;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.SaleOrderInfo;
import com.tydic.fsc.settle.dao.vo.BillApplyInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.utils.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiCheckAccountBalanceApplyInfoServiceImpl
implements BusiCheckAccountBalanceApplyInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCheckAccountBalanceApplyInfoServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = logger.isDebugEnabled();
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SubAcctInfoMapper subAcctInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private TranDetailMapper tranDetailMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public BusiCheckAccountBalanceApplyInfoPageRspBO query(BusiCheckAccountBalanceApplyInfoReqBO reqBO) {
        if (IS_DEBUG_ENABLED) {
            logger.debug("\u67e5\u8be2\u5bf9\u8d26\u4f59\u989d\u4e0b\u5f00\u7968\u7533\u8bf7\u660e\u7ec6\u5165\u53c2{}", (Object)reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getSubAcctNo())) {
            throw new BusinessException("0001", "\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiCheckAccountBalanceApplyInfoPageRspBO resultRspBO = new BusiCheckAccountBalanceApplyInfoPageRspBO();
        SubAcctInfoExt subAcctInfoExt = new SubAcctInfoExt();
        subAcctInfoExt.setSubAcctNo(reqBO.getSubAcctNo());
        List<SubAcctInfoExt> subAcctInfoExtList = this.subAcctInfoMapper.selectWihtMainAcct(subAcctInfoExt);
        if (CollectionUtils.isEmpty(subAcctInfoExtList)) {
            throw new BusinessException("18000", "\u8d44\u91d1\u5b50\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        SubAcctInfoExt subAcctInfo = subAcctInfoExtList.get(0);
        resultRspBO.setSubAcctName(subAcctInfo.getSubAcctName());
        resultRspBO.setPurchaseUnitName(this.organizationInfoService.queryProjectName(subAcctInfo.getProjectId()).getAccountName());
        BigDecimal addItemAmtSum = this.getTranDetailAddItemSum(subAcctInfo.getSubAcctNo());
        BigDecimal invoiceAmtSum = this.getAmtSumApplyInfo(subAcctInfo.getProjectId(), OrderSource.ELECTRIC_AREA.getCode(), BillStatus.SEND_BILL.getCode(), subAcctInfo.getSuperiorOrgId());
        resultRspBO.setCheckBalanceAmtSum(addItemAmtSum.subtract(invoiceAmtSum));
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setSource(OrderSource.ELECTRIC_AREA.getCode());
        billApplyInfoVO.setBillStatus(BillStatus.SEND_BILL.getCode());
        billApplyInfoVO.setPurchaseProjectId(subAcctInfo.getProjectId());
        billApplyInfoVO.setOperUnitNo(subAcctInfo.getSuperiorOrgId());
        billApplyInfoVO.setSaleOrderCodeLike(reqBO.getServiceNo());
        billApplyInfoVO.setApplyDateStart(reqBO.getApplyDateStart());
        billApplyInfoVO.setApplyDateEnd(reqBO.getApplyDateEnd());
        if (billApplyInfoVO.getApplyDateEnd() != null) {
            String endDate = DateUtil.dateToStr(billApplyInfoVO.getApplyDateEnd(), "yyyy-MM-dd") + " 23:59:59";
            billApplyInfoVO.setApplyDateEnd(DateUtil.strToDate(endDate, "yyyy-MM-dd HH:mm:ss"));
        }
        List<BillApplyInfo> data = this.billApplyInfoMapper.getListPageForQryBillApply(billApplyInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiCheckAccountBalanceApplyInfoRspBO> rows = new ArrayList<BusiCheckAccountBalanceApplyInfoRspBO>();
        for (BillApplyInfo billApplyInfo : data) {
            BusiCheckAccountBalanceApplyInfoRspBO infoRspBO = new BusiCheckAccountBalanceApplyInfoRspBO();
            infoRspBO.setAmt(billApplyInfo.getAmt());
            infoRspBO.setBusinessTypeDesrc("\u5f00\u7968");
            infoRspBO.setServiceNo(this.getServiceNo(billApplyInfo));
            infoRspBO.setApplyDate(billApplyInfo.getApplyDate());
            rows.add(infoRspBO);
        }
        resultRspBO.setRows(rows);
        resultRspBO.setRecordsTotal(page.getTotalCount());
        resultRspBO.setTotal(page.getTotalPages());
        resultRspBO.setPageNo(page.getPageNo());
        return resultRspBO;
    }

    private String getServiceNo(BillApplyInfo billApplyInfo) {
        HashSet<String> orderCodes = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        saleOrderInfoVO.setApplyNo(billApplyInfo.getApplyNo());
        saleOrderInfoVO.setOperUnitNo(billApplyInfo.getOperUnitNo());
        saleOrderInfoVO.setSource(billApplyInfo.getSource());
        List<SaleOrderInfo> list = this.saleOrderInfoMapper.getListByApplyNo(saleOrderInfoVO);
        for (SaleOrderInfo saleOrderInfo : list) {
            if (StringUtils.isEmpty((CharSequence)saleOrderInfo.getSaleOrderCode()) || !orderCodes.add(saleOrderInfo.getSaleOrderCode())) continue;
            sb.append(saleOrderInfo.getSaleOrderCode()).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private BigDecimal getAmtSumApplyInfo(Long projectId, String source, String billStatus, Long operUnitNo) {
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setPurchaseProjectId(projectId);
        billApplyInfoVO.setBillStatus(billStatus);
        billApplyInfoVO.setSource(source);
        billApplyInfoVO.setOperUnitNo(operUnitNo);
        return this.billApplyInfoMapper.getAmtSumApplyInfo(billApplyInfoVO);
    }

    private BigDecimal getTranDetailAddItemSum(String subAcctNo) {
        TranDetailExt ext = new TranDetailExt();
        ext.setSubAcctNo(subAcctNo);
        return this.tranDetailMapper.selectManageTranDetailSum(ext);
    }
}

