/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.AccountantEngineService;
import com.tydic.fsc.settle.atom.SubAccountService;
import com.tydic.fsc.settle.atom.bo.AccountantEngineReqBO;
import com.tydic.fsc.settle.base.PayBaseService;
import com.tydic.fsc.settle.bo.FscBaseReqBo;
import com.tydic.fsc.settle.busi.api.BusiOrderPayService;
import com.tydic.fsc.settle.busi.api.bo.BusiOrderPayReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiOrderPayRspBO;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.dao.TranDetailMapper;
import com.tydic.fsc.settle.dao.po.TranDetail;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiOrderPayServiceImpl
extends PayBaseService<BusiOrderPayRspBO>
implements BusiOrderPayService {
    private static final Logger logger = LoggerFactory.getLogger(BusiOrderPayServiceImpl.class);
    @Autowired
    private TranDetailMapper tranDetailMapper;
    @Autowired
    private AccountantEngineService accEngineService;
    @Autowired
    private SubAccountService subAccountService;

    public BusiOrderPayRspBO makingOrderPay(BusiOrderPayReqBO reqBO) {
        BusiOrderPayRspBO rspBO = (BusiOrderPayRspBO)this.queryRspOrSaveLog((FscBaseReqBo)reqBO);
        if (rspBO != null) {
            return rspBO;
        }
        try {
            logger.info("\u7ed3\u7b97\u6263\u6b3e\u670d\u52a1 -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
            rspBO = this.process(reqBO);
        }
        catch (Exception e) {
            logger.error("\u5931\u8d25", (Throwable)e);
            this.updateLog((FscBaseReqBo)reqBO, e);
            throw new BusinessException("18000", e.getMessage());
        }
        this.updateLog((FscBaseReqBo)reqBO, rspBO);
        return rspBO;
    }

    public BusiOrderPayRspBO process(BusiOrderPayReqBO reqBO) {
        List<TranDetail> tranDetails;
        if (logger.isDebugEnabled()) {
            logger.debug("\u8ba2\u5355\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (!StringUtils.hasText((String)reqBO.getOrderNo())) {
            throw new BusinessException("0001", "\u9500\u552e\u8ba2\u5355ID[orderNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSaleOrderCode())) {
            throw new BusinessException("0001", "\u9500\u552e\u8ba2\u5355\u7f16\u53f7[saleOrderCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBusinessType()) {
            throw new BusinessException("0001", "\u4e1a\u52a1\u7c7b\u578b[businessType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperatingUnitNo()) {
            throw new BusinessException("0001", "\u4e13\u4e1a\u673a\u6784\u7f16\u53f7[operatingUnitNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSource()) {
            throw new BusinessException("0001", "\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPurchaseUnitNo()) {
            throw new BusinessException("0001", "\u91c7\u8d2d\u5355\u4f4d\u7f16\u53f7[purchaseUnitNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPurchaseBookNo()) {
            throw new BusinessException("0001", "\u91c7\u8d2d\u5355\u4f4d\u5e10\u5957\u7f16\u53f7[purchaseBookNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderAmt()) {
            throw new BusinessException("0001", "\u8ba2\u5355\u91d1\u989d[orderAmt]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String serviceNo = reqBO.getSaleOrderCode();
        SubAcctInfoExt subAcctInfo = this.subAccountService.getWithMainAccount(reqBO.getOperatingUnitNo(), reqBO.getSource(), reqBO.getPurchaseUnitNo(), reqBO.getPurchaseBookNo(), null);
        if (subAcctInfo == null) {
            logger.error("\u627e\u4e0d\u5230\u91c7\u8d2d\u5355\u4f4d\u8d26\u6237\u3002\u8ba2\u5355\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
            throw new BusinessException("18000", "\u627e\u4e0d\u5230\u91c7\u8d2d\u5355\u4f4d\u8d26\u6237");
        }
        if (!(null != reqBO.getAnyPayFlag() && reqBO.getAnyPayFlag() == 1 || (tranDetails = this.tranDetailMapper.selectByBusiTypeAndServiceNo(String.valueOf(reqBO.getBusinessType()), serviceNo)).isEmpty() || tranDetails.get(0).getTxnNo() == null)) {
            throw new BusinessException("18000", "\u8bf7\u52ff\u91cd\u590d\u6263\u6b3e");
        }
        AccountantEngineReqBO accEngineReqBO = new AccountantEngineReqBO();
        accEngineReqBO.setBusinessType(String.valueOf(reqBO.getBusinessType()));
        accEngineReqBO.setClientAcctNo(subAcctInfo.getSubAcctNo());
        accEngineReqBO.setSource(reqBO.getSource());
        accEngineReqBO.setOperUnit(reqBO.getOperatingUnitNo());
        LinkedList<BigDecimal> amounts = new LinkedList<BigDecimal>();
        amounts.add(reqBO.getOrderAmt());
        accEngineReqBO.setAmounts(amounts);
        accEngineReqBO.setProjectId(reqBO.getProjectId());
        accEngineReqBO.setServiceNo(serviceNo);
        accEngineReqBO.setOrgId(reqBO.getPurchaseUnitNo());
        List<Long> txnNos = null;
        try {
            txnNos = this.accEngineService.executeAccountantEngine(accEngineReqBO);
        }
        catch (Exception e) {
            logger.error("\u8ba2\u5355\u652f\u4ed8\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("18000", "\u8ba2\u5355\u652f\u4ed8\u670d\u52a1\u5f02\u5e38\u3002" + e.getMessage());
        }
        if (txnNos == null) {
            logger.error("\u8ba2\u5355\u652f\u4ed8\u670d\u52a1\u5f02\u5e38");
            throw new BusinessException("18000", "\u8ba2\u5355\u652f\u4ed8\u670d\u52a1\u5f02\u5e38");
        }
        BusiOrderPayRspBO bo = new BusiOrderPayRspBO();
        bo.setTxnNo(String.valueOf(txnNos.get(0)));
        bo.setIsSuccess(Boolean.valueOf(true));
        bo.setRespCode("0000");
        bo.setRespDesc("\u652f\u4ed8\u6210\u529f");
        return bo;
    }

    @Override
    protected BusiOrderPayRspBO fillRspBO(String respPackage) {
        BusiOrderPayRspBO rspBO = new BusiOrderPayRspBO();
        JSONObject jsonObject = JSONObject.fromObject((Object)respPackage);
        rspBO.setRespCode(jsonObject.containsKey((Object)"respCode") ? jsonObject.getString("respCode") : null);
        rspBO.setRespDesc(jsonObject.containsKey((Object)"respDesc") ? jsonObject.getString("respDesc") : null);
        rspBO.setTxnNo(jsonObject.containsKey((Object)"txnNo") ? jsonObject.getString("txnNo") : null);
        rspBO.setIsSuccess(jsonObject.containsKey((Object)"isSuccess") ? Boolean.valueOf(jsonObject.getString("isSuccess")) : null);
        return rspBO;
    }
}

