/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.bo.FscPageRspBo;
import com.tydic.fsc.settle.busi.api.BusiQryNotificationListForSupService;
import com.tydic.fsc.settle.busi.api.bo.BusiQryNotificationListReqBO;
import com.tydic.fsc.settle.busi.api.vo.BillNotificationInfoVO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.vo.Statis;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.utils.AntiSqlInjectionManage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiQryNotificationListForSupServiceImpl
implements BusiQryNotificationListForSupService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQryNotificationListForSupServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;

    public FscPageRspBo<BillNotificationInfoVO> qryNotifyList(BusiQryNotificationListReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4f9b\u5e94\u5546\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == reqBO.getSupId()) {
            throw new BusinessException("0001", "\u53ea\u6709\u4f9b\u5e94\u5546\u7528\u6237\u624d\u6709\u64cd\u4f5c\u6743\u9650");
        }
        reqBO.setSupplierNo(reqBO.getSupId());
        reqBO.setSource(null);
        ArrayList<String> sources = new ArrayList<String>();
        sources.add(OrderSource.ELECTRIC_AREA.getCode());
        sources.add(OrderSource.CONSULT_PRICE.getCode());
        sources.add(OrderSource.COAL_AREA.getCode());
        reqBO.setSources(sources);
        reqBO.setStatusFilter("'01','02'");
        String orderBy = null;
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new BusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        } else {
            orderBy = " APPLY_DATE desc,NOTIFICATION_NO desc";
        }
        FscPageRspBo rspPageBO = new FscPageRspBo();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        LinkedList<BillNotificationInfoVO> result = new LinkedList<BillNotificationInfoVO>();
        List<BillNotificationInfo> resultPO = this.billNotificationInfoMapper.getListPage(reqBO, false, (Page<Map<String, Object>>)page, orderBy);
        for (BillNotificationInfo notifyInfo : resultPO) {
            BillNotificationInfoVO resultVO = new BillNotificationInfoVO();
            BeanUtils.copyProperties((Object)notifyInfo, (Object)resultVO);
            resultVO.setNotifInvoiceStatus(notifyInfo.getInvoiceStatus());
            NotificationInvoiceStatus notifInvoiceEnum = NotificationInvoiceStatus.getInstance(resultVO.getNotifInvoiceStatus());
            resultVO.setNotifInvoiceStatusStr(this.enumsService.getDescr(notifInvoiceEnum));
            resultVO.setSupplierName(notifyInfo.getInvoceName());
            resultVO.setAmtDifference(resultVO.getAmt());
            Statis ivStatis = this.payInvoiceInfoMapper.invoiceStatis(notifyInfo.getNotificationNo());
            if (null != ivStatis) {
                resultVO.setSumInvoiceAmt(ivStatis.getTotAmt());
                resultVO.setTotUntaxAmt(ivStatis.getTotUntaxAmt());
                resultVO.setTotTaxAmt(ivStatis.getTotTaxAmt());
                if (null != resultVO.getAmt() && null != resultVO.getSumInvoiceAmt()) {
                    resultVO.setAmtDifference(resultVO.getAmt().subtract(resultVO.getSumInvoiceAmt()));
                }
            }
            result.add(resultVO);
        }
        rspPageBO.setRows(result);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }
}

