/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.BusiQueryPurchaseOrderDetailInfoService;
import com.tydic.fsc.settle.busi.api.bo.BusiPurchaseOrderDetailInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiPurchaseOrderDetailInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.PayItemInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.PayPurchaseOrderInfoRspBO;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.PayItemInfo;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.dao.vo.PayItemInfoVO;
import com.tydic.fsc.settle.enums.OrderStatus;
import com.tydic.fsc.supplier.bo.TsupplierInfoRspBO;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiQueryPurchaseOrderDetailInfoServiceImpl
implements BusiQueryPurchaseOrderDetailInfoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiQueryPurchaseOrderDetailInfoServiceImpl.class);
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    private PayItemInfoMapper payItemInfoMapper;
    private EnumsService enumsService;
    private OrganizationInfoService organizationInfoService;

    @Autowired
    public BusiQueryPurchaseOrderDetailInfoServiceImpl(PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper, PayItemInfoMapper payItemInfoMapper, EnumsService enumsService, OrganizationInfoService organizationInfoService) {
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
        this.payItemInfoMapper = payItemInfoMapper;
        this.enumsService = enumsService;
        this.organizationInfoService = organizationInfoService;
    }

    public BusiPurchaseOrderDetailInfoRspBO queryPurchaseOrderDetailInfo(BusiPurchaseOrderDetailInfoReqBO reqBO) {
        TsupplierInfoRspBO supplier;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(" \u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == reqBO.getInspectionId()) {
            throw new BusinessException("0001", "\u9a8c\u6536\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiPurchaseOrderDetailInfoRspBO rspBO = new BusiPurchaseOrderDetailInfoRspBO();
        PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
        payPurchaseOrderInfo.setInspectionId(reqBO.getInspectionId());
        payPurchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelBy(payPurchaseOrderInfo);
        if (null == payPurchaseOrderInfo) {
            LOGGER.error("\u6839\u636e\u9a8c\u6536\u5355\u53f7\uff1a" + reqBO.getInspectionId() + "\u627e\u4e0d\u5230\u91c7\u8d2d\u8ba2\u5355\u3002");
            throw new BusinessException("18000", "\u6839\u636e\u9a8c\u6536\u5355\u53f7\uff1a" + reqBO.getInspectionId() + "\u627e\u4e0d\u5230\u91c7\u8d2d\u8ba2\u5355");
        }
        PayPurchaseOrderInfoRspBO payPurchaseOrder = new PayPurchaseOrderInfoRspBO();
        BeanUtils.copyProperties((Object)payPurchaseOrderInfo, (Object)payPurchaseOrder);
        OrderStatus orderStatusEnum = OrderStatus.getInstance(payPurchaseOrderInfo.getOrderStatus());
        payPurchaseOrder.setOrderStatusStr(this.enumsService.getDescr(orderStatusEnum));
        payPurchaseOrder.setPurchaseProjectName(this.organizationInfoService.queryProjectName(payPurchaseOrderInfo.getPurchaseProjectId()).getAccountName());
        ArrayList<Long> supIds = new ArrayList<Long>();
        supIds.add(payPurchaseOrderInfo.getSupplierNo());
        Map<Long, TsupplierInfoRspBO> suppliers = this.organizationInfoService.querySupplies(supIds);
        if (null != suppliers && null != (supplier = suppliers.get(payPurchaseOrderInfo.getSupplierNo()))) {
            payPurchaseOrder.setLinkMan(supplier.getLinkMan());
            payPurchaseOrder.setTel(supplier.getTel());
            payPurchaseOrder.setPhoneNumber(supplier.getPhoneNumber());
            payPurchaseOrder.setAddrDesc(supplier.getAddrDesc());
        }
        rspBO.setPayPurchaseOrderInfo(payPurchaseOrder);
        LinkedList<PayItemInfoRspBO> itemList = new LinkedList<PayItemInfoRspBO>();
        PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
        payItemInfoVO.setInspectionId(reqBO.getInspectionId());
        List<PayItemInfo> payItemInfoList = this.payItemInfoMapper.selectBy(payItemInfoVO);
        for (PayItemInfo singleItem : payItemInfoList) {
            PayItemInfoRspBO payItemInfoRspBO = new PayItemInfoRspBO();
            BeanUtils.copyProperties((Object)singleItem, (Object)payItemInfoRspBO);
            itemList.add(payItemInfoRspBO);
        }
        rspBO.setPayItemList(itemList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\u6210\u529f");
        return rspBO;
    }
}

