/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.OrderService;
import com.tydic.fsc.settle.busi.api.BusiReconcilitionService;
import com.tydic.fsc.settle.busi.api.bo.BusiReconcilitionRepBO;
import com.tydic.fsc.settle.busi.api.bo.BusiReconcilitionRspBO;
import com.tydic.fsc.settle.busi.impl.QueryEntryInfoServiceImpl;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.ReconcilitionHisMapper;
import com.tydic.fsc.settle.dao.po.ReconcilitionHis;
import com.tydic.fsc.settle.enums.OrderStatus;
import com.tydic.fsc.settle.enums.ReconciliationStatus;
import com.tydic.fsc.supplier.bo.FscUnacceptedOrderInfoBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusiReconcilitionServiceImpl
implements BusiReconcilitionService {
    private static final Logger logger = LoggerFactory.getLogger(QueryEntryInfoServiceImpl.class);
    @Autowired
    private ReconcilitionHisMapper reconcilitionHisMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private OrderService orderService;

    public BusiReconcilitionRspBO registerReconcilition(BusiReconcilitionRepBO reqBO) {
        List<Long> orderId;
        List<ReconcilitionHis> reconcilitionHis;
        if (logger.isDebugEnabled()) {
            logger.debug("\u7ed3\u7b97\u5bf9\u8d26\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reqBO.getVersionNo());
        }
        BusiReconcilitionRspBO rspBO = new BusiReconcilitionRspBO();
        if (!StringUtils.hasText((String)reqBO.getVersionNo())) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u65e0\u5bf9\u8d26\u6570\u636e\u4e0d\u80fd\u5bf9\u8d26\uff0c\u8bf7\u5bfc\u5165\u5bf9\u8d26\u6570\u636e");
            return rspBO;
        }
        try {
            reconcilitionHis = this.reconcilitionHisMapper.selectByVersionNo(Integer.valueOf(reqBO.getVersionNo()));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new BusinessException("18000", "\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(reconcilitionHis)) {
            List<Long> orderId2;
            try {
                this.reconcilitionHisMapper.insertAccountAgreement(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.AGREEMENT.getCode());
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new BusinessException("18000", "\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
            try {
                orderId2 = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.AGREEMENT.getCode());
                if (!CollectionUtils.isEmpty(orderId2)) {
                    this.payPurchaseOrderInfoMapper.updateReconciliation(orderId2, ReconciliationStatus.AGREEMENT.getCode());
                }
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new BusinessException("18000", "\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
            }
            try {
                this.reconcilitionHisMapper.insertAccountDisagreement(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.DISAGREEMENT.getCode());
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new BusinessException("18000", "\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
            try {
                orderId2 = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.DISAGREEMENT.getCode());
                if (!CollectionUtils.isEmpty(orderId2)) {
                    this.payPurchaseOrderInfoMapper.updateReconciliation(orderId2, ReconciliationStatus.DISAGREEMENT.getCode());
                }
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new BusinessException("18000", "\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
            }
            List<ReconcilitionHis> nonacceptanceList = this.reconcilitionHisMapper.selectNonacceptance(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.NON_ACCEPTANCE.getCode());
            if (null != nonacceptanceList && !nonacceptanceList.isEmpty()) {
                LinkedList<String> extOrderIdList = new LinkedList<String>();
                for (ReconcilitionHis rechis : nonacceptanceList) {
                    extOrderIdList.add(rechis.getExtOrderId());
                }
                LinkedHashSet middleLinkedHashSet = new LinkedHashSet(extOrderIdList);
                ArrayList<String> afterHashSetList = new ArrayList<String>(middleLinkedHashSet);
                FscUnacceptedOrderInfoBO unacceptedOrder = this.orderService.getUnacceptedOrder(afterHashSetList);
                if (null == unacceptedOrder) {
                    logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\uff0c\u6839\u636e\u5916\u90e8\u8ba2\u5355ID\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5931\u8d25\uff01");
                    throw new BusinessException("18000", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\uff0c\u6839\u636e\u5916\u90e8\u8ba2\u5355ID\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5931\u8d25\uff01");
                }
                logger.debug("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\uff0c\u6839\u636e\u5916\u90e8\u8ba2\u5355ID\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u6210\u529f\uff01");
                Map orderIdMap = unacceptedOrder.getOrderIdMap();
                Map createTimeMap = unacceptedOrder.getCreateTimeMap();
                Map supplierIDMap = unacceptedOrder.getSupplierIdMap();
                HashMap<String, String> supplierNameMap = new HashMap<String, String>(supplierIDMap.size() + 1);
                for (String key : supplierIDMap.keySet()) {
                    if (null != supplierIDMap.get(key)) {
                        if ((Integer)supplierIDMap.get(key) == 1) {
                            supplierNameMap.put(key, "\u4eac\u4e1c");
                            continue;
                        }
                        if ((Integer)supplierIDMap.get(key) == 2) {
                            supplierNameMap.put(key, "\u82cf\u5b81");
                            continue;
                        }
                        if ((Integer)supplierIDMap.get(key) == 3) {
                            supplierNameMap.put(key, "\u5f97\u529b");
                            continue;
                        }
                        if ((Integer)supplierIDMap.get(key) == 4) {
                            supplierNameMap.put(key, "\u897f\u57df");
                            continue;
                        }
                        if ((Integer)supplierIDMap.get(key) == 5) {
                            supplierNameMap.put(key, "\u56fa\u5b89\u6377");
                            continue;
                        }
                        if ((Integer)supplierIDMap.get(key) == 6) {
                            supplierNameMap.put(key, "\u9707\u5764\u884c");
                            continue;
                        }
                        supplierNameMap.put(key, "");
                        continue;
                    }
                    supplierNameMap.put(key, null);
                }
                for (ReconcilitionHis reconhis : nonacceptanceList) {
                    reconhis.setOrderId((Long)orderIdMap.get(reconhis.getExtOrderId()));
                    reconhis.setOrderDate((Date)createTimeMap.get(reconhis.getExtOrderId()));
                    reconhis.setSupplierNo((Integer)supplierIDMap.get(reconhis.getExtOrderId()));
                    reconhis.setSupplierName((String)supplierNameMap.get(reconhis.getExtOrderId()));
                }
                try {
                    this.reconcilitionHisMapper.insertReconcilitionHisList(nonacceptanceList);
                }
                catch (Exception e) {
                    logger.error("e\u8d2d\u672a\u9a8c\u6536\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                    throw new BusinessException("18000", "e\u8d2d\u672a\u9a8c\u6536\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
                }
            }
            try {
                this.reconcilitionHisMapper.insertAftersale(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.AFTER_SALE.getCode());
            }
            catch (Exception e) {
                logger.error("e\u8d2d\u552e\u540e\u4e2d\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new BusinessException("18000", "e\u8d2d\u552e\u540e\u4e2d\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
        }
        try {
            this.reconcilitionHisMapper.updateAccountAgreement(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.AGREEMENT.getCode());
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new BusinessException("18000", "\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u5931\u8d25");
        }
        try {
            orderId = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.AGREEMENT.getCode());
            if (!CollectionUtils.isEmpty(orderId)) {
                this.payPurchaseOrderInfoMapper.updateReconciliation(orderId, ReconciliationStatus.AGREEMENT.getCode());
            }
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new BusinessException("18000", "\u66f4\u65b0\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
        }
        try {
            this.reconcilitionHisMapper.updateAccountDisagreement(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.DISAGREEMENT.getCode());
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new BusinessException("18000", "\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u5931\u8d25");
        }
        try {
            orderId = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.DISAGREEMENT.getCode());
            if (!CollectionUtils.isEmpty(orderId)) {
                this.payPurchaseOrderInfoMapper.updateReconciliation(orderId, ReconciliationStatus.DISAGREEMENT.getCode());
            }
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new BusinessException("18000", "\u66f4\u65b0\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setBatchNo(Integer.valueOf(reqBO.getVersionNo()));
        return rspBO;
    }
}

