/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.busi.api.DzcsInvoiceReturnApplyService;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnApplyReqBO;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnApplyRspBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnDetailMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.InvoiceReturn;
import com.tydic.fsc.settle.dao.po.InvoiceReturnDetail;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.vo.InvoiceReturnDetailVO;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.DzcsInvoiceReturnFileType;
import com.tydic.fsc.settle.enums.DzcsInvoiceReturnType;
import com.tydic.fsc.settle.enums.DzcsWriteOffFlag;
import com.tydic.fsc.settle.enums.InvoiceClasses;
import com.tydic.fsc.settle.enums.InvoiceReturnStatus;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.utils.FscStringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DzcsInvoiceReturnApplyServiceImpl
implements DzcsInvoiceReturnApplyService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsInvoiceReturnApplyServiceImpl.class);
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private EnumsService enumsService;

    public DzcsInvoiceReturnApplyRspBO process(DzcsInvoiceReturnApplyReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u9000\u7968\u7533\u8bf7\u670d\u52a1\uff08\u7535\u5b50\u8d85\u5e02\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        String billNo = reqBO.getBillNo();
        String type = reqBO.getType();
        String remark = reqBO.getRemark();
        String mailCompany = reqBO.getMailCompany();
        String mailTicketNo = reqBO.getMailTicketNo();
        String createUser = reqBO.getCreateUser();
        String createPhone = reqBO.getCreatePhone();
        String createOrg = reqBO.getCreateOrg();
        List invoiceNos = reqBO.getInvoiceNos();
        String writeOffFlag = reqBO.getWriteOffFlag();
        String refundType = reqBO.getRefundType();
        if (!StringUtils.hasText((String)billNo)) {
            throw new BusinessException("0001", "\u9000\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)type)) {
            throw new BusinessException("0001", "\u9000\u7968\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)createUser)) {
            throw new BusinessException("0001", "\u7533\u8bf7\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)createPhone)) {
            throw new BusinessException("0001", "\u7533\u8bf7\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)createOrg)) {
            throw new BusinessException("0001", "\u7533\u8bf7\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)invoiceNos)) {
            throw new BusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        if (!StringUtils.hasText((String)writeOffFlag)) {
            throw new BusinessException("0001", "\u662f\u5426\u62b5\u6263\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)refundType)) {
            throw new BusinessException("0001", "\u9000\u8d27\u60c5\u51b5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceReturn invoiceReturn = this.invoiceReturnMapper.selectByPrimaryKey(billNo);
        List<String> applyNo1s = FscStringUtils.string2List(invoiceReturn.getApplyNo1(), ",");
        BillApplyInfo billApplyInfo1 = this.billApplyInfoMapper.selectByPrimaryKey(applyNo1s.get(0));
        if (InvoiceType.SPECIAL.getCode().toString().equals(billApplyInfo1.getInvoiceType())) {
            if (!StringUtils.hasText((String)invoiceReturn.getLicenseFile())) {
                throw new BusinessException("0001", this.enumsService.getDescr((BaseEnums)DzcsInvoiceReturnFileType.LICENSE_FILE) + "\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)invoiceReturn.getApplyFile())) {
                throw new BusinessException("0001", this.enumsService.getDescr((BaseEnums)DzcsInvoiceReturnFileType.APPLY_FILE) + "\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)invoiceReturn.getRemarkFile())) {
                throw new BusinessException("0001", this.enumsService.getDescr((BaseEnums)DzcsInvoiceReturnFileType.REMARK_FILE) + "\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (DzcsWriteOffFlag.YES.getCode().equals(writeOffFlag) && !StringUtils.hasText((String)invoiceReturn.getRedFile())) {
                throw new BusinessException("0001", "\u9009\u62e9\u5df2\u62b5\u6263," + this.enumsService.getDescr((BaseEnums)DzcsInvoiceReturnFileType.RED_FILE) + "\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)invoiceReturn.getInvoiceFile())) {
                throw new BusinessException("0001", this.enumsService.getDescr((BaseEnums)DzcsInvoiceReturnFileType.INVOICE_FILE) + "\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (InvoiceClasses.ELECTRONIC_INVOICE.getCode().equals(billApplyInfo1.getInvoiceClasses())) {
            if (DzcsInvoiceReturnType.BROKEN.getCode().equals(type) || DzcsInvoiceReturnType.INVOICE_TYPE_WRONG.getCode().equals(type)) {
                throw new BusinessException("0001", "\u53d1\u7968\u7c7b\u522b\u4e3a\u7535\u5b50\u53d1\u7968\uff0c\u5219\u7968\u9762\u7834\u635f\u3001\u53d1\u7968\u7c7b\u578b\u6709\u8bef\u4e0d\u53ef\u9009");
            }
        } else if (InvoiceClasses.PAPER_INVOICE.getCode().equals(billApplyInfo1.getInvoiceClasses())) {
            if (DzcsInvoiceReturnType.ELECTRONIC_2_PAPER.getCode().equals(type)) {
                throw new BusinessException("0001", "\u53d1\u7968\u7c7b\u522b\u4e3a\u7eb8\u8d28\u53d1\u7968\uff0c\u5219\u7535\u5b50\u53d1\u7968\u6362\u7eb8\u8d28\u53d1\u7968\u4e0d\u53ef\u9009");
            }
            if (!StringUtils.hasText((String)mailCompany)) {
                throw new BusinessException("0001", "\u5feb\u9012\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)mailTicketNo)) {
                throw new BusinessException("0001", "\u5feb\u9012\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
        saleInvoiceInfoVO.setInvoiceNoList(invoiceNos);
        List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
        if (saleInvoiceInfos.size() < invoiceNos.size()) {
            throw new BusinessException("0001", "\u52fe\u9009\u7684\u53d1\u7968\u4e0d\u5b58\u5728");
        }
        InvoiceReturnDetailVO vo = new InvoiceReturnDetailVO();
        vo.setInvoiceNo1s(invoiceNos);
        vo.setStatusNotIn(Arrays.asList(InvoiceReturnStatus.REJECTED.getCode(), InvoiceReturnStatus.CANCELED.getCode()));
        List<InvoiceReturnDetail> invoiceReturnDetails = this.invoiceReturnDetailMapper.selectListJoin(vo);
        if (!CollectionUtils.isEmpty(invoiceReturnDetails)) {
            ArrayList<String> invoiceNoList = new ArrayList<String>();
            for (InvoiceReturnDetail invoiceReturnDetail : invoiceReturnDetails) {
                invoiceNoList.add(invoiceReturnDetail.getInvoiceNo1());
            }
            throw new BusinessException("0001", "\u53d1\u7968\u53f7\u7801" + invoiceNoList + "\u5df2\u7ecf\u7533\u8bf7\u9000\u7968\uff0c\u4e0d\u80fd\u91cd\u590d\u7533\u8bf7\u9000\u7968");
        }
        invoiceReturn = new InvoiceReturn();
        invoiceReturn.setBillNo(billNo);
        invoiceReturn.setType(type);
        invoiceReturn.setRemark(remark);
        invoiceReturn.setStatus(InvoiceReturnStatus.TO_APPROVE.getCode());
        invoiceReturn.setOperUnitNo(billApplyInfo1.getOperUnitNo());
        invoiceReturn.setMailCompany(mailCompany);
        invoiceReturn.setMailTicketNo(mailTicketNo);
        invoiceReturn.setCreateUser(createUser);
        invoiceReturn.setCreatePhone(createPhone);
        invoiceReturn.setCreateOrg(createOrg);
        invoiceReturn.setCreateDate(new Date());
        invoiceReturn.setRefundType(refundType);
        invoiceReturn.setWriteOffFlag(writeOffFlag);
        invoiceReturn.setPurchaseProjectId(billApplyInfo1.getPurchaseProjectId());
        this.invoiceReturnMapper.updateByPrimaryKeySelective(invoiceReturn);
        for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfos) {
            InvoiceReturnDetail invoiceReturnDetail = new InvoiceReturnDetail();
            invoiceReturnDetail.setBillNo(billNo);
            invoiceReturnDetail.setApplyNo1(saleInvoiceInfo.getApplyNo());
            invoiceReturnDetail.setInvoiceNo1(saleInvoiceInfo.getInvoiceNo());
            this.invoiceReturnDetailMapper.insert(invoiceReturnDetail);
        }
        DzcsInvoiceReturnApplyRspBO rspBO = new DzcsInvoiceReturnApplyRspBO();
        rspBO.setMsg(null);
        return rspBO;
    }
}

