/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.base.PayBaseService;
import com.tydic.fsc.settle.bo.FscBaseReqBo;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.PayAddPlatfUseFeeService;
import com.tydic.fsc.settle.busi.api.bo.PayAddPlatfUseFeeReqBO;
import com.tydic.fsc.settle.dao.InquiryPayOrderMapper;
import com.tydic.fsc.settle.dao.po.InquiryPayOrder;
import com.tydic.fsc.settle.enums.InquiryApprovalStatus;
import com.tydic.fsc.settle.enums.InquiryMailStatus;
import com.tydic.fsc.settle.enums.InquiryPayFeeType;
import com.tydic.fsc.settle.enums.InquiryPaymentStatus;
import com.tydic.fsc.settle.enums.OrderStatus;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayAddPlatfUseFeeServiceImpl
extends PayBaseService<FscBaseRspBo>
implements PayAddPlatfUseFeeService {
    private static final Logger logger = LoggerFactory.getLogger(PayAddPlatfUseFeeServiceImpl.class);
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;

    public FscBaseRspBo addPlatfUseFee(PayAddPlatfUseFeeReqBO reqBO) {
        FscBaseRspBo rspBO = (FscBaseRspBo)this.queryRspOrSaveLog((FscBaseReqBo)reqBO);
        if (rspBO != null) {
            return rspBO;
        }
        try {
            rspBO = this.addPlatfUseFee2(reqBO);
        }
        catch (Exception e) {
            logger.error("\u5931\u8d25", (Throwable)e);
            this.updateLog((FscBaseReqBo)reqBO, e);
            throw new BusinessException("18000", e.getMessage());
        }
        this.updateLog((FscBaseReqBo)reqBO, rspBO);
        return rspBO;
    }

    public FscBaseRspBo addPlatfUseFee2(PayAddPlatfUseFeeReqBO reqBO) {
        logger.debug("\u65b0\u589e\u5e73\u53f0\u4f7f\u7528\u8d39\u7f34\u8d39\u5355\u529f\u80fdStart......");
        if (null == reqBO.getPayOrderNo()) {
            throw new BusinessException("0001", "\u7f34\u8d39\u8ba2\u5355\u53f7[payOrderNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderDate()) {
            throw new BusinessException("0001", "\u8ba2\u5355\u65e5\u671f[orderDate]\u4e3a\u7a7a");
        }
        if (null == reqBO.getMaterialsClass()) {
            throw new BusinessException("0001", "\u7269\u8d44\u5206\u7c7b[materialsClass]\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new BusinessException("0001", "\u7f34\u8d39\u5355\u4f4d\u7f16\u53f7[supplierId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getCompanyType()) {
            throw new BusinessException("0001", "\u7f34\u8d39\u5355\u4f4d\u7c7b\u578b[companyType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayMoney()) {
            throw new BusinessException("0001", "\u7f34\u8d39\u91d1\u989d[payMoney]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperUnitNo()) {
            throw new BusinessException("0001", "\u6536\u6b3e\u5355\u4f4d\u673a\u6784\u53f7[operUnitNo]\u4e3a\u7a7a");
        }
        InquiryPayOrder payOrderInfo = new InquiryPayOrder();
        payOrderInfo.setPayOrderNo(reqBO.getPayOrderNo());
        payOrderInfo.setInquiryNo(reqBO.getPayOrderNo());
        payOrderInfo.setOrderTime(reqBO.getOrderDate());
        String materialsClass = reqBO.getMaterialsClass();
        if (materialsClass.length() > 200) {
            materialsClass = materialsClass.substring(0, 196) + "...";
        }
        payOrderInfo.setMaterialsClass(materialsClass);
        payOrderInfo.setCompanyType(reqBO.getCompanyType().getCode());
        payOrderInfo.setOperUnitNo(reqBO.getOperUnitNo());
        payOrderInfo.setPayMoney(reqBO.getPayMoney());
        payOrderInfo.setSupplierId(reqBO.getSupplierId());
        payOrderInfo.setMark(reqBO.getMark());
        payOrderInfo.setPaymentStatus(InquiryPaymentStatus.NO_PAYMENT.getCode());
        payOrderInfo.setMailStatus(InquiryMailStatus.NOT_MAILING.getCode());
        payOrderInfo.setPayFeeType(InquiryPayFeeType.PLAT_USE_FEE.getCode());
        payOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        payOrderInfo.setApprovalStatus(InquiryApprovalStatus.UNSUBMITTED.getCode());
        logger.debug("\u6570\u636e\u5e93\u65b0\u589e\u7f34\u8d39\u8ba2\u5355\u53c2\u6570\uff1a" + payOrderInfo);
        this.inquiryPayOrderMapper.insert(payOrderInfo);
        logger.debug("\u65b0\u589e\u5e73\u53f0\u4f7f\u7528\u8d39\u7f34\u8d39\u5355\u529f\u80fdEnd......");
        return new FscBaseRspBo();
    }

    @Override
    protected FscBaseRspBo fillRspBO(String respPackage) {
        FscBaseRspBo rspBO = new FscBaseRspBo();
        JSONObject jsonObject = JSONObject.fromObject((Object)respPackage);
        rspBO.setRespCode(jsonObject.containsKey((Object)"respCode") ? jsonObject.getString("respCode") : null);
        rspBO.setRespDesc(jsonObject.containsKey((Object)"respDesc") ? jsonObject.getString("respDesc") : null);
        return rspBO;
    }
}

