/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.PayAddCheckingRstService;
import com.tydic.fsc.settle.busi.api.PayAddUnionSettleInfoService;
import com.tydic.fsc.settle.busi.api.bo.PayAddCheckingRstReqBO;
import com.tydic.fsc.settle.busi.api.bo.PayAddSettleInfoReqBO;
import com.tydic.fsc.settle.dao.UnionSettleInfoMapper;
import com.tydic.fsc.settle.dao.po.UnionSettleInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayAddUnionSettleInfoServiceImpl
implements PayAddUnionSettleInfoService {
    private static final Logger logger = LoggerFactory.getLogger(PayAddUnionSettleInfoServiceImpl.class);
    @Autowired
    private UnionSettleInfoMapper unionSettleInfoMapper;
    @Autowired
    private PayAddCheckingRstService payAddCheckingRstService;

    public FscBaseRspBo addSettleInfo(PayAddSettleInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5904\u7406\u8054\u52a8\u4f18\u52bf\u5bf9\u8d26\u6587\u4ef6\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        FscBaseRspBo rspBO = new FscBaseRspBo();
        Date settleDate = reqBO.getSettleDate();
        if (settleDate == null) {
            throw new BusinessException("0001", "\u5165\u53c2\u5bf9\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List lines = reqBO.getLines();
        if (lines == null || lines.isEmpty()) {
            return rspBO;
        }
        ArrayList<UnionSettleInfo> unionSettleInfos = new ArrayList<UnionSettleInfo>();
        for (String line : lines) {
            String[] fields = line.split(",");
            SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat dateFormat2 = new SimpleDateFormat("HHmmss");
            UnionSettleInfo unionSettleInfo = new UnionSettleInfo();
            unionSettleInfo.setMerId(fields[0]);
            unionSettleInfo.setGoodsId(fields[1]);
            unionSettleInfo.setMobileId(fields[2]);
            unionSettleInfo.setOrderId(fields[3]);
            Date merDate = null;
            try {
                merDate = dateFormat1.parse(fields[4]);
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u8054\u52a8\u4f18\u52bf\u5bf9\u8d26\u6587\u4ef6\u670d\u52a1\uff1a\u8ba2\u5355\u65e5\u671f[" + fields[4] + "]\u4e0d\u6b63\u786e", (Throwable)e);
            }
            unionSettleInfo.setMerDate(merDate);
            Date payDate = null;
            try {
                payDate = dateFormat1.parse(fields[5]);
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u8054\u52a8\u4f18\u52bf\u5bf9\u8d26\u6587\u4ef6\u670d\u52a1\uff1a\u652f\u4ed8\u65e5\u671f[" + fields[5] + "]\u4e0d\u6b63\u786e", (Throwable)e);
            }
            unionSettleInfo.setPayDate(payDate);
            BigDecimal amount = null;
            try {
                amount = new BigDecimal(fields[6]).divide(new BigDecimal("100"));
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u8054\u52a8\u4f18\u52bf\u5bf9\u8d26\u6587\u4ef6\u670d\u52a1\uff1a\u91d1\u989d[" + fields[6] + "]\u4e0d\u6b63\u786e", (Throwable)e);
            }
            unionSettleInfo.setAmount(amount);
            unionSettleInfo.setAmtType(fields[7]);
            unionSettleInfo.setBankType(fields[8]);
            Date settleDate2 = null;
            try {
                settleDate2 = dateFormat1.parse(fields[9]);
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u8054\u52a8\u4f18\u52bf\u5bf9\u8d26\u6587\u4ef6\u670d\u52a1\uff1a\u5bf9\u8d26\u65e5\u671f[" + fields[9] + "]\u4e0d\u6b63\u786e", (Throwable)e);
            }
            unionSettleInfo.setSettleDate(settleDate2);
            unionSettleInfo.setTransType(fields[10]);
            unionSettleInfo.setTransState(fields[11]);
            unionSettleInfo.setBankCheck(fields[12]);
            unionSettleInfo.setProductId(fields[13]);
            unionSettleInfo.setRefundNo(fields[14]);
            Date transTime = null;
            try {
                transTime = dateFormat2.parse(fields[15]);
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u8054\u52a8\u4f18\u52bf\u5bf9\u8d26\u6587\u4ef6\u670d\u52a1\uff1a\u4ea4\u6613\u6210\u529f\u65f6\u95f4[" + fields[15] + "]\u4e0d\u6b63\u786e", (Throwable)e);
            }
            unionSettleInfo.setTransTime(transTime);
            unionSettleInfos.add(unionSettleInfo);
        }
        for (UnionSettleInfo unionSettleInfo : unionSettleInfos) {
            int count;
            UnionSettleInfo settleInfo = this.unionSettleInfoMapper.queryInfoByOrderId(unionSettleInfo.getOrderId());
            if (null == settleInfo) {
                count = this.unionSettleInfoMapper.addSettleInfo(unionSettleInfo);
                logger.debug("\u5904\u7406\u8054\u52a8\u4f18\u52bf\u5bf9\u8d26\u6587\u4ef6\u670d\u52a1\uff1a\u65b0\u589e" + count + "\u6761\u5bf9\u8d26\u6587\u4ef6\u884c\u8bb0\u5f55[\u4ea4\u6613\u6d41\u6c34\u53f7=" + unionSettleInfo.getOrderId() + "]");
                continue;
            }
            count = this.unionSettleInfoMapper.updateSettleInfo(unionSettleInfo);
            logger.debug("\u5904\u7406\u8054\u52a8\u4f18\u52bf\u5bf9\u8d26\u6587\u4ef6\u670d\u52a1\uff1a\u66f4\u65b0" + count + "\u6761\u5bf9\u8d26\u6587\u4ef6\u884c\u8bb0\u5f55[\u4ea4\u6613\u6d41\u6c34\u53f7=" + unionSettleInfo.getOrderId() + "]");
        }
        PayAddCheckingRstReqBO payAddCheckingRstReqBO = new PayAddCheckingRstReqBO();
        payAddCheckingRstReqBO.setSettleDate(settleDate);
        FscBaseRspBo rspBusiBaseBO = this.payAddCheckingRstService.addCheckingRst(payAddCheckingRstReqBO);
        if (rspBusiBaseBO == null) {
            logger.error("\u5904\u7406\u8054\u52a8\u4f18\u52bf\u5bf9\u8d26\u6587\u4ef6\u670d\u52a1\uff1a\u5bf9\u8d26\u5931\u8d25");
        }
        return rspBO;
    }
}

