/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.PayPlatfUseFeeListService;
import com.tydic.fsc.settle.busi.api.bo.PayPlatfUseFeeListReqBO;
import com.tydic.fsc.settle.busi.api.bo.PayPlatfUseFeeListRspBO;
import com.tydic.fsc.settle.busi.api.bo.PayPlatfUseFeeRspBO;
import com.tydic.fsc.settle.busi.impl.PayAddTradeServiceFeeServiceImpl;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.InquiryPayOrderMapper;
import com.tydic.fsc.settle.dao.MainAcctInfoMapper;
import com.tydic.fsc.settle.dao.SubAcctInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.InquiryPayOrder;
import com.tydic.fsc.settle.dao.po.InquiryPayOrderExt;
import com.tydic.fsc.settle.dao.po.MainAcctInfo;
import com.tydic.fsc.settle.dao.po.SubAcctInfo;
import com.tydic.fsc.settle.enums.CompanyType;
import com.tydic.fsc.settle.enums.InquiryApprovalStatus;
import com.tydic.fsc.settle.enums.InquiryMailStatus;
import com.tydic.fsc.settle.enums.InquiryPayFeeType;
import com.tydic.fsc.settle.enums.InquiryPayPass;
import com.tydic.fsc.settle.enums.InquiryPaymentStatus;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.OrderStatus;
import com.tydic.fsc.settle.enums.SubAccountServiceType;
import com.tydic.fsc.settle.enums.YesNo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PayPlatfUseFeeListServiceImpl
implements PayPlatfUseFeeListService {
    private static final Logger logger = LoggerFactory.getLogger(PayAddTradeServiceFeeServiceImpl.class);
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private MainAcctInfoMapper mainAcctInfoMapper;
    @Autowired
    private SubAcctInfoMapper subAcctInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;

    public PayPlatfUseFeeListRspBO platfUseFeeList(PayPlatfUseFeeListReqBO reqBO) {
        boolean bool;
        PayPlatfUseFeeListRspBO rspBO = new PayPlatfUseFeeListRspBO();
        Long supplierId = null;
        Long operUnitNo = null;
        if (reqBO.getSupId() != null && reqBO.getSupId() > 0L) {
            supplierId = reqBO.getSupId();
            operUnitNo = reqBO.getOperUnitNo();
        } else {
            if (null == reqBO.getCompanyId()) {
                throw new BusinessException("0001", "\u4f9b\u5e94\u5546Id\u548c\u4e13\u4e1a\u516c\u53f8Id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
            }
            supplierId = reqBO.getSupplierId();
            operUnitNo = reqBO.getCompanyId();
        }
        ArrayList<PayPlatfUseFeeRspBO> rows = null;
        List<InquiryPayOrder> list = null;
        InquiryPayOrderExt payOrderInfoExt = new InquiryPayOrderExt();
        int idx = (reqBO.getPageNo() - 1) * reqBO.getPageSize();
        if (idx < 0) {
            idx = 0;
        }
        payOrderInfoExt.setRowIndex(idx);
        payOrderInfoExt.setPageSize(reqBO.getPageSize());
        ArrayList<String> unpayList = new ArrayList<String>();
        unpayList.add(InquiryPaymentStatus.NO_PAYMENT.getCode());
        unpayList.add(InquiryPaymentStatus.IN_PAYMENT.getCode());
        unpayList.add(InquiryPaymentStatus.TERMINATED.getCode());
        boolean bl = bool = reqBO.getPaymentStatusSet() == null && unpayList.contains(reqBO.getPaymentStatus()) || reqBO.getPaymentStatusSet() != null && unpayList.contains(reqBO.getPaymentStatusSet().iterator().next());
        if (bool) {
            payOrderInfoExt.setSortOrder("ORDER_TIME DESC");
        } else {
            payOrderInfoExt.setSortOrder("PAY_FINSH_TIME DESC");
        }
        payOrderInfoExt.setInquiryNo(reqBO.getInquiryNo());
        payOrderInfoExt.setPaymentStatus(reqBO.getPaymentStatus());
        payOrderInfoExt.setPaymentStatusSet(reqBO.getPaymentStatusSet());
        payOrderInfoExt.setOrderStatus(reqBO.getOrderStatus());
        payOrderInfoExt.setOrderStatusSet(reqBO.getOrderStatusSet());
        payOrderInfoExt.setPayPass(reqBO.getPayPass());
        payOrderInfoExt.setMaterialsClass(reqBO.getMaterialsClass());
        payOrderInfoExt.setOperUnitNo(operUnitNo);
        payOrderInfoExt.setSupplierId(supplierId);
        payOrderInfoExt.setApprovalStatus(reqBO.getApprovalStatus());
        payOrderInfoExt.setPayFeeType(InquiryPayFeeType.PLAT_USE_FEE.getCode());
        payOrderInfoExt.setUrgedInvoice(reqBO.getUrgedInvoice());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (null != reqBO.getOrderDateBegin()) {
                payOrderInfoExt.setOrderDateBegin(sdf.parse(reqBO.getOrderDateBegin()));
            }
            if (null != reqBO.getOrderDateEnd()) {
                payOrderInfoExt.setOrderDateEnd(sdf.parse(reqBO.getOrderDateEnd()));
            }
        }
        catch (ParseException e) {
            throw new BusinessException("0001", "\u8f93\u5165\u7684\u65f6\u95f4\u7c7b\u578b\u6709\u8bef");
        }
        int total = 0;
        int recordsTotal = this.inquiryPayOrderMapper.getCount(payOrderInfoExt);
        if (recordsTotal > 0) {
            total = recordsTotal / reqBO.getPageSize() + (recordsTotal % reqBO.getPageSize() > 0 ? 1 : 0);
            list = this.inquiryPayOrderMapper.getList(payOrderInfoExt);
        }
        if (null != list) {
            rows = new ArrayList<PayPlatfUseFeeRspBO>();
            for (InquiryPayOrder inquiryPayOrder : list) {
                BillApplyInfo billApplyInfo;
                PayPlatfUseFeeRspBO ppu = new PayPlatfUseFeeRspBO();
                BeanUtils.copyProperties((Object)inquiryPayOrder, (Object)ppu);
                ppu.setPayPassDesc(this.enumsService.getDescr(InquiryPayPass.getInstance(inquiryPayOrder.getPayPass())));
                ppu.setPaymentStatusDesc(this.enumsService.getDescr(InquiryPaymentStatus.getInstance(inquiryPayOrder.getPaymentStatus())));
                ppu.setOrderStatusDesc(this.enumsService.getDescr(OrderStatus.getInstance(inquiryPayOrder.getOrderStatus())));
                ppu.setMailStatusDesc(this.enumsService.getDescr(InquiryMailStatus.getInstance(inquiryPayOrder.getMailStatus())));
                ppu.setCompanyTypeDesc(this.enumsService.getDescr(CompanyType.convert(inquiryPayOrder.getCompanyType())));
                if (reqBO.getSupId() != null && reqBO.getSupId() > 0L) {
                    String operUnitName = this.organizationInfoService.queryOrgName(inquiryPayOrder.getOperUnitNo());
                    ppu.setOperUnitName(operUnitName);
                } else {
                    String supplierName = this.organizationInfoService.querySupplierName(inquiryPayOrder.getSupplierId());
                    ppu.setSupplierName(supplierName);
                }
                ppu.setApprovalStatusDesc(this.enumsService.getDescr(InquiryApprovalStatus.getInstance(inquiryPayOrder.getApprovalStatus())));
                MainAcctInfo mainAcctInfo = this.mainAcctInfoMapper.selectByPrimaryKey(ppu.getOperUnitNo(), OrderSource.CONSULT_PRICE.getCode());
                if (mainAcctInfo != null) {
                    ppu.setOpenBank(mainAcctInfo.getOpenBank());
                    SubAcctInfo subAcctInfo = this.subAcctInfoMapper.selectPKByServiceTypeAndMainAcct(SubAccountServiceType.PLATFORM_FEE.getCode(), mainAcctInfo.getMainAcctNo());
                    if (subAcctInfo != null) {
                        ppu.setSubAcctNo(subAcctInfo.getSubAcctNo());
                    }
                }
                if (null != (billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(inquiryPayOrder.getApplyNo()))) {
                    if (!StringUtils.hasText((String)billApplyInfo.getUrgedInvoice())) {
                        billApplyInfo.setUrgedInvoice(YesNo.NO.getCode());
                    }
                    ppu.setUrgedInvoiceDescr(this.enumsService.getDescr(YesNo.getInstance(billApplyInfo.getUrgedInvoice())));
                }
                rows.add(ppu);
            }
        } else {
            logger.info("\u67e5\u8be2\u5e73\u53f0\u4f7f\u7528\u8d39\u7f34\u8d39\u5355\u5217\u8868\u96c6\u5408\u7ed3\u679c\u4e3a\u7a7a");
        }
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(total);
        rspBO.setRows(rows);
        return rspBO;
    }
}

