/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.busi.api.QueryEntryTotalInfoService;
import com.tydic.fsc.settle.busi.api.bo.BusiEntryTotalInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.EntryTotalInfoBO;
import com.tydic.fsc.settle.busi.api.bo.PurchaseOrderDetailInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.QueryEntryTotalInfoReqBO;
import com.tydic.fsc.settle.dao.EntryInfoMapper;
import com.tydic.fsc.settle.dao.EntryTotalInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.EntryInfoPO;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.dao.vo.EntryTotalInfoVO;
import com.tydic.fsc.settle.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.WFStatus;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryEntryTotalInfoServiceImpl
implements QueryEntryTotalInfoService {
    private static final Logger logger = LoggerFactory.getLogger(QueryEntryTotalInfoServiceImpl.class);
    @Autowired
    private EntryTotalInfoMapper entryTotalInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private EntryInfoMapper entryInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    public BusiEntryTotalInfoRspBO<EntryTotalInfoBO> queryListPage(QueryEntryTotalInfoReqBO queryEntryTotalInfoReqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5165\u5e93\u5355\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + queryEntryTotalInfoReqBO.toString());
        }
        if (StringUtils.isEmpty((CharSequence)queryEntryTotalInfoReqBO.getSource()) || queryEntryTotalInfoReqBO.getSource() == null) {
            throw new BusinessException("18000", "\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orderBy = "t.DOCUMENTATION_DATE DESC,t.APPLY_NO DESC";
        EntryTotalInfoVO entryTotalInfoVO = new EntryTotalInfoVO();
        BeanUtils.copyProperties((Object)queryEntryTotalInfoReqBO, (Object)entryTotalInfoVO);
        BusiEntryTotalInfoRspBO rspPageBO = new BusiEntryTotalInfoRspBO();
        Page page = new Page(queryEntryTotalInfoReqBO.getPageNo(), queryEntryTotalInfoReqBO.getPageSize());
        List<EntryTotalInfoVO> entryTotalInfoVOs = null;
        try {
            entryTotalInfoVOs = this.entryTotalInfoMapper.getListPageExt(entryTotalInfoVO, (Page<Map<String, Object>>)page, orderBy);
        }
        catch (Exception e) {
            logger.error("\u6761\u4ef6\u67e5\u8be2\u7269\u8d44\u6c47\u603b\u5355\u8bb0\u5f55\u5931\u8d25,\u67e5\u8be2\u6761\u4ef6\u4e3a\uff1a" + entryTotalInfoVO.toString() + "page=" + page + ",orderBy=" + orderBy, (Throwable)e);
            throw new BusinessException("18000", "\u6761\u4ef6\u67e5\u8be2\u7269\u8d44\u6c47\u603b\u5355\u8bb0\u5f55\u5931\u8d25");
        }
        if (null == entryTotalInfoVOs || entryTotalInfoVOs.isEmpty()) {
            logger.error("\u627e\u4e0d\u5230\u67e5\u8be2\u6761\u4ef6\u5bf9\u5e94\u7684\u7269\u8d44\u6c47\u603b\u5355\u8bb0\u5f55\uff0c\u67e5\u8be2\u6761\u4ef6\u4e3a\uff1a" + entryTotalInfoVO.toString() + "page=" + page + ",orderBy=" + orderBy);
            return rspPageBO;
        }
        ArrayList<EntryTotalInfoBO> entryTotalInfoBOs = new ArrayList<EntryTotalInfoBO>();
        for (EntryTotalInfoVO entryTotalInfo : entryTotalInfoVOs) {
            EntryTotalInfoBO entryTotalInfoBO = new EntryTotalInfoBO();
            BeanUtils.copyProperties((Object)entryTotalInfo, (Object)entryTotalInfoBO);
            String purchaseName = this.organizationInfoService.querySupplierName(entryTotalInfoBO.getPurchaseId());
            entryTotalInfoBO.setPurchaseName(purchaseName);
            logger.debug("\u4f9b\u5e94\u5546ID\u4e3a\uff1a" + entryTotalInfoBO.getPurchaseId() + "\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546\u540d\u79f0\u4e3a\uff1a" + purchaseName);
            String companyName = this.organizationInfoService.queryOrgName(entryTotalInfoBO.getCompanyId());
            entryTotalInfoBO.setCompanyName(companyName);
            logger.debug("\u586b\u62a5\u5355\u4f4dID\u4e3a" + entryTotalInfoBO.getCompanyId() + "\u5bf9\u5e94\u7684\u586b\u62a5\u5355\u4f4d\u540d\u79f0\u4e3a\uff1a" + companyName);
            entryTotalInfoBO.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)entryTotalInfo.getSource())));
            if (StringUtils.isNotBlank((CharSequence)entryTotalInfoBO.getApprovalStatus())) {
                entryTotalInfoBO.setApprovalStatusDescr(this.enumsService.getDescr(WFStatus.getInstance(entryTotalInfoBO.getApprovalStatus())));
            }
            entryTotalInfoBO.setLastOperator(this.userInfoService.queryUserNameByUserId(entryTotalInfo.getLastOperator()));
            entryTotalInfoBO.setDocumentationName(this.userInfoService.queryUserNameByUserId(entryTotalInfo.getDocumentationId()));
            LinkedList<PurchaseOrderDetailInfoRspBO> purchaseOrderDetailList = new LinkedList<PurchaseOrderDetailInfoRspBO>();
            LinkedList<String> purchaseOrderNameList = new LinkedList<String>();
            if (!"0".equals(this.enumsService.queryShowOrderCodeSwitch()) || !OrderSource.ELECTRIC_MARKET.getCode().equals(entryTotalInfo.getSource())) {
                EntryInfoPO entryInfo = new EntryInfoPO();
                entryInfo.setApplyNo(entryTotalInfo.getApplyNo());
                List<EntryInfoPO> entryInfoList = this.entryInfoMapper.getList(entryInfo);
                for (EntryInfoPO entryInfoPO : entryInfoList) {
                    if (OrderSource.ELECTRIC_MARKET.getCode().equals(entryInfoPO.getSource())) {
                        List<PayPurchaseOrderInfo> orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(entryInfoPO.getNotificationNo());
                        PurchaseOrderDetailInfoRspBO detailRspBO = null;
                        for (PayPurchaseOrderInfo singleOrder : orders) {
                            detailRspBO = new PurchaseOrderDetailInfoRspBO();
                            detailRspBO.setPurchaseOrderCode(singleOrder.getPurchaseOrderCode());
                            detailRspBO.setInspectionId(singleOrder.getInspectionId());
                            detailRspBO.setPurchaseOrderName(singleOrder.getPurchaseOrderName());
                            purchaseOrderDetailList.add(detailRspBO);
                            purchaseOrderNameList.add(singleOrder.getPurchaseOrderName());
                        }
                        continue;
                    }
                    PayPurchaseOrderInfoVO purchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
                    purchaseOrderInfoVO.setNotificationNo(entryInfoPO.getNotificationNo());
                    List<PayPurchaseOrderInfo> purchaseOrderInfos = this.payPurchaseOrderInfoMapper.getListByItemNotifNo(purchaseOrderInfoVO);
                    PurchaseOrderDetailInfoRspBO detailRspBO = null;
                    for (PayPurchaseOrderInfo purchaseOrder : purchaseOrderInfos) {
                        detailRspBO = new PurchaseOrderDetailInfoRspBO();
                        detailRspBO.setPurchaseOrderCode(purchaseOrder.getPurchaseOrderCode());
                        detailRspBO.setInspectionId(purchaseOrder.getInspectionId());
                        purchaseOrderDetailList.add(detailRspBO);
                        purchaseOrderNameList.add(purchaseOrder.getPurchaseOrderName());
                    }
                }
            }
            entryTotalInfoBO.setPurchaseOrderCodeList(purchaseOrderDetailList);
            entryTotalInfoBO.setPurchaseOrderNameList(purchaseOrderNameList);
            entryTotalInfoBOs.add(entryTotalInfoBO);
        }
        rspPageBO.setRows(entryTotalInfoBOs);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }
}

