/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrderService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.bo.ReceiveDetailBO;
import com.tydic.fsc.settle.atom.bo.SaleOrderBO;
import com.tydic.fsc.settle.busi.api.QueryPayableDetailByIdService;
import com.tydic.fsc.settle.busi.api.bo.PayableDetailBO;
import com.tydic.fsc.settle.busi.api.bo.QueryPayableDetailByIdReqBO;
import com.tydic.fsc.settle.busi.api.bo.QueryPayableDetailByIdRspBO;
import com.tydic.fsc.settle.dao.PayableDetailMapper;
import com.tydic.fsc.settle.dao.SupplierInfoMapper;
import com.tydic.fsc.settle.dao.po.PayableDetailPO;
import com.tydic.fsc.settle.dao.po.SupplierInfo;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.PayableStatus;
import com.tydic.fsc.settle.utils.FscStringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QueryPayableDetailByIdServiceImpl
implements QueryPayableDetailByIdService {
    private static final Logger logger = LoggerFactory.getLogger(QueryPayableDetailByIdServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Autowired
    private OrderService orderService;

    public QueryPayableDetailByIdRspBO queryById(QueryPayableDetailByIdReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5e94\u4ed8\u660e\u7ec6\u8868\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getIds())) {
            throw new BusinessException("18000", "\u5e94\u4ed8\u660e\u7ec6\u8868\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryPayableDetailByIdRspBO rspBO = new QueryPayableDetailByIdRspBO();
        List idList = reqBO.getIds();
        LinkedList<PayableDetailBO> payDetailBOList = new LinkedList<PayableDetailBO>();
        HashSet<Long> purchaseOrderIdsSet = new HashSet<Long>();
        for (String id : idList) {
            PayableDetailPO payableDetailPO = this.payableDetailMapper.getModelById(id);
            if (payableDetailPO == null) {
                throw new BusinessException("18000", "\u5e94\u4ed8\u7f16\u53f7:" + id + "\uff0c\u5728\u5e94\u4ed8\u5355\u8be6\u60c5\u67e5\u8be2\u4e2d\u65e0\u5339\u914d\u7ed3\u679c");
            }
            String payType = payableDetailPO.getPayType();
            if (OrderSource.ELECTRIC_AREA.getCode().equals(payableDetailPO.getSource()) || OrderSource.CONSULT_PRICE.getCode().equals(payableDetailPO.getSource()) || OrderSource.COAL_AREA.getCode().equals(payableDetailPO.getSource())) {
                rspBO.setContractNo(payableDetailPO.getPlaAgreementCode());
            } else {
                SupplierInfo supplierInfo = this.supplierInfoMapper.selectByPrimaryKey(payableDetailPO.getSupplierId());
                if (supplierInfo == null) {
                    throw new BusinessException("18000", "\u4f9b\u5e94\u5546:" + payableDetailPO.getSupplierId() + "\uff0c\u5728t_supplier_info\u8868\u4e2d\u672a\u914d\u7f6e");
                }
                rspBO.setContractNo(supplierInfo.getEffectContactNo());
            }
            rspBO.setSupplierId(String.valueOf(payableDetailPO.getSupplierId()));
            String supplierStr = this.organizationInfoService.querySupplierName(payableDetailPO.getSupplierId());
            rspBO.setSupplierName(supplierStr);
            PayableDetailBO payableDetailBO = new PayableDetailBO();
            BeanUtils.copyProperties((Object)payableDetailPO, (Object)payableDetailBO);
            payableDetailBO.setOrderId(FscStringUtils.valueOf(payableDetailPO.getOrderId()));
            if (payableDetailPO.getOrderId() != null) {
                purchaseOrderIdsSet.add(payableDetailPO.getOrderId());
            }
            BigDecimal payingAmt = payableDetailBO.getPayableAmt().subtract(payableDetailBO.getPendingAmt()).subtract(payableDetailBO.getPaidAmt());
            payableDetailBO.setPayingAmt(payingAmt);
            payableDetailBO.setSupplierStr(supplierStr);
            PayableStatus payableEnum = PayableStatus.getInstance(payableDetailBO.getPayableStatus());
            payableDetailBO.setPayableStatusStr(this.enumsService.getDescr(payableEnum));
            OrderSource orderSourceEnum = OrderSource.getInstance((String)payableDetailBO.getSource());
            payableDetailBO.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum));
            String orgNameStr = this.organizationInfoService.queryOrgName(payableDetailBO.getOperatorId());
            payableDetailBO.setOperatorStr(orgNameStr);
            SaleOrderBO saleOrderBO = this.orderService.obtainSaleOrder(payableDetailPO.getOrderId());
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setSource(payableDetailPO.getSource());
            saleOrderInfoVO.setOrderId(saleOrderBO.getSaleOrderId());
            saleOrderInfoVO.setSaleOrderCode(saleOrderBO.getSaleOrderCode());
            Map<String, ReceiveDetailBO> receiveDetail = this.orderService.obtainReceiveDetail(saleOrderInfoVO);
            payDetailBOList.add(payableDetailBO);
        }
        rspBO.setRows(payDetailBOList);
        return rspBO;
    }
}

