/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.comb.impl;

import com.tydic.fsc.settle.busi.api.FscWfEndDealSynchFinanceBusiService;
import com.tydic.fsc.settle.busi.api.bo.FscWfEndDealSynchFinanceBusiReqBO;
import com.tydic.fsc.settle.busi.api.bo.FscWfEndDealSynchFinanceBusiRspBO;
import com.tydic.fsc.settle.busi.api.bo.WorkFlowDataInfoBO;
import com.tydic.fsc.settle.comb.api.FscWfEndWithoutSynchFinanceCombService;
import com.tydic.fsc.settle.comb.api.bo.FscWfEndWithoutSynchFinanceCombReqBO;
import com.tydic.fsc.settle.comb.api.bo.FscWfEndWithoutSynchFinanceCombRspBO;
import com.tydic.fsc.settle.dao.WorkFlowDataMapper;
import com.tydic.fsc.settle.dao.po.WorkFlowDataInfo;
import com.tydic.fsc.settle.dao.vo.WorkFlowDataInfoVO;
import com.tydic.fsc.settle.enums.FinancialStatus;
import com.tydic.fsc.settle.enums.WFBillType;
import com.tydic.fsc.settle.enums.WFStatus;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="fscWfEndWithoutSynchFinanceCombService")
public class FscWfEndWithoutSynchFinanceCombServiceImpl
implements FscWfEndWithoutSynchFinanceCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscWfEndWithoutSynchFinanceCombServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private WorkFlowDataMapper workFlowDataMapper;
    private FscWfEndDealSynchFinanceBusiService fscWfEndDealSynchFinanceBusiService;

    @Autowired
    private FscWfEndWithoutSynchFinanceCombServiceImpl(WorkFlowDataMapper workFlowDataMapper, FscWfEndDealSynchFinanceBusiService fscWfEndDealSynchFinanceBusiService) {
        this.workFlowDataMapper = workFlowDataMapper;
        this.fscWfEndDealSynchFinanceBusiService = fscWfEndDealSynchFinanceBusiService;
    }

    public FscWfEndWithoutSynchFinanceCombRspBO dealWfEndWithoutSynchFinance(FscWfEndWithoutSynchFinanceCombReqBO reqBO) {
        List<WorkFlowDataInfo> workFlowDataInfoList;
        FscWfEndWithoutSynchFinanceCombRspBO rspBO = new FscWfEndWithoutSynchFinanceCombRspBO();
        WorkFlowDataInfoVO vo = new WorkFlowDataInfoVO();
        ArrayList<String> billTypeIn = new ArrayList<String>();
        billTypeIn.add(WFBillType.HANDMADE_COLLECTION.getCode());
        vo.setBillTypeIn(billTypeIn);
        vo.setProcInstId(reqBO.getProcInstId());
        vo.setStatus(WFStatus.APPROVAL_COMPLETE.getCode());
        vo.setFinancialStatus("'" + FinancialStatus.NO_SEND.getCode() + "','" + FinancialStatus.FAIL.getCode() + "'");
        try {
            workFlowDataInfoList = this.workFlowDataMapper.selectListByVO(vo);
            if (CollectionUtils.isEmpty(workFlowDataInfoList)) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u65e0\u4efb\u52a1\u9700\u8981\u5904\u7406");
                return rspBO;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u6570\u636e\u5e93\u8868workFlowDataMapper\u53d1\u751f\u5f02\u5e38\uff1a" + e.toString());
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u6570\u636e\u5e93\u5f02\u5e38");
            return rspBO;
        }
        int failed = 0;
        for (WorkFlowDataInfo wfDataInfo : workFlowDataInfoList) {
            String service = wfDataInfo.getFinishEvtService();
            if (!StringUtils.hasLength((String)service)) continue;
            FscWfEndDealSynchFinanceBusiReqBO withoutSynchFinanceBusiReqBO = new FscWfEndDealSynchFinanceBusiReqBO();
            WorkFlowDataInfoBO workFlowDataInfoBO = new WorkFlowDataInfoBO();
            BeanUtils.copyProperties((Object)wfDataInfo, (Object)workFlowDataInfoBO);
            withoutSynchFinanceBusiReqBO.setWorkFlowDataInfo(workFlowDataInfoBO);
            FscWfEndDealSynchFinanceBusiRspBO withoutSynchFinanceBusiRspBO = this.fscWfEndDealSynchFinanceBusiService.dealWfEndWithoutSynchFinance(withoutSynchFinanceBusiReqBO);
            if ("0000".equals(withoutSynchFinanceBusiRspBO.getRespCode())) continue;
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u5ba1\u6279\u7ed3\u675f\u5904\u7406\uff08\u4e0d\u53d1\u9001\u8d22\u52a1\uff09\u670d\u52a1\u5931\u8d25" + withoutSynchFinanceBusiRspBO.getRespDesc());
            }
            ++failed;
        }
        int total = workFlowDataInfoList.size();
        int successed = total - failed;
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u5ba1\u6279\u7ed3\u675f\u5904\u7406\uff08\u4e0d\u53d1\u9001\u8d22\u52a1\uff09\u670d\u52a1\u7ed3\u675f\uff0c\u4e00\u5171\u5904\u7406" + total + "\u6761\uff0c\u5176\u4e2d\u6210\u529f" + successed + "\u6761\uff0c\u5931\u8d25" + failed + "\u6761");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5ba1\u6279\u7ed3\u675f\u5904\u7406\uff08\u4e0d\u53d1\u9001\u8d22\u52a1\uff09\u670d\u52a1\u7ed3\u675f\uff0c\u4e00\u5171\u5904\u7406" + total + "\u6761\uff0c\u5176\u4e2d\u6210\u529f" + successed + "\u6761\uff0c\u5931\u8d25" + failed + "\u6761");
        return rspBO;
    }
}

