/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.settle.atom.DictionaryAtomService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.SubAccountRespInitService;
import com.tydic.fsc.settle.atom.bo.DictionaryAtomReqBo;
import com.tydic.fsc.settle.atom.bo.DictionaryAtomRspBo;
import com.tydic.fsc.settle.busi.api.bo.BusiSubAccountInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.enums.CompanyType;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.SubAccountServiceType;
import com.tydic.fsc.settle.enums.SubAccountStatus;
import com.tydic.fsc.supplier.bo.ProjectInfoBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="subAccountRespInitService")
public class SubAccountRespInitServiceImpl
implements SubAccountRespInitService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubAccountRespInitServiceImpl.class);
    private final OrganizationInfoService orgService;
    private final DictionaryAtomService dictionaryAtomService;

    @Autowired
    private SubAccountRespInitServiceImpl(OrganizationInfoService orgService, DictionaryAtomService dictionaryAtomService) {
        this.orgService = orgService;
        this.dictionaryAtomService = dictionaryAtomService;
    }

    @Override
    public void initRespBo(SubAcctInfoExt subAcct, BusiSubAccountInfoRspBO respBo) {
        CompanyType companyType;
        SubAccountStatus sta;
        SubAccountServiceType srvType;
        BeanUtils.copyProperties((Object)subAcct, (Object)respBo);
        respBo.setCreateUser(subAcct.getLoginId());
        respBo.setCreateOrgId(subAcct.getCreateOrgId());
        respBo.setUpdateUser(subAcct.getUpdateId());
        respBo.setUpdateOrgId(subAcct.getUpdateOrgId());
        respBo.setSubAcctNo(subAcct.getSubAcctNo());
        respBo.setAcctCompanyType(subAcct.getCompanyType());
        respBo.setAcctOrgId(subAcct.getOrgId());
        String name = this.orgService.queryOrgName(subAcct.getOrgId());
        respBo.setAcctOrgName(name);
        ProjectInfoBO projectInfoFromAmcBO = this.orgService.queryProjectName(subAcct.getProjectId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u8c03\u4f1a\u5458\u8d26\u5957\u4fe1\u606f\u8be6\u60c5\u67e5\u8be2\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)projectInfoFromAmcBO));
        }
        respBo.setProjectDescr(projectInfoFromAmcBO.getAccountName());
        respBo.setVirtual(projectInfoFromAmcBO.getIsShadowAccount());
        respBo.setVirtualStr(projectInfoFromAmcBO.getIsShadowAccountStr());
        respBo.setSuperiorOrgName(this.orgService.queryOrgName(subAcct.getSuperiorOrgId()));
        OrderSource ordSource = OrderSource.getInstance((String)subAcct.getSource());
        if (ordSource != null) {
            DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
            dictionaryAtomReqBo.setCode(subAcct.getSource());
            dictionaryAtomReqBo.setpCode("ORDER_SOURCE");
            DictionaryAtomRspBo dictionaryAtomRspBo = this.dictionaryAtomService.qryDic(dictionaryAtomReqBo);
            name = "0000".equals(dictionaryAtomRspBo.getRespCode()) && !CollectionUtils.isEmpty(dictionaryAtomRspBo.getData()) ? dictionaryAtomRspBo.getData().get(subAcct.getSource()) : "";
            respBo.setSourceDescr(name);
        }
        if ((srvType = SubAccountServiceType.convert(subAcct.getServiceType())) != null) {
            DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
            dictionaryAtomReqBo.setCode(String.valueOf(subAcct.getServiceType()));
            dictionaryAtomReqBo.setpCode("SERVICE_TYPE");
            DictionaryAtomRspBo dictionaryAtomRspBo = this.dictionaryAtomService.qryDic(dictionaryAtomReqBo);
            name = "0000".equals(dictionaryAtomRspBo.getRespCode()) && !CollectionUtils.isEmpty(dictionaryAtomRspBo.getData()) ? dictionaryAtomRspBo.getData().get(String.valueOf(subAcct.getServiceType())) : "";
            respBo.setServiceTypeDescr(name);
        }
        if ((sta = SubAccountStatus.getCode(subAcct.getStatus())) != null) {
            DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
            dictionaryAtomReqBo.setCode(subAcct.getStatus());
            dictionaryAtomReqBo.setpCode("ACCT_STATUS");
            DictionaryAtomRspBo dictionaryAtomRspBo = this.dictionaryAtomService.qryDic(dictionaryAtomReqBo);
            name = "0000".equals(dictionaryAtomRspBo.getRespCode()) && !CollectionUtils.isEmpty(dictionaryAtomRspBo.getData()) ? dictionaryAtomRspBo.getData().get(subAcct.getStatus()) : "";
            respBo.setStatusDescr(name);
        }
        if ((companyType = CompanyType.convert(subAcct.getCompanyType())) != null) {
            respBo.setAcctCompanyTypeDescr(companyType.getDescr());
        }
    }
}

