/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.jd.open.api.sdk.domain.etms.TraceQueryJsf.TraceDTO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.JdExpressTokenService;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiApplyMailRemailService;
import com.tydic.fsc.settle.busi.api.bo.BusiApplyMailRemailReqBO;
import com.tydic.fsc.settle.busi.impl.BusiApplyMailForInvoiceRunnable;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceMailInfoMapper;
import com.tydic.fsc.settle.dao.po.JdexpressToken;
import com.tydic.fsc.settle.dao.po.SaleInvoiceMailInfo;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.InvoiceMailSentStatus;
import com.tydic.fsc.settle.utils.SpringApplicationContext;
import com.tydic.fsc.supplier.BusiJdExpressService;
import com.tydic.fsc.supplier.bo.JdexpressTokenVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class BusiApplyMailRemailServiceImpl
implements BusiApplyMailRemailService {
    private static final Logger logger = LoggerFactory.getLogger(BusiApplyMailRemailServiceImpl.class);
    @Autowired
    private SaleInvoiceMailInfoMapper saleInvoiceMailInfoMapper;
    @Autowired
    private BusiJdExpressService busiJdExpressConfigService;
    @Autowired
    private JdExpressTokenService jdExpressTokenService;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BusiJdExpressService busiJdExpressService;

    public FscBaseRspBo process(BusiApplyMailRemailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8865\u6253\u91cd\u53d1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getCompanyId() == null) {
            throw new BusinessException("0001", "\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List mailTicketNos = reqBO.getMailTicketNos();
        if (mailTicketNos == null || mailTicketNos.isEmpty()) {
            throw new BusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        DataSourceTransactionManager transactionManager = SpringApplicationContext.getTransactionManager();
        DefaultTransactionDefinition transDefinition = new DefaultTransactionDefinition();
        transDefinition.setPropagationBehavior(3);
        TransactionStatus transactionStatus = transactionManager.getTransaction((TransactionDefinition)transDefinition);
        List<BusiApplyMailForInvoiceRunnable> runnables = null;
        try {
            runnables = this.process2(reqBO);
            transactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25", (Throwable)e);
            transactionManager.rollback(transactionStatus);
            throw new BusinessException("18000", e.getMessage());
        }
        int size = runnables.size();
        logger.debug("\u9700\u8981\u90ae\u5bc4\u7684\u5feb\u9012\u5355\u6570\u91cf\uff1a" + size);
        int maxThreadSize = this.enumsService.queryMaxThreadSize();
        ExecutorService executorService = Executors.newFixedThreadPool(size > maxThreadSize ? maxThreadSize : size);
        CountDownLatch latch = new CountDownLatch(size);
        for (BusiApplyMailForInvoiceRunnable runnable : runnables) {
            runnable.setLatch(latch);
            executorService.submit(runnable);
        }
        executorService.shutdown();
        try {
            latch.await(this.enumsService.queryMaxSleepTime(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return new FscBaseRspBo();
    }

    private List<BusiApplyMailForInvoiceRunnable> process2(BusiApplyMailRemailReqBO reqBO) {
        List mailTicketNos = reqBO.getMailTicketNos();
        JdexpressTokenVO tokenVO = new JdexpressTokenVO();
        JdexpressToken token = this.jdExpressTokenService.getToken(reqBO.getCompanyId());
        BeanUtils.copyProperties((Object)token, (Object)tokenVO);
        for (String mailTicketNo : mailTicketNos) {
            SaleInvoiceMailInfo mail = this.saleInvoiceMailInfoMapper.selectByPrimaryKey(mailTicketNo);
            if (InvoiceMailSentStatus.NOT_SENT.getCode().equals(mail.getMailStatus()) || InvoiceMailSentStatus.PROCCESSING.getCode().equals(mail.getMailStatus()) || InvoiceMailSentStatus.INVALID.getCode().equals(mail.getMailStatus())) {
                throw new BusinessException("18000", "\u5feb\u9012\u5355\u53f7:" + mailTicketNo + "\u7684\u72b6\u6001\u4e0d\u5141\u8bb8\u53d6\u6d88");
            }
            if (InvoiceMailSentStatus.SENT_FAIL.getCode().equals(mail.getMailStatus()) || !InvoiceMailSentStatus.SENT_SUCCESS.getCode().equals(mail.getMailStatus())) continue;
            List traceDTOList = this.busiJdExpressService.receiveTrace(mailTicketNo, tokenVO);
            boolean canCancel = false;
            if (traceDTOList != null) {
                for (TraceDTO traceDTO : traceDTOList) {
                    if (!"\u7ec8\u6b62\u63fd\u6536".equals(traceDTO.getOpeTitle()) && !"\u4e0b\u5355\u53d6\u6d88".equals(traceDTO.getOpeTitle())) continue;
                    canCancel = true;
                }
            }
            if (canCancel) continue;
            throw new BusinessException("18000", "\u5feb\u9012\u5355\u53f7:" + mailTicketNo + "\u7684\u7269\u6d41\u72b6\u6001\u4e0d\u662f\u7ec8\u6b62\u63fd\u6536\u3001\u4e0b\u5355\u53d6\u6d88\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88");
        }
        List newMailTicketNos = new ArrayList();
        int toMailCount = mailTicketNos.size();
        try {
            if (toMailCount > 100) {
                int circleTimes = toMailCount % 100 > 0 ? toMailCount / 100 + 1 : toMailCount / 100;
                for (int i = 0; i < circleTimes; ++i) {
                    int count = i == circleTimes - 1 && toMailCount % 100 > 0 ? toMailCount % 100 : 100;
                    newMailTicketNos.addAll(this.busiJdExpressConfigService.applyBillCode(count, tokenVO));
                }
            } else {
                newMailTicketNos = this.busiJdExpressConfigService.applyBillCode(toMailCount, tokenVO);
            }
        }
        catch (Exception e) {
            logger.error("\u7533\u8bf7\u5feb\u9012\u5355\u53f7\u5931\u8d25", (Throwable)e);
            throw new BusinessException("18000", "\u7533\u8bf7\u5feb\u9012\u5355\u53f7\u5931\u8d25");
        }
        if (null == newMailTicketNos) {
            throw new BusinessException("18000", "\u7533\u8bf7\u5feb\u9012\u5355\u53f7\u5931\u8d25");
        }
        if (newMailTicketNos.size() < toMailCount) {
            logger.error("\u6ca1\u6709\u7533\u8bf7\u5230\u8db3\u591f\u6570\u91cf\u7684\u5feb\u9012\u5355\u53f7\uff0c\u9700\u8981\u7684\u6570\u91cf\uff1a" + toMailCount + "\uff0c\u7533\u8bf7\u7684\u6570\u91cf\uff1a" + newMailTicketNos.size());
            throw new BusinessException("18000", "\u6ca1\u6709\u7533\u8bf7\u5230\u8db3\u591f\u6570\u91cf\u7684\u5feb\u9012\u5355\u53f7");
        }
        ArrayList<BusiApplyMailForInvoiceRunnable> runnables = new ArrayList<BusiApplyMailForInvoiceRunnable>();
        for (int i = 0; i < mailTicketNos.size(); ++i) {
            String oldMailTicketNo = (String)mailTicketNos.get(i);
            String newMailTicketNo = (String)newMailTicketNos.get(i);
            this.cancelAndRemail(oldMailTicketNo, newMailTicketNo, reqBO.getUsername());
            BusiApplyMailForInvoiceRunnable runnable = new BusiApplyMailForInvoiceRunnable();
            runnable.setJdToken(tokenVO);
            runnable.setMailTicketNo(newMailTicketNo);
            runnables.add(runnable);
        }
        return runnables;
    }

    private void cancelAndRemail(String oldMailTicketNo, String newMailTicketNo, String createUser) {
        SaleInvoiceMailInfo oldMail = this.saleInvoiceMailInfoMapper.selectByPrimaryKey(oldMailTicketNo);
        SaleInvoiceMailInfo record = new SaleInvoiceMailInfo();
        record.setMailTicketNo(oldMailTicketNo);
        record.setMailStatus(InvoiceMailSentStatus.INVALID.getCode());
        this.saleInvoiceMailInfoMapper.updateByPrimaryKeySelective(record);
        SaleInvoiceMailInfo newMail = new SaleInvoiceMailInfo();
        BeanUtils.copyProperties((Object)oldMail, (Object)newMail);
        newMail.setMailTicketNo(newMailTicketNo);
        newMail.setMailStatus(InvoiceMailSentStatus.PROCCESSING.getCode());
        newMail.setJdAssignStatus(null);
        newMail.setFailReason(null);
        newMail.setCreateUser(createUser);
        newMail.setCreateDate(new Date());
        this.saleInvoiceMailInfoMapper.insert(newMail);
        SaleInvoiceInfoVO updateInvoiceVO = new SaleInvoiceInfoVO();
        updateInvoiceVO.setOldMailTicketNo(oldMailTicketNo);
        updateInvoiceVO.setMailTicketNo(newMailTicketNo);
        this.saleInvoiceInfoMapper.updateBy(updateInvoiceVO);
    }
}

