/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.BusiOrderHandUpService;
import com.tydic.fsc.settle.busi.api.bo.BusiOrderHandUpReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiOrderHandUpRspBO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.PayInvoiceInfo;
import com.tydic.fsc.settle.dao.po.PayItemInfo;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import com.tydic.fsc.settle.enums.OrderStatus;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusiOrderHandUpServiceImpl
implements BusiOrderHandUpService {
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    private PayItemInfoMapper payItemInfoMapper;
    private BillNotificationInfoMapper billNotificationInfoMapper;
    private PayInvoiceInfoMapper payInvoiceInfoMapper;

    @Autowired
    private BusiOrderHandUpServiceImpl(PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper, PayItemInfoMapper payItemInfoMapper, BillNotificationInfoMapper billNotificationInfoMapper, PayInvoiceInfoMapper payInvoiceInfoMapper) {
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
        this.payItemInfoMapper = payItemInfoMapper;
        this.billNotificationInfoMapper = billNotificationInfoMapper;
        this.payInvoiceInfoMapper = payInvoiceInfoMapper;
    }

    public BusiOrderHandUpRspBO updateHandUpOrder(BusiOrderHandUpReqBO reqBo) {
        PayInvoiceInfo invoiceInfo;
        if (CollectionUtils.isEmpty((Collection)reqBo.getInspectionIds())) {
            throw new BusinessException("0001", "\u8bf7\u52fe\u9009\u8ba2\u5355");
        }
        BusiOrderHandUpRspBO rspBo = new BusiOrderHandUpRspBO();
        List inspectionIds = reqBo.getInspectionIds();
        boolean flag = this.checkStatus(inspectionIds);
        if (!flag) {
            throw new BusinessException("18000", "\u8ba2\u5355\u72b6\u6001\u5fc5\u987b\u662f" + OrderStatus.APPLIED.getDescr());
        }
        String notificationNo = this.payPurchaseOrderInfoMapper.getNoficationNoByInspectionId((Long)inspectionIds.get(0));
        if (!StringUtils.hasText((String)notificationNo)) {
            throw new BusinessException("0001", "\u6839\u636e\u9a8c\u6536\u5355\u53f7[" + inspectionIds.get(0) + "]\u83b7\u53d6\u5f00\u7968\u901a\u77e5\u5355\u53f7\u5931\u8d25\u3002");
        }
        int update = this.payPurchaseOrderInfoMapper.updateHandStatusByInspectionIds(inspectionIds, OrderStatus.HANGING.getCode());
        if (update < 1) {
            throw new BusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
        }
        int update1 = this.payItemInfoMapper.updateHandStatusByInspectionIds(inspectionIds, OrderStatus.NO_APPLY.getCode());
        if (update1 < 1) {
            throw new BusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
        }
        int update3 = this.billNotificationInfoMapper.updateAmtByNotificationNo(notificationNo);
        if (update3 < 1) {
            throw new BusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
        }
        BillNotificationInfo notification = this.billNotificationInfoMapper.selectByPrimaryKey(notificationNo);
        if (notification.getAmt().compareTo(BigDecimal.ZERO) == 0) {
            notification = new BillNotificationInfo();
            notification.setNotificationNo(notificationNo);
            notification.setInvoiceStatus(NotificationInvoiceStatus.HAS_CANCEL.getCode());
            int update4 = this.billNotificationInfoMapper.updateByPrimaryKeySelective(notification);
            if (update4 < 1) {
                throw new BusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
            }
            return rspBo;
        }
        List<PayInvoiceInfo> payInvoiceInfoList = this.payInvoiceInfoMapper.selectByNotifyNo(notificationNo);
        if (!payInvoiceInfoList.isEmpty() && (invoiceInfo = payInvoiceInfoList.get(0)).getAmt().compareTo(notification.getAmt()) >= 0) {
            notification = new BillNotificationInfo();
            notification.setNotificationNo(notificationNo);
            notification.setInvoiceStatus(NotificationInvoiceStatus.HAS_MAKE.getCode());
            int update5 = this.billNotificationInfoMapper.updateByPrimaryKeySelective(notification);
            if (update5 < 1) {
                throw new BusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
            }
            PayPurchaseOrderInfo payOrderUpd = new PayPurchaseOrderInfo();
            payOrderUpd.setNotificationNo(notificationNo);
            payOrderUpd.setOrderStatus(OrderStatus.SEND_BILL.getCode());
            int update6 = this.payPurchaseOrderInfoMapper.updateStatus(payOrderUpd);
            if (update6 < 1) {
                throw new BusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
            }
            PayItemInfo payItemUpd = new PayItemInfo();
            payItemUpd.setNotificationNo(notificationNo);
            payItemUpd.setItemStatus(OrderStatus.SEND_BILL.getCode());
            payItemUpd.setInvoiceCode(invoiceInfo.getInvoiceCode());
            payItemUpd.setInvoiceNo(invoiceInfo.getInvoiceNo());
            int update7 = this.payItemInfoMapper.updateByPrimaryKeySelective(payItemUpd);
            if (update7 < 1) {
                throw new BusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
            }
        }
        return rspBo;
    }

    private boolean checkStatus(List<Long> inspectionIds) {
        boolean flag = false;
        int count = this.payPurchaseOrderInfoMapper.getNotAppliedCountByInspectionIds(inspectionIds, OrderStatus.APPLIED.getCode());
        if (count == 0) {
            flag = true;
        }
        return flag;
    }
}

