/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.bo.FscPageReqBo;
import com.tydic.fsc.settle.busi.api.BusiQueryBillApplyInfoDlzqService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryBillApplyInfoDetailDlzqRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryBillApplyInfoDlzqReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryBillApplyInfoDlzqRspBO;
import com.tydic.fsc.settle.busi.api.bo.SaleOrderDetailInfoRspBO;
import com.tydic.fsc.settle.busi.api.vo.InvoiceInfoVO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.po.SaleOrderInfo;
import com.tydic.fsc.settle.dao.vo.BillApplyInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.fsc.settle.utils.BusinessUtils;
import com.tydic.fsc.settle.utils.FscStringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryBillApplyInfoDlzqServiceImpl
implements BusiQueryBillApplyInfoDlzqService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryBillApplyInfoDlzqServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UserInfoService userInfoService;

    public BusiQueryBillApplyInfoDlzqRspBO query(BusiQueryBillApplyInfoDlzqReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u670d\u52a1(\u7535\u529b\u4e13\u533a\u3001\u8be2\u6bd4\u4ef7\u3001\u7164\u70ad\u4e13\u533a)(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSource())) {
            throw new BusinessException("0001", "\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getIsOperUnit())) {
            throw new BusinessException("0001", "\u662f\u5426\u4e13\u4e1a\u516c\u53f8\u7528\u6237\u3010isOperUnit\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("0".equals(reqBO.getIsOperUnit()) && reqBO.getPurchaseNo() == null) {
            throw new BusinessException("0001", "\u91c7\u8d2d\u5355\u4f4d\u3010purchaseNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)billApplyInfoVO);
        billApplyInfoVO.setCondition1(" t.PAY_FEE_TYPE is null");
        if (null != reqBO.getUserNameLike() && StringUtils.hasText((String)reqBO.getUserNameLike())) {
            List<Long> userIdList = this.userInfoService.queryUserIdListByUserNameLike(reqBO.getUserNameLike());
            if (userIdList.isEmpty()) {
                userIdList.add(-1L);
            }
            billApplyInfoVO.setUserIdList(userIdList);
        }
        Long operUnitNo = null;
        operUnitNo = "1".equals(reqBO.getIsOperUnit()) ? BusinessUtils.judgeOperUnitNo(reqBO.getOperUnitNo(), reqBO.getCompanyId(), false) : BusinessUtils.judgeOperUnitNo(reqBO.getOperUnitNo(), reqBO.getCompanyId(), true);
        billApplyInfoVO.setOperUnitNo(operUnitNo);
        if (billApplyInfoVO.getApplyDateEnd() != null) {
            try {
                String applyDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(billApplyInfoVO.getApplyDateEnd()) + " 23:59:59";
                billApplyInfoVO.setApplyDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(applyDateEndString));
            }
            catch (ParseException e) {
                throw new BusinessException("18000", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
            }
        }
        billApplyInfoVO.setReturnBillNoIsNull("1");
        String orderBy = FscStringUtils.obtainOrderBy((FscPageReqBo)reqBO, "d_bill_apply_info", "t.APPLY_NO DESC");
        billApplyInfoVO.setOrderBy(orderBy);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<BillApplyInfo> billApplyInfoList = null;
        billApplyInfoList = reqBO.getInvoiceNoStart() == null && reqBO.getInvoiceNoEnd() == null && reqBO.getInvoiceDateStart() == null && reqBO.getInvoiceDateEnd() == null ? this.billApplyInfoMapper.getListPage(billApplyInfoVO, (Page<Map<String, Object>>)page) : this.billApplyInfoMapper.getListPageForQryBillApply(billApplyInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQueryBillApplyInfoDetailDlzqRspBO> rows = new ArrayList<BusiQueryBillApplyInfoDetailDlzqRspBO>();
        for (BillApplyInfo billApplyInfo : billApplyInfoList) {
            BusiQueryBillApplyInfoDetailDlzqRspBO row = new BusiQueryBillApplyInfoDetailDlzqRspBO();
            BeanUtils.copyProperties((Object)billApplyInfo, (Object)row);
            SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setApplyNo(billApplyInfo.getApplyNo());
            saleInvoiceInfoVO.setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode());
            List<SaleInvoiceInfo> saleInvoiceInfoList = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
            String invoiceNos = "";
            String invoiceDates = "";
            ArrayList<InvoiceInfoVO> invoiceInfoVO = new ArrayList<InvoiceInfoVO>();
            if (saleInvoiceInfoList != null && !saleInvoiceInfoList.isEmpty()) {
                for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfoList) {
                    InvoiceInfoVO vo = new InvoiceInfoVO();
                    vo.setInvoiceNo(saleInvoiceInfo.getInvoiceNo());
                    invoiceInfoVO.add(vo);
                    invoiceNos = invoiceNos + saleInvoiceInfo.getInvoiceNo() + ",";
                    invoiceDates = invoiceDates + new SimpleDateFormat("yyyy-MM-dd").format(saleInvoiceInfo.getInvoiceDate()) + ",";
                }
                invoiceNos = invoiceNos.substring(0, invoiceNos.length() - 1);
                invoiceDates = invoiceDates.substring(0, invoiceDates.length() - 1);
            }
            row.setInvoiceInfoList(invoiceInfoVO);
            row.setInvoiceNos(invoiceNos);
            row.setInvoiceDates(invoiceDates);
            row.setBillStatusDescr(this.enumsService.getDescr(BillStatus.getInstance(billApplyInfo.getBillStatus())));
            row.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)row.getSource())));
            row.setProfessionalDepartDescr(this.organizationInfoService.queryOrgName(row.getProfessionalDepartId()));
            row.setServiceDepartDescr(this.organizationInfoService.queryServiceDepartName(row.getServiceDepartId()));
            row.setPurchaseProjectName(this.organizationInfoService.queryProjectName(row.getPurchaseProjectId()).getAccountName());
            row.setSupplierName(this.organizationInfoService.querySupplierName(row.getSupplierNo()));
            row.setBranchCompanyName(this.organizationInfoService.queryOrgName(billApplyInfo.getBranchCompany()));
            row.setSubUserName(this.userInfoService.queryUserNameByUserId(billApplyInfo.getUserId()));
            LinkedList<SaleOrderDetailInfoRspBO> saleOrderDetailList = new LinkedList<SaleOrderDetailInfoRspBO>();
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setApplyNo(billApplyInfo.getApplyNo());
            saleOrderInfoVO.setOperUnitNo(billApplyInfo.getOperUnitNo());
            saleOrderInfoVO.setSource(billApplyInfo.getSource());
            List<SaleOrderInfo> orderInfoList = this.saleOrderInfoMapper.getListByApplyNo(saleOrderInfoVO);
            for (SaleOrderInfo orderInfo : orderInfoList) {
                SaleOrderDetailInfoRspBO detailRspBO = new SaleOrderDetailInfoRspBO();
                detailRspBO.setInspectionId(orderInfo.getInspectionId());
                detailRspBO.setSaleOrderCode(orderInfo.getSaleOrderCode());
                detailRspBO.setSaleOrderName(orderInfo.getSaleOrderName());
                detailRspBO.setSupplierName(orderInfo.getSupplierName());
                saleOrderDetailList.add(detailRspBO);
            }
            row.setSaleOrderDetailList(saleOrderDetailList);
            rows.add(row);
        }
        BusiQueryBillApplyInfoDlzqRspBO rspBO = new BusiQueryBillApplyInfoDlzqRspBO();
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        return rspBO;
    }
}

