/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.busi.api.BusiQueryOutstockTotalService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryOutstockTotalReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryOutstockTotalRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryOutstockTotalShowRspBO;
import com.tydic.fsc.settle.busi.api.bo.SaleOrderDetailInfoRspBO;
import com.tydic.fsc.settle.dao.OutstockInfoMapper;
import com.tydic.fsc.settle.dao.OutstockTotalMapper;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.OutstockInfo;
import com.tydic.fsc.settle.dao.po.SaleOrderInfo;
import com.tydic.fsc.settle.dao.vo.OutstockInfoVO;
import com.tydic.fsc.settle.dao.vo.OutstockTotalVO;
import com.tydic.fsc.settle.dao.vo.QueryOutstockInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.WFStatus;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryOutstockTotalServiceImpl
implements BusiQueryOutstockTotalService {
    private final OutstockTotalMapper outstockTotalMapper;
    private final OrganizationInfoService organizationInfoService;
    private final EnumsService enumsService;
    private final UserInfoService userInfoService;
    private final OutstockInfoMapper outstockInfoMapper;
    private final SaleOrderInfoMapper saleOrderInfoMapper;

    public BusiQueryOutstockTotalServiceImpl(OutstockTotalMapper outstockTotalMapper, OrganizationInfoService organizationInfoService, EnumsService enumsService, UserInfoService userInfoService, OutstockInfoMapper outstockInfoMapper, SaleOrderInfoMapper saleOrderInfoMapper) {
        this.outstockTotalMapper = outstockTotalMapper;
        this.organizationInfoService = organizationInfoService;
        this.enumsService = enumsService;
        this.userInfoService = userInfoService;
        this.outstockInfoMapper = outstockInfoMapper;
        this.saleOrderInfoMapper = saleOrderInfoMapper;
    }

    public BusiQueryOutstockTotalRspBO queryListPage(BusiQueryOutstockTotalReqBO reqBO) {
        if (!StringUtils.hasText((String)reqBO.getSource())) {
            throw new BusinessException("0001", "\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiQueryOutstockTotalRspBO rspPageBO = new BusiQueryOutstockTotalRspBO();
        rspPageBO.setRespCode("0000");
        OutstockTotalVO outstockTotalVO = new OutstockTotalVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)outstockTotalVO);
        outstockTotalVO.setUserId(reqBO.getUserIdNew());
        outstockTotalVO.setOrgId(reqBO.getCompanyId());
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<OutstockTotalVO> list = this.outstockTotalMapper.getListPageExt(outstockTotalVO, (Page<Map<String, Object>>)page);
        if (CollectionUtils.isEmpty(list)) {
            rspPageBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u51fa\u5e93\u6c47\u603b\u5355");
            return rspPageBO;
        }
        LinkedList<BusiQueryOutstockTotalShowRspBO> outstockTotalList = new LinkedList<BusiQueryOutstockTotalShowRspBO>();
        for (OutstockTotalVO outstockTotal : list) {
            BusiQueryOutstockTotalShowRspBO showRspBO = new BusiQueryOutstockTotalShowRspBO();
            BeanUtils.copyProperties((Object)outstockTotal, (Object)showRspBO);
            showRspBO.setCompanyName(this.organizationInfoService.queryOrgName(outstockTotal.getOrgId()));
            showRspBO.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)outstockTotal.getSource())));
            showRspBO.setAmount(outstockTotal.getTaxAmt().add(outstockTotal.getUntaxAmt()));
            if (StringUtils.hasText((String)showRspBO.getApprovalStatus())) {
                showRspBO.setApprovalStatusDescr(this.enumsService.getDescr(WFStatus.getInstance(showRspBO.getApprovalStatus())));
            }
            showRspBO.setLastOperator(this.userInfoService.queryUserNameByUserId(outstockTotal.getLastOperator()));
            showRspBO.setUserIdNew(outstockTotal.getUserId());
            showRspBO.setUserName(this.userInfoService.queryUserNameByUserId(outstockTotal.getUserId()));
            LinkedList<SaleOrderDetailInfoRspBO> saleOrderDetailList = new LinkedList<SaleOrderDetailInfoRspBO>();
            if (!"0".equals(this.enumsService.queryShowOrderCodeSwitch()) || !OrderSource.ELECTRIC_MARKET.getCode().equals(outstockTotal.getSource())) {
                OutstockInfoVO queryOutStockVO = new OutstockInfoVO();
                queryOutStockVO.setTotalNo(outstockTotal.getTotalNo());
                List<OutstockInfo> ostInfoList = this.outstockInfoMapper.selectByCondition(queryOutStockVO);
                LinkedList<String> outstockNoList = new LinkedList<String>();
                for (OutstockInfo ostInfo : ostInfoList) {
                    outstockNoList.add(ostInfo.getOutstockNo());
                }
                if (CollectionUtils.isNotEmpty(outstockNoList)) {
                    QueryOutstockInfoVO outstockVO = new QueryOutstockInfoVO();
                    outstockVO.setOutstockNoList(outstockNoList);
                    List<Long> inspectionIds = this.outstockInfoMapper.selectInspectionIdsByCondition(outstockVO);
                    if (!CollectionUtils.isEmpty(inspectionIds)) {
                        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
                        saleOrderInfoVO.setInspectionIdList(inspectionIds);
                        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
                        for (SaleOrderInfo orderInfo : saleOrderInfoList) {
                            SaleOrderDetailInfoRspBO detailRspBO = new SaleOrderDetailInfoRspBO();
                            detailRspBO.setInspectionId(orderInfo.getInspectionId());
                            detailRspBO.setSaleOrderCode(orderInfo.getSaleOrderCode());
                            detailRspBO.setSaleOrderName(orderInfo.getSaleOrderName());
                            saleOrderDetailList.add(detailRspBO);
                        }
                    }
                }
            }
            showRspBO.setSaleOrderDetailList(saleOrderDetailList);
            outstockTotalList.add(showRspBO);
        }
        rspPageBO.setRespDesc("\u67e5\u8be2\u51fa\u5e93\u6c47\u603b\u5355\u6210\u529f");
        rspPageBO.setRows(outstockTotalList);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }
}

