/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.AccountantEngineService;
import com.tydic.fsc.settle.atom.FscWfStartAtomService;
import com.tydic.fsc.settle.atom.SequenceNoService;
import com.tydic.fsc.settle.atom.SourceMappingService;
import com.tydic.fsc.settle.atom.SubAccountService;
import com.tydic.fsc.settle.atom.bo.AccountantEngineReqBO;
import com.tydic.fsc.settle.atom.bo.FscWfStartAtomReqBO;
import com.tydic.fsc.settle.atom.bo.FscWfStartAtomRspBO;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiReceivableWriteOffService;
import com.tydic.fsc.settle.busi.api.bo.BusiReceivableWriteOffDetailReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiReceivableWriteOffReqBO;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.dao.AdvanceReceiveMapper;
import com.tydic.fsc.settle.dao.RecAmtConfirmMapper;
import com.tydic.fsc.settle.dao.RecvAbleInfoMapper;
import com.tydic.fsc.settle.dao.RecvAmtDetailMapper;
import com.tydic.fsc.settle.dao.po.AdvanceReceive;
import com.tydic.fsc.settle.dao.po.RecAmtConfirm;
import com.tydic.fsc.settle.dao.po.RecvAbleInfo;
import com.tydic.fsc.settle.dao.po.RecvAmtDetail;
import com.tydic.fsc.settle.enums.AdvanceReceiveStatus;
import com.tydic.fsc.settle.enums.BusinessType;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.RecAmtConfirmStatus;
import com.tydic.fsc.settle.enums.RecvAbleInfoRecvStatus;
import com.tydic.fsc.settle.enums.SubAccountServiceType;
import com.tydic.fsc.settle.enums.WFBillType;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiReceivableWriteOffServiceImpl
implements BusiReceivableWriteOffService {
    private static final Logger logger = LoggerFactory.getLogger(BusiReceivableWriteOffServiceImpl.class);
    @Autowired
    private SubAccountService subAccountService;
    @Autowired
    private AccountantEngineService accountantEngineService;
    @Resource
    private SequenceNoService recAmtConfirmSeqNoService;
    @Autowired
    private RecvAbleInfoMapper recvAbleInfoMapper;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private RecAmtConfirmMapper recAmtConfirmMapper;
    @Autowired
    private RecvAmtDetailMapper recvAmtDetailMapper;
    @Autowired
    private FscWfStartAtomService fscWfStartAtomService;
    @Autowired(required=false)
    private SourceMappingService sourceMappingService;

    public FscBaseRspBo processWriteOff(BusiReceivableWriteOffReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5e94\u6536\u6838\u9500\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        Long purchaseNo = reqBO.getPurchaseNo();
        Long purchaseProjectId = reqBO.getPurchaseProjectId();
        Long operUnitNo = reqBO.getCompanyId();
        List writeOffDatas = reqBO.getWriteOffDatas();
        if (purchaseNo == null || purchaseNo <= 0L) {
            throw new BusinessException("0001", "\u5165\u53c2\u91c7\u8d2d\u5355\u4f4d[purchaseNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (purchaseProjectId == null || purchaseProjectId <= 0L) {
            throw new BusinessException("0001", "\u5165\u53c2\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957[purchaseProjectId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (operUnitNo == null || operUnitNo <= 0L) {
            throw new BusinessException("0001", "\u5165\u53c2\u516c\u53f8ID[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (writeOffDatas == null || writeOffDatas.isEmpty()) {
            throw new BusinessException("0001", "\u5165\u53c2\u5e94\u6536\u8bb0\u5f55[writeOffDatas]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String source = OrderSource.ELECTRIC_AREA.getCode();
        int indexSource = 0;
        BigDecimal toWriteoffAmtSum = BigDecimal.ZERO;
        for (BusiReceivableWriteOffDetailReqBO writeOffData : writeOffDatas) {
            String recvableNo = writeOffData.getRecvableNo();
            BigDecimal toWriteoffAmt = writeOffData.getToWriteoffAmt();
            ++indexSource;
            if (toWriteoffAmt == null || toWriteoffAmt.compareTo(BigDecimal.ZERO) <= 0) {
                logger.error("\u5e94\u6536\u8bb0\u5f55[\u5e94\u6536\u7f16\u53f7=" + recvableNo + "]\u7684\u672c\u6b21\u6536\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
                throw new BusinessException("18000", "\u5e94\u6536\u8bb0\u5f55[\u5e94\u6536\u7f16\u53f7=" + recvableNo + "]\u7684\u672c\u6b21\u6536\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
            RecvAbleInfo recvAbleInfo = this.recvAbleInfoMapper.selectByPrimaryKey(recvableNo);
            if (recvAbleInfo.getRecvableAmt().subtract(recvAbleInfo.getWriteoffAmt()).compareTo(toWriteoffAmt) < 0) {
                logger.error("\u5e94\u6536\u8bb0\u5f55[\u5e94\u6536\u7f16\u53f7=" + recvableNo + "]\u7684\u53ef\u6838\u9500\u91d1\u989d\u5c0f\u4e8e\u672c\u6b21\u6536\u6b3e\u91d1\u989d");
                throw new BusinessException("18000", "\u5e94\u6536\u8bb0\u5f55[\u5e94\u6536\u7f16\u53f7=" + recvableNo + "]\u7684\u53ef\u6838\u9500\u91d1\u989d\u5c0f\u4e8e\u672c\u6b21\u6536\u6b3e\u91d1\u989d");
            }
            if (!recvAbleInfo.getPurchaseNo().equals(purchaseNo) || !recvAbleInfo.getPurchaseProjectId().equals(purchaseProjectId)) {
                throw new BusinessException("18000", "\u5e94\u6536\u8bb0\u5f55\u548c\u5b50\u8d26\u6237\u7684\u91c7\u8d2d\u5355\u4f4d\u4fe1\u606f\u4e0d\u5339\u914d");
            }
            if (indexSource == 1) {
                source = recvAbleInfo.getSource();
            } else if (indexSource > 1 && !source.equals(recvAbleInfo.getSource())) {
                throw new BusinessException("18000", "\u6765\u6e90\u4e0d\u540c\u7684\u5e94\u6536\u8bb0\u5f55\u4e0d\u80fd\u4e00\u8d77\u6838\u9500");
            }
            toWriteoffAmtSum = toWriteoffAmtSum.add(toWriteoffAmt);
        }
        String targetSource = this.sourceMappingService.queryAccountingTargetSource(source);
        SubAcctInfoExt paySubAcctInfo = this.subAccountService.getWithMainAccount(operUnitNo, targetSource, purchaseNo, purchaseProjectId, SubAccountServiceType.DEFAULT.getCode());
        if (paySubAcctInfo == null) {
            logger.error("\u91c7\u8d2d\u5355\u4f4d\u5b50\u8d26\u6237\u4e0d\u5b58\u5728");
            throw new BusinessException("18000", "\u91c7\u8d2d\u5355\u4f4d\u5b50\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        String subAcctNo = paySubAcctInfo.getSubAcctNo();
        SubAcctInfoExt recvSubAcctInfo = this.subAccountService.getWithMainAccount(operUnitNo, targetSource, operUnitNo, null, SubAccountServiceType.FOR_SETTLE.getCode());
        if (recvSubAcctInfo == null) {
            logger.error("\u5f85\u7ed3\u7b97\u6b3e\u9879\u5b50\u8d26\u6237\u4e0d\u5b58\u5728");
            throw new BusinessException("18000", "\u5f85\u7ed3\u7b97\u6b3e\u9879\u5b50\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        if (paySubAcctInfo.getBalance().compareTo(toWriteoffAmtSum) < 0) {
            logger.error("\u91c7\u8d2d\u5355\u4f4d\u5b50\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\u3002\u8d26\u53f7=" + paySubAcctInfo.getSubAcctNo() + ",\u4f59\u989d=" + paySubAcctInfo.getBalance() + ",\u5f85\u6838\u9500\u91d1\u989d=" + toWriteoffAmtSum);
            throw new BusinessException("18000", "\u91c7\u8d2d\u5355\u4f4d\u5b50\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\u3002\u8d26\u53f7=" + paySubAcctInfo.getSubAcctNo() + ",\u4f59\u989d=" + paySubAcctInfo.getBalance() + ",\u5f85\u6838\u9500\u91d1\u989d=" + toWriteoffAmtSum);
        }
        AdvanceReceive param = new AdvanceReceive();
        param.setRecSubAcct(subAcctNo);
        param.setStatus(AdvanceReceiveStatus.NO_CONFIRM.getCode());
        List<AdvanceReceive> advanceReceiveList = this.advanceReceiveMapper.selectUnwriteOff(param);
        if (advanceReceiveList.isEmpty()) {
            logger.error("\u91c7\u8d2d\u5355\u4f4d\u5b50\u8d26\u6237[\u8d26\u53f7=" + subAcctNo + "]\u6ca1\u6709\u53ef\u6838\u9500\u7684\u6253\u6b3e\u8bb0\u5f55");
            throw new BusinessException("18000", "\u91c7\u8d2d\u5355\u4f4d\u5b50\u8d26\u6237[\u8d26\u53f7=" + subAcctNo + "]\u6ca1\u6709\u53ef\u6838\u9500\u7684\u6253\u6b3e\u8bb0\u5f55");
        }
        BigDecimal writeoffAmtSum = BigDecimal.ZERO;
        for (AdvanceReceive advanceReceive : advanceReceiveList) {
            writeoffAmtSum = writeoffAmtSum.add(advanceReceive.getSubAcctBal());
        }
        if (writeoffAmtSum.compareTo(toWriteoffAmtSum) < 0) {
            logger.error("\u91c7\u8d2d\u5355\u4f4d\u5b50\u8d26\u6237[\u8d26\u53f7=" + subAcctNo + "]\u7684\u6253\u6b3e\u8bb0\u5f55\u7684\u91d1\u989d\u4e0d\u8db3");
            throw new BusinessException("18000", "\u91c7\u8d2d\u5355\u4f4d\u5b50\u8d26\u6237[\u8d26\u53f7=" + subAcctNo + "]\u7684\u6253\u6b3e\u8bb0\u5f55\u7684\u91d1\u989d\u4e0d\u8db3");
        }
        Long docNum = Long.valueOf(this.recAmtConfirmSeqNoService.generateSeqNoFormated(18, new SimpleDateFormat("yyyyMMdd").format(new Date())));
        ArrayList<AccountantEngineReqBO> accountantEngineReqBOList = new ArrayList<AccountantEngineReqBO>();
        HashSet<Long> advRecvSeqSet = new HashSet<Long>();
        for (BusiReceivableWriteOffDetailReqBO writeOffData : writeOffDatas) {
            String recvableNo = writeOffData.getRecvableNo();
            BigDecimal toWriteoffAmt = writeOffData.getToWriteoffAmt();
            RecvAbleInfo recvAbleInfo = this.recvAbleInfoMapper.selectByPrimaryKey(recvableNo);
            advanceReceiveList = this.advanceReceiveMapper.selectUnwriteOff(param);
            while (toWriteoffAmt.compareTo(BigDecimal.ZERO) > 0) {
                AdvanceReceive advanceReceive = this.pickOne(advanceReceiveList, toWriteoffAmt);
                if (advanceReceive == null) {
                    logger.error("\u5e94\u6536\u8bb0\u5f55[\u5e94\u6536\u7f16\u53f7=" + recvableNo + ",\u672c\u6b21\u6536\u6b3e\u91d1\u989d=" + writeOffData.getToWriteoffAmt() + "]\u6838\u9500\u5931\u8d25\uff0c\u91c7\u8d2d\u5355\u4f4d\u5b50\u8d26\u6237\u6253\u6b3e\u8bb0\u5f55\u7684\u91d1\u989d\u4e0d\u8db3");
                    throw new BusinessException("18000", "\u5e94\u6536\u8bb0\u5f55[\u5e94\u6536\u7f16\u53f7=" + recvableNo + ",\u672c\u6b21\u6536\u6b3e\u91d1\u989d=" + writeOffData.getToWriteoffAmt() + "]\u6838\u9500\u5931\u8d25\uff0c\u91c7\u8d2d\u5355\u4f4d\u5b50\u8d26\u6237\u6253\u6b3e\u8bb0\u5f55\u7684\u91d1\u989d\u4e0d\u8db3");
                }
                advRecvSeqSet.add(advanceReceive.getSeq());
                BigDecimal writeoffAmtActual = null;
                BigDecimal writeoffAmt = advanceReceive.getSubAcctBal();
                if (writeoffAmt.compareTo(toWriteoffAmt) >= 0) {
                    writeoffAmtActual = toWriteoffAmt;
                    writeoffAmt = writeoffAmt.subtract(toWriteoffAmt);
                    toWriteoffAmt = BigDecimal.ZERO;
                } else {
                    writeoffAmtActual = writeoffAmt;
                    toWriteoffAmt = toWriteoffAmt.subtract(writeoffAmt);
                    writeoffAmt = BigDecimal.ZERO;
                }
                AdvanceReceive record = new AdvanceReceive();
                record.setSeq(advanceReceive.getSeq());
                record.setWriteoffAmt(advanceReceive.getWriteoffAmt().add(writeoffAmtActual));
                if (writeoffAmt.compareTo(BigDecimal.ZERO) == 0) {
                    record.setStatus(AdvanceReceiveStatus.CONFIRM.getCode());
                }
                this.advanceReceiveMapper.updateByPrimaryKeySelective(record);
                RecvAmtDetail recvAmtDetail = new RecvAmtDetail();
                recvAmtDetail.setAdvRecvSeq(advanceReceive.getSeq());
                recvAmtDetail.setAmount(writeoffAmtActual);
                recvAmtDetail.setRecvableNo(recvableNo);
                recvAmtDetail.setPayAcctNo(subAcctNo);
                recvAmtDetail.setRecAcctNo(recvSubAcctInfo.getSubAcctNo());
                recvAmtDetail.setOperUnitNo(recvAbleInfo.getOperUnitNo());
                recvAmtDetail.setSupplierNo(recvAbleInfo.getSupplierNo());
                recvAmtDetail.setPurchaseNo(recvAbleInfo.getPurchaseNo());
                recvAmtDetail.setPurchaseProjectId(recvAbleInfo.getPurchaseProjectId());
                recvAmtDetail.setDocNum(docNum);
                recvAmtDetail.setOrderId(recvAbleInfo.getOrderId());
                recvAmtDetail.setLoginId(reqBO.getUserId());
                recvAmtDetail.setCreateDate(new Date());
                this.recvAmtDetailMapper.insert(recvAmtDetail);
            }
            RecvAbleInfo record = new RecvAbleInfo();
            record.setRecvableNo(recvableNo);
            record.setWriteoffAmt(recvAbleInfo.getWriteoffAmt().add(writeOffData.getToWriteoffAmt()));
            if (recvAbleInfo.getRecvableAmt().compareTo(record.getWriteoffAmt()) <= 0) {
                record.setRecvStatus(RecvAbleInfoRecvStatus.RECEIVED.getCode());
            }
            this.recvAbleInfoMapper.updateByPrimaryKeySelective(record);
            AccountantEngineReqBO accountantEngineReqBO = new AccountantEngineReqBO();
            accountantEngineReqBO.setBusinessType(BusinessType.ORDER_PAY.getCode());
            accountantEngineReqBO.setSource(targetSource);
            accountantEngineReqBO.setClientAcctNo(subAcctNo);
            accountantEngineReqBO.setOperUnit(operUnitNo);
            accountantEngineReqBO.setServiceNo(recvAbleInfo.getSaleOrderCode());
            accountantEngineReqBO.setRemark("\u5e94\u6536\u6838\u9500");
            accountantEngineReqBO.setAmounts(Arrays.asList(writeOffData.getToWriteoffAmt()));
            accountantEngineReqBOList.add(accountantEngineReqBO);
        }
        RecAmtConfirm recAmtConfirm = new RecAmtConfirm();
        recAmtConfirm.setDocNum(docNum);
        recAmtConfirm.setSumCount(advRecvSeqSet.size());
        recAmtConfirm.setSumAmt(toWriteoffAmtSum);
        recAmtConfirm.setOrgId(operUnitNo);
        recAmtConfirm.setLoginId(reqBO.getUserId());
        recAmtConfirm.setRemark("\u5e94\u6536\u6838\u9500");
        recAmtConfirm.setCreateDate(new Date());
        recAmtConfirm.setSource(source);
        recAmtConfirm.setStatus(RecAmtConfirmStatus.VALID.getCode());
        this.recAmtConfirmMapper.insert(recAmtConfirm);
        FscWfStartAtomReqBO req = new FscWfStartAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)req));
        req.setBillNo(String.valueOf(docNum));
        req.setBillType(WFBillType.COLLECTION_CONFIRMATION);
        req.setFinishEvtServiceId("recAmtConfirmWorkFlowFinshEventImpl");
        FscWfStartAtomRspBO atomRspBO = this.fscWfStartAtomService.dealStartApproval(req);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new BusinessException("18000", "\u5e94\u6536\u6838\u9500\u670d\u52a1\u5931\u8d25\uff0c\u53d1\u8d77\u5ba1\u6279\u5f02\u5e38");
        }
        for (AccountantEngineReqBO accountantEngineReqBO : accountantEngineReqBOList) {
            this.accountantEngineService.executeAccountantEngine(accountantEngineReqBO);
        }
        return new FscBaseRspBo();
    }

    private AdvanceReceive pickOne(List<AdvanceReceive> advanceReceiveList, BigDecimal toWriteoffAmt) {
        Iterator<AdvanceReceive> iterator = advanceReceiveList.iterator();
        while (iterator.hasNext()) {
            AdvanceReceive advanceReceive = iterator.next();
            if (advanceReceive.getSubAcctBal().compareTo(toWriteoffAmt) >= 0) {
                iterator.remove();
                return advanceReceive;
            }
            if (iterator.hasNext()) continue;
            iterator.remove();
            return advanceReceive;
        }
        return null;
    }
}

