/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.SubAccountRespInitService;
import com.tydic.fsc.settle.atom.SubAccountService;
import com.tydic.fsc.settle.busi.api.BusiSubAccountAddService;
import com.tydic.fsc.settle.busi.api.bo.BusiSubAccountInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiSubAccountInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.dao.MainAcctInfoMapper;
import com.tydic.fsc.settle.dao.po.MainAcctInfo;
import com.tydic.fsc.settle.dao.po.SubAcctInfo;
import com.tydic.fsc.settle.enums.SubAccountServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiSubAccountAddServiceImpl
implements BusiSubAccountAddService {
    private static final Logger logger = LoggerFactory.getLogger(BusiSubAccountAddServiceImpl.class);
    @Autowired
    private SubAccountService subAcctService;
    @Autowired
    private SubAccountRespInitService initSerivce;
    @Autowired
    private MainAcctInfoMapper mainAcctInfoMapper;

    public BusiSubAccountInfoRspBO addSubAccount(BusiSubAccountInfoReqBO subAcctInfoBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u65b0\u589e\u5b50\u8d26\u53f7BO:" + subAcctInfoBO.toString());
        }
        BusiSubAccountInfoRspBO retBo = new BusiSubAccountInfoRspBO();
        String validateArgStr = this.validateArg(subAcctInfoBO);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("18005");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        Integer srvType = subAcctInfoBO.getServiceType();
        SubAccountServiceType serviceType = SubAccountServiceType.convert(srvType);
        if (serviceType != null && serviceType != SubAccountServiceType.DEFAULT) {
            throw new BusinessException("0001", "\u5b50\u8d26\u53f7\u670d\u52a1\u7c7b\u578b\u5fc5\u987b\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u503c10");
        }
        String mainAcctNo = subAcctInfoBO.getMainAcctNo();
        Long mainOrgId = subAcctInfoBO.getSuperiorOrgId();
        String source = subAcctInfoBO.getSource();
        if (!StringUtils.hasText((String)mainAcctNo)) {
            logger.error("\u65b0\u589e\u5b50\u8d26\u53f7,\u4e3b\u8d26\u53f7\u673a\u6784\u53f7\u53ca\u6765\u6e90,\u6765\u6e90=" + source + ",\u4e3b\u8d26\u53f7\u673a\u6784\u53f7=" + mainOrgId);
            if (!StringUtils.hasLength((String)source)) {
                throw new BusinessException("0001", "\u65b0\u589e\u5b50\u8d26\u53f7\u9700\u8981\u6765\u6e90");
            }
            if (mainOrgId == null) {
                throw new BusinessException("0001", "\u65b0\u589e\u5b50\u8d26\u53f7\u9700\u8981\u4e3b\u8d26\u53f7\u7684\u673a\u6784\u53f7");
            }
            MainAcctInfo mainInfo = this.mainAcctInfoMapper.selectByPrimaryKey(mainOrgId, source);
            if (mainInfo == null) {
                throw new BusinessException("0001", "\u627e\u4e0d\u5230\u673a\u6784\u53ca\u6765\u6e90\u4e0b\u7684\u4e3b\u8d26\u53f7");
            }
            mainAcctNo = mainInfo.getMainAcctNo();
        }
        srvType = SubAccountServiceType.DEFAULT.getCode();
        Long orgId = subAcctInfoBO.getCompanyId();
        SubAcctInfo subAcct = new SubAcctInfo();
        subAcct.setLoginId(subAcctInfoBO.getUserId());
        subAcct.setCreateOrgId(orgId);
        subAcct.setMainAcctNo(mainAcctNo);
        subAcct.setOrgId(subAcctInfoBO.getAcctOrgId());
        subAcct.setSubAcctName(subAcctInfoBO.getSubAcctName());
        subAcct.setServiceType(srvType);
        subAcct.setProjectId(subAcctInfoBO.getProjectId());
        subAcct.setOverdraft(subAcctInfoBO.getOverdraft());
        subAcct = this.subAcctService.addSubAccount(subAcct);
        if (StringUtils.isEmpty((Object)subAcct.getSubAcctNo())) {
            throw new BusinessException("0001", "\u65b0\u589e\u5b50\u8d26\u6237atom\u670d\u52a1\u9519\u8bef:" + subAcct.getRespDesc());
        }
        BusiSubAccountInfoRspBO respBo = new BusiSubAccountInfoRspBO();
        SubAcctInfoExt extInfo = this.subAcctService.getWithMainAccount(subAcct.getSubAcctNo());
        this.initSerivce.initRespBo(extInfo, respBo);
        return respBo;
    }

    private String validateArg(BusiSubAccountInfoReqBO subAcctInfoBO) {
        if (subAcctInfoBO == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String mainAcctNo = subAcctInfoBO.getMainAcctNo();
        Long superiorOrgId = subAcctInfoBO.getSuperiorOrgId();
        String source = subAcctInfoBO.getSource();
        if (!StringUtils.isEmpty((Object)mainAcctNo) && (StringUtils.isEmpty((Object)superiorOrgId) || StringUtils.isEmpty((Object)source))) {
            return "superiorOrgId\u4e3a\u7a7a\u65f6\uff0cmainOrgId\u548csource\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)subAcctInfoBO.getAcctOrgId())) {
            return "\u5c5e\u6027acctOrgId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)subAcctInfoBO.getSubAcctName())) {
            return "\u5c5e\u6027subAcctName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)subAcctInfoBO.getProjectId())) {
            return "\u5c5e\u6027projectId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

