/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.file.FileProcessing;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.InvoiceReturnDeleteFileService;
import com.tydic.fsc.settle.busi.api.bo.InvoiceReturnDeleteFileReqBO;
import com.tydic.fsc.settle.dao.InvoiceReturnMapper;
import com.tydic.fsc.settle.dao.po.InvoiceReturn;
import com.tydic.fsc.settle.enums.InvoiceReturnFileType;
import com.tydic.fsc.settle.utils.FscStringUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InvoiceReturnDeleteFileServiceImpl
implements InvoiceReturnDeleteFileService {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceReturnDeleteFileServiceImpl.class);
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;

    public FscBaseRspBo process(InvoiceReturnDeleteFileReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5220\u9664\u9644\u4ef6\u670d\u52a1\uff08\u5e73\u53f0\u4f7f\u7528\u8d39\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        String billNo = reqBO.getBillNo();
        Integer fileType = reqBO.getFileType();
        if (!StringUtils.hasText((String)billNo)) {
            throw new BusinessException("0001", "\u9000\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fileType == null) {
            throw new BusinessException("0001", "\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceReturn invoiceReturn = this.invoiceReturnMapper.selectByPrimaryKey(billNo);
        Integer realFileType = InvoiceReturn.obtainRealFileType(fileType);
        String originalFilename = null;
        InvoiceReturn invoiceReturnUpdate = new InvoiceReturn();
        invoiceReturnUpdate.setBillNo(billNo);
        if (InvoiceReturnFileType.LICENSE_FILE.getCode().equals(realFileType)) {
            originalFilename = invoiceReturn.getLicenseFile();
            invoiceReturnUpdate.setLicenseFile("");
        } else if (InvoiceReturnFileType.BANK_LICENSE_FILE.getCode().equals(realFileType)) {
            originalFilename = invoiceReturn.getBankLicenseFile();
            invoiceReturnUpdate.setBankLicenseFile("");
        } else if (InvoiceReturnFileType.APPLY_FILE.getCode().equals(realFileType)) {
            originalFilename = invoiceReturn.getApplyFile();
            invoiceReturnUpdate.setApplyFile("");
        } else if (InvoiceReturnFileType.REMARK_FILE.getCode().equals(realFileType)) {
            originalFilename = invoiceReturn.getRemarkFile();
            invoiceReturnUpdate.setRemarkFile("");
        } else if (InvoiceReturnFileType.INVOICE_FILE.getCode().equals(realFileType)) {
            String invoiceFile = invoiceReturn.getInvoiceFile();
            List<String> invoiceFiles = FscStringUtils.string2List(invoiceFile, ",");
            int index = fileType - InvoiceReturnFileType.INVOICE_FILE.getCode();
            if (index >= 0 && index < invoiceFiles.size()) {
                originalFilename = invoiceFiles.get(index);
                invoiceFiles.remove(index);
            }
            invoiceFile = StringUtils.hasText((String)(invoiceFile = FscStringUtils.list2String(invoiceFiles, ","))) ? invoiceFile : "";
            invoiceReturnUpdate.setInvoiceFile(invoiceFile);
        }
        if (StringUtils.hasText((String)originalFilename)) {
            String ossFilename = invoiceReturn.obtainOssFilename(originalFilename);
            try {
                FileProcessing.deleteFile((String)ossFilename, (String)"PAY", null);
            }
            catch (Exception e) {
                logger.error("\u5220\u9664OSS\u6587\u4ef6\u5931\u8d25\u3002\u6587\u4ef6\u540d\uff1a" + ossFilename, (Throwable)e);
            }
        }
        this.invoiceReturnMapper.updateByPrimaryKeySelective(invoiceReturnUpdate);
        return new FscBaseRspBo();
    }
}

