/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.busi.api.PayTradeServiceFeeListService;
import com.tydic.fsc.settle.busi.api.bo.PayTradeServiceFeeListReqBO;
import com.tydic.fsc.settle.busi.api.bo.PayTradeServiceFeeListRspBO;
import com.tydic.fsc.settle.busi.api.bo.PayTradeServiceFeeRspBO;
import com.tydic.fsc.settle.dao.InquiryPayOrderMapper;
import com.tydic.fsc.settle.dao.MainAcctInfoMapper;
import com.tydic.fsc.settle.dao.SubAcctInfoMapper;
import com.tydic.fsc.settle.dao.po.InquiryPayOrder;
import com.tydic.fsc.settle.dao.po.InquiryPayOrderExt;
import com.tydic.fsc.settle.dao.po.MainAcctInfo;
import com.tydic.fsc.settle.dao.po.SubAcctInfo;
import com.tydic.fsc.settle.enums.CompanyType;
import com.tydic.fsc.settle.enums.InquiryApprovalStatus;
import com.tydic.fsc.settle.enums.InquiryMailStatus;
import com.tydic.fsc.settle.enums.InquiryPayFeeType;
import com.tydic.fsc.settle.enums.InquiryPayPass;
import com.tydic.fsc.settle.enums.InquiryPaymentStatus;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.OrderStatus;
import com.tydic.fsc.settle.enums.SubAccountServiceType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PayTradeServiceFeeListServiceImpl
implements PayTradeServiceFeeListService {
    private static final Logger logger = LoggerFactory.getLogger(PayTradeServiceFeeListServiceImpl.class);
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private MainAcctInfoMapper mainAcctInfoMapper;
    @Autowired
    private SubAcctInfoMapper subAcctInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private EnumsService enumsService;

    public PayTradeServiceFeeListRspBO tradeServiceFeeList(PayTradeServiceFeeListReqBO reqBO) {
        boolean bool;
        Long operUnitNo;
        Long supplierId;
        if (reqBO.getSupId() != null && reqBO.getSupId() > 0L) {
            supplierId = reqBO.getSupId();
            operUnitNo = reqBO.getOperUnitNo();
        } else {
            if (null == reqBO.getCompanyId()) {
                throw new BusinessException("0001", "\u4f9b\u5e94\u5546Id\u548c\u4e13\u4e1a\u516c\u53f8Id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
            }
            supplierId = reqBO.getSupplierId();
            operUnitNo = reqBO.getCompanyId();
        }
        PayTradeServiceFeeListRspBO rspBO = new PayTradeServiceFeeListRspBO();
        ArrayList<PayTradeServiceFeeRspBO> rows = null;
        List<InquiryPayOrder> list = null;
        InquiryPayOrderExt payOrderInfoExt = new InquiryPayOrderExt();
        int idx = (reqBO.getPageNo() - 1) * reqBO.getPageSize();
        if (idx < 0) {
            idx = 0;
        }
        payOrderInfoExt.setRowIndex(idx);
        payOrderInfoExt.setPageSize(reqBO.getPageSize());
        ArrayList<String> unpayList = new ArrayList<String>();
        unpayList.add(InquiryPaymentStatus.NO_PAYMENT.getCode());
        unpayList.add(InquiryPaymentStatus.IN_PAYMENT.getCode());
        unpayList.add(InquiryPaymentStatus.TERMINATED.getCode());
        unpayList.add(InquiryPaymentStatus.OFFLINE_PAY_REGISTERED.getCode());
        boolean bl = bool = reqBO.getPaymentStatusSet() == null && unpayList.contains(reqBO.getPaymentStatus()) || reqBO.getPaymentStatusSet() != null && unpayList.contains(reqBO.getPaymentStatusSet().iterator().next());
        if (bool) {
            payOrderInfoExt.setSortOrder("ORDER_TIME DESC");
        } else {
            payOrderInfoExt.setSortOrder("PAY_FINSH_TIME DESC");
        }
        payOrderInfoExt.setPayOrderNo(reqBO.getPayOrderNo());
        payOrderInfoExt.setInquiryNo(reqBO.getInquiryNo());
        payOrderInfoExt.setPaymentStatus(reqBO.getPaymentStatus());
        payOrderInfoExt.setPaymentStatusSet(reqBO.getPaymentStatusSet());
        payOrderInfoExt.setOrderStatus(reqBO.getOrderStatus());
        payOrderInfoExt.setOrderStatusSet(reqBO.getOrderStatusSet());
        payOrderInfoExt.setPayPass(reqBO.getPayPass());
        payOrderInfoExt.setPayOrderName(reqBO.getPayOrderName());
        payOrderInfoExt.setSupplierId(supplierId);
        payOrderInfoExt.setOperUnitNo(operUnitNo);
        payOrderInfoExt.setOperator(reqBO.getOperator());
        payOrderInfoExt.setApprovalStatus(reqBO.getApprovalStatus());
        payOrderInfoExt.setPayFeeType(reqBO.getPayFeeType());
        if (null != reqBO.getPlanUserNameLike() && StringUtils.hasText((String)reqBO.getPlanUserNameLike())) {
            List<Long> planUserIdList = this.userInfoService.queryUserIdListByUserNameLike(reqBO.getPlanUserNameLike());
            if (planUserIdList.isEmpty()) {
                planUserIdList.add(-1L);
            }
            payOrderInfoExt.setPlanUserIdList(planUserIdList);
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getPayFeeType())) {
            ArrayList<String> payFeeTypeList = new ArrayList<String>();
            payFeeTypeList.add(InquiryPayFeeType.TRADE_SERVICE_FEE.getCode());
            payFeeTypeList.add(InquiryPayFeeType.PURCH_SERVICE_FEE.getCode());
            payOrderInfoExt.setPayFeeTypeList(payFeeTypeList);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (null != reqBO.getOrderDateBegin()) {
                payOrderInfoExt.setOrderDateBegin(sdf.parse(reqBO.getOrderDateBegin()));
            }
            if (null != reqBO.getOrderDateEnd()) {
                payOrderInfoExt.setOrderDateEnd(sdf.parse(reqBO.getOrderDateEnd()));
            }
            if (null != reqBO.getOrderDateBegin() && null != reqBO.getOrderDateEnd() && payOrderInfoExt.getOrderDateBegin().after(payOrderInfoExt.getOrderDateEnd())) {
                throw new BusinessException("0001", "\u8f93\u5165\u7684\u8ba2\u5355\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u8ba2\u5355\u5f00\u59cb\u65e5\u671f");
            }
        }
        catch (ParseException e) {
            throw new BusinessException("0001", "\u8f93\u5165\u7684\u65f6\u95f4\u7c7b\u578b\u6709\u8bef");
        }
        int total = 0;
        int recordsTotal = this.inquiryPayOrderMapper.getCount(payOrderInfoExt);
        if (recordsTotal > 0) {
            total = recordsTotal / reqBO.getPageSize() + (recordsTotal % reqBO.getPageSize() > 0 ? 1 : 0);
            list = this.inquiryPayOrderMapper.getList(payOrderInfoExt);
        }
        if (null != list) {
            rows = new ArrayList<PayTradeServiceFeeRspBO>();
            for (InquiryPayOrder inquiryPayOrder : list) {
                PayTradeServiceFeeRspBO pts = new PayTradeServiceFeeRspBO();
                BeanUtils.copyProperties((Object)inquiryPayOrder, (Object)pts);
                pts.setPayPassDesc(this.enumsService.getDescr(InquiryPayPass.getInstance(inquiryPayOrder.getPayPass())));
                pts.setPaymentStatusDesc(this.enumsService.getDescr(InquiryPaymentStatus.getInstance(inquiryPayOrder.getPaymentStatus())));
                pts.setOrderStatusDesc(this.enumsService.getDescr(OrderStatus.getInstance(inquiryPayOrder.getOrderStatus())));
                pts.setMailStatusDesc(this.enumsService.getDescr(InquiryMailStatus.getInstance(inquiryPayOrder.getMailStatus())));
                pts.setCompanyTypeDesc(this.enumsService.getDescr(CompanyType.convert(inquiryPayOrder.getCompanyType())));
                pts.setPayFeeTypeDesc(this.enumsService.getDescr(InquiryPayFeeType.getInstance(inquiryPayOrder.getPayFeeType())));
                if (reqBO.getSupId() != null && reqBO.getSupId() > 0L) {
                    String operUnitName = this.organizationInfoService.queryOrgName(inquiryPayOrder.getOperUnitNo());
                    pts.setOperUnitName(operUnitName);
                } else {
                    String supplierName = this.organizationInfoService.querySupplierName(inquiryPayOrder.getSupplierId());
                    pts.setSupplierName(supplierName);
                }
                if (inquiryPayOrder.getOperator() != null) {
                    String operatorName = this.userInfoService.queryUserNameByUserId(inquiryPayOrder.getOperator());
                    pts.setOperatorName(operatorName);
                }
                if (inquiryPayOrder.getPlanUserId() != null) {
                    String planUserName = this.userInfoService.queryUserNameByUserId(inquiryPayOrder.getPlanUserId());
                    pts.setPlanUserName(planUserName);
                }
                pts.setApprovalStatusDesc(this.enumsService.getDescr(InquiryApprovalStatus.getInstance(inquiryPayOrder.getApprovalStatus())));
                MainAcctInfo mainAcctInfo = this.mainAcctInfoMapper.selectByPrimaryKey(pts.getOperUnitNo(), OrderSource.CONSULT_PRICE.getCode());
                if (mainAcctInfo != null) {
                    pts.setOpenBank(mainAcctInfo.getOpenBank());
                    SubAcctInfo subAcctInfo = this.subAcctInfoMapper.selectPKByServiceTypeAndMainAcct(SubAccountServiceType.SERVICE_FEE.getCode(), mainAcctInfo.getMainAcctNo());
                    if (subAcctInfo != null) {
                        pts.setSubAcctNo(subAcctInfo.getSubAcctNo());
                    }
                }
                rows.add(pts);
            }
        } else {
            logger.info("\u83b7\u53d6\u6210\u4ea4\u670d\u52a1\u8d39\u7f34\u8d39\u5355\u5217\u8868\u96c6\u5408\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(total);
        rspBO.setRows(rows);
        return rspBO;
    }
}

