/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.base.BasePayService;
import com.tydic.fsc.settle.bo.FscBaseReqBo;
import com.tydic.fsc.settle.busi.api.PayCenterObtainReqLogNoService;
import com.tydic.fsc.settle.busi.api.TestThreadPoolService;
import com.tydic.fsc.settle.busi.api.bo.BusiOrderPayRspBO;
import com.tydic.fsc.settle.busi.api.bo.PayCenterObtainReqLogNoRspBO;
import com.tydic.fsc.settle.busi.api.bo.TestThreadPoolReqBO;
import com.tydic.fsc.settle.dao.MigrationSubAcctMapper;
import com.tydic.fsc.settle.dao.po.MigrationSubAcct;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TestThreadPoolPayServiceImpl
extends BasePayService<BusiOrderPayRspBO>
implements TestThreadPoolService {
    private static final Logger logger = LoggerFactory.getLogger(TestThreadPoolPayServiceImpl.class);
    @Autowired
    private MigrationSubAcctMapper migrationSubAcctMapper;
    @Autowired
    private PayCenterObtainReqLogNoService payCenterObtainReqLogNoService;

    public BusiOrderPayRspBO process(TestThreadPoolReqBO reqBO) {
        BusiOrderPayRspBO rspBO;
        if (logger.isDebugEnabled()) {
            logger.debug("\u6d4b\u8bd5\u7ebf\u7a0b\u6c60\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        PayCenterObtainReqLogNoRspBO payCenterObtainReqLogNoRspBO = this.payCenterObtainReqLogNoService.query(new FscBaseReqBo());
        if (!StringUtils.hasText((String)reqBO.getReqLogNo())) {
            String reqLogNo = payCenterObtainReqLogNoRspBO.getReqLogNo();
            reqBO.setReqLogNo(reqLogNo);
        }
        if ((rspBO = (BusiOrderPayRspBO)this.queryRspOrSaveLog((FscBaseReqBo)reqBO)) != null) {
            return rspBO;
        }
        int poolSize = reqBO.getPoolSize();
        try {
            rspBO = this.process2(reqBO);
        }
        catch (Exception e) {
            logger.error("\u5931\u8d25", (Throwable)e);
            this.updateLog((FscBaseReqBo)reqBO, e);
            throw new BusinessException("18000", e.getMessage());
        }
        this.updateLog((FscBaseReqBo)reqBO, rspBO);
        return rspBO;
    }

    public BusiOrderPayRspBO process2(TestThreadPoolReqBO reqBO) {
        BusiOrderPayRspBO rspBO = new BusiOrderPayRspBO();
        for (int i = 0; i < reqBO.getPoolSize(); ++i) {
            MigrationSubAcct migrationSubAcct = new MigrationSubAcct();
            migrationSubAcct.setId(i);
            this.migrationSubAcctMapper.insert(migrationSubAcct);
            if (i != 20) continue;
            throw new BusinessException("0001", "i==20");
        }
        return rspBO;
    }

    @Override
    protected BusiOrderPayRspBO fillRspBO(String respPackage) {
        BusiOrderPayRspBO rspBO = new BusiOrderPayRspBO();
        JSONObject jsonObject = JSONObject.fromObject((Object)respPackage);
        rspBO.setRespCode(jsonObject.getString("respCode"));
        rspBO.setRespDesc(jsonObject.getString("respDesc"));
        return rspBO;
    }
}

