/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.tydic.fsc.settle.atom.WorkFlowFinishEvent;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.WorkFlowFinishProcessService;
import com.tydic.fsc.settle.busi.api.bo.WorkFlowFinishProcessReqBO;
import com.tydic.fsc.settle.dao.WorkFlowDataMapper;
import com.tydic.fsc.settle.dao.po.WorkFlowDataInfo;
import com.tydic.fsc.settle.dao.vo.WFEventResult;
import com.tydic.fsc.settle.dao.vo.WorkFlowDataInfoVO;
import com.tydic.fsc.settle.enums.WFBillType;
import com.tydic.fsc.settle.utils.BeanFactory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Deprecated
@Service
public class WorkFlowFinishProcessServiceImpl
implements WorkFlowFinishProcessService {
    private static final Logger logger = LoggerFactory.getLogger(WorkFlowFinishProcessServiceImpl.class);
    @Autowired
    private WorkFlowDataMapper workFlowDataMapper;

    public FscBaseRspBo process(WorkFlowFinishProcessReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5de5\u4f5c\u6d41\u7ed3\u675f\u5904\u7406\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        WorkFlowDataInfoVO vo = new WorkFlowDataInfoVO();
        ArrayList<String> billTypeNotIn = new ArrayList<String>();
        billTypeNotIn.add(WFBillType.HANDMADE_COLLECTION.getCode());
        vo.setBillTypeNotIn(billTypeNotIn);
        vo.setProcInstId(reqBO.getProcInstId());
        vo.setStatus("02");
        vo.setFinancialStatus("'01','03','11','12'");
        vo.setTryCount(0);
        List<WorkFlowDataInfo> list = this.workFlowDataMapper.selectListByVO(vo);
        logger.debug("\u5f85\u5904\u7406\u5de5\u4f5c\u6d41\u6570\u91cf\uff1a" + list.size());
        int su = 0;
        int failed = 0;
        for (WorkFlowDataInfo wf : list) {
            String service = wf.getFinishEvtService();
            if (!StringUtils.hasLength((String)service)) continue;
            WorkFlowFinishEvent event = (WorkFlowFinishEvent)BeanFactory.getBean(service);
            logger.debug("\u5904\u7406\u5b8c\u6210\u7684\u5de5\u4f5c\u6d41,billType=" + wf.getBillType() + ",billNo=" + wf.getBillNo() + ",service=" + service + ",Bean=" + event);
            if (event == null) continue;
            WFEventResult result = null;
            try {
                result = event.process(wf, wf.getBillType(), wf.getBillNo());
                if (result != null && result.isSuccess()) {
                    this.updateState(wf, true, result);
                    ++su;
                    continue;
                }
                this.updateState(wf, false, result);
            }
            catch (Exception e) {
                ++failed;
                logger.error("\u8c03\u7528\u5de5\u4f5c\u6d41\u5b8c\u6210\u4e8b\u4ef6\u5904\u7406\u5931\u8d25,billType=" + wf.getBillType() + ",billNo=" + wf.getBillNo(), (Throwable)e);
                result = new WFEventResult();
                result.setRespDesc("\u5931\u8d25\uff1a" + e.getMessage());
                this.updateState(wf, false, result);
            }
        }
        logger.debug("\u6210\u529f=" + su + ",\u5931\u8d25=" + failed);
        return new FscBaseRspBo();
    }

    private void updateState(WorkFlowDataInfo wf, boolean success, WFEventResult result) {
        WorkFlowDataInfo forUpdate = new WorkFlowDataInfo();
        String sta = "02";
        if (!success) {
            sta = "03";
            if (WFBillType.OUTBOUND_COLLECTION.getCode().equals(wf.getBillType()) && null != result && StringUtils.hasText((String)result.getFinancialStatus())) {
                sta = result.getFinancialStatus();
            }
            forUpdate.setTryCount(wf.getTryCount() - 1);
            forUpdate.setResultdesc("\u5931\u8d25");
        }
        forUpdate.setProcInstId(wf.getProcInstId());
        forUpdate.setBillNo(wf.getBillNo());
        forUpdate.setFinancialStatus(sta);
        if (result != null) {
            forUpdate.setRefNo(result.getSsn());
            forUpdate.setResultdesc(result.getRespDesc());
            if (StringUtils.hasText((String)forUpdate.getResultdesc()) && forUpdate.getResultdesc().length() > 500) {
                forUpdate.setResultdesc(forUpdate.getResultdesc().substring(0, 500));
            }
        }
        this.workFlowDataMapper.updateByPrimaryKeySelective(forUpdate);
    }
}

