/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.aop;

import com.alibaba.dubbo.rpc.RpcContext;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.taobao.eagleeye.EagleEye;
import com.tydic.fsc.settle.aop.FscAopUtils;
import com.tydic.fsc.settle.aop.FscBusiAspect;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FscAtomAspect {
    private static final String TRACE_ID = "traceId";
    private static final Logger atomLog = LoggerFactory.getLogger(FscBusiAspect.class);

    @Pointcut(value="execution(* com.tydic.fsc.settle.atom.impl..*(..))")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        Object rspObj;
        String traceId;
        Map hiddenParm = RpcContext.getContext().getAttachments();
        if (hiddenParm.containsKey(TRACE_ID)) {
            traceId = (String)hiddenParm.get(TRACE_ID);
        } else {
            traceId = EagleEye.getTraceId();
            hiddenParm.put(TRACE_ID, traceId);
        }
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        Class<?> rspClass = method.getReturnType();
        String[] infos = this.printAtomAopStartLog(pjp, traceId);
        try {
            rspObj = pjp.proceed();
            this.putCodeToRsp(rspObj, "0000", "\u6210\u529f");
        }
        catch (BusinessException e) {
            rspObj = rspClass.newInstance();
            String msgCode = e.getMsgCode();
            String desc = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)desc)) {
                desc = "\u5931\u8d25";
            }
            if (StringUtils.isEmpty((CharSequence)msgCode)) {
                msgCode = "18000";
            }
            atomLog.info("atom BusinessException:{}", (Object)desc);
            this.printAtomAopErrorLog(infos, e);
            this.putCodeToRsp(rspObj, msgCode, desc);
        }
        catch (Throwable e) {
            this.printAtomAopErrorLog(infos, e);
            if (!rspClass.isInterface()) {
                rspObj = rspClass.newInstance();
                this.putCodeToRsp(rspObj, "18000", "\u5931\u8d25:" + e.getMessage());
            }
            throw e;
        }
        this.printAtomAopEndLog(infos, rspObj);
        return rspObj;
    }

    private void printAtomAopErrorLog(String[] infos, Throwable e) {
        if (infos == null) {
            return;
        }
        FscAopUtils.buildAopErrorLog(infos, e);
        atomLog.error(FscAopUtils.getLogInfoByStrings(infos));
    }

    private void putCodeToRsp(Object object, String code, String desc) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        FscAopUtils.putCodeToRsp(object, code, desc, false);
    }

    private String[] printAtomAopStartLog(ProceedingJoinPoint pjp, String traceId) {
        String[] infos = FscAopUtils.buildAopStartLog(pjp, traceId);
        if (null != infos) {
            atomLog.info(FscAopUtils.getLogInfoByStrings(infos));
        }
        return infos;
    }

    private void printAtomAopEndLog(String[] infos, Object object) {
        if (infos == null) {
            return;
        }
        FscAopUtils.buildAopEndLog(infos, object);
        atomLog.info(FscAopUtils.getLogInfoByStrings(infos));
    }
}

