/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.aop;

import com.alibaba.dubbo.rpc.RpcContext;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.taobao.eagleeye.EagleEye;
import com.tydic.fsc.settle.aop.FscAopUtils;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=100)
public class FscBusiAspect {
    private static final String TRACE_ID = "traceId";
    private static final Logger busiLog = LoggerFactory.getLogger(FscBusiAspect.class);

    @Pointcut(value="execution(* com.tydic.fsc.settle.busi.impl..*(..))")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        Object rspObj;
        String traceId;
        Map hiddenParm = RpcContext.getContext().getAttachments();
        if (!hiddenParm.containsKey(TRACE_ID)) {
            traceId = EagleEye.getTraceId();
            hiddenParm.put(TRACE_ID, traceId);
        } else {
            traceId = (String)hiddenParm.get(TRACE_ID);
        }
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        Class<?> rspClass = method.getReturnType();
        String[] infos = this.printBusiAopStartLog(pjp, traceId);
        try {
            rspObj = pjp.proceed();
            this.putCodeToRsp(rspObj, "0000", "\u6210\u529f");
        }
        catch (BusinessException e) {
            if (busiLog.isDebugEnabled()) {
                busiLog.debug("BusinessException", (Throwable)e);
            }
            rspObj = rspClass.newInstance();
            String msgCode = e.getMsgCode();
            String desc = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)msgCode)) {
                msgCode = "18000";
            }
            if (StringUtils.isEmpty((CharSequence)desc)) {
                desc = "\u5931\u8d25";
            }
            busiLog.info("busi\u5c42 BusinessException\uff1a{}", (Object)desc);
            this.printBusiAopErrorLog(infos, e);
            this.putCodeToRsp(rspObj, msgCode, desc);
        }
        catch (Throwable e) {
            if (!rspClass.isInterface()) {
                this.printBusiAopErrorLog(infos, e);
                rspObj = rspClass.newInstance();
                this.putCodeToRsp(rspObj, "18000", "\u670d\u52a1\u8c03\u7528\u5f02\u5e38:" + e.getMessage());
            }
            throw e;
        }
        this.printBusiAopEndLog(infos, rspObj);
        return rspObj;
    }

    private void printBusiAopErrorLog(String[] infos, Throwable e) {
        if (infos == null) {
            return;
        }
        FscAopUtils.buildAopErrorLog(infos, e);
        busiLog.error(FscAopUtils.getLogInfoByStrings(infos));
    }

    private void putCodeToRsp(Object object, String code, String desc) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        FscAopUtils.putCodeToRsp(object, code, desc, false);
    }

    private String[] printBusiAopStartLog(ProceedingJoinPoint pjp, String traceId) {
        String[] infos = FscAopUtils.buildAopStartLog(pjp, traceId);
        if (null != infos) {
            busiLog.info(FscAopUtils.getLogInfoByStrings(infos));
        }
        return infos;
    }

    private void printBusiAopEndLog(String[] infos, Object object) {
        if (infos == null) {
            return;
        }
        FscAopUtils.buildAopEndLog(infos, object);
        busiLog.info(FscAopUtils.getLogInfoByStrings(infos));
    }
}

