/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom;

import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.dao.MainAcctInfoMapper;
import com.tydic.fsc.settle.dao.po.MainAcctInfo;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.SubAccountServiceType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AccountAtomService {
    @Autowired
    private MainAcctInfoMapper mainAcctInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public String obtainSubAccountName4Purchase(String mainAcctNo, Long projectId) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.hasText((String)mainAcctNo) && projectId != null) {
            MainAcctInfo mainAcctInfo = this.mainAcctInfoMapper.selectByMainAcc(mainAcctNo);
            String sourceDescr = OrderSource.getInstance((String)mainAcctInfo.getSource()).getDescr();
            String projectName = this.organizationInfoService.queryProjectName(projectId).getAccountName();
            sb.append(sourceDescr).append(projectName);
        }
        return sb.toString();
    }

    public String obtainSubAccountName4Oper(String mainAcctNo, Integer serviceType) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.hasText((String)mainAcctNo) && serviceType != null) {
            MainAcctInfo mainAcctInfo = this.mainAcctInfoMapper.selectByMainAcc(mainAcctNo);
            String operUnitName = this.organizationInfoService.queryOrgName(mainAcctInfo.getOrgId());
            String sourceDescr = OrderSource.getInstance((String)mainAcctInfo.getSource()).getDescr();
            String serviceTypeDescr = SubAccountServiceType.getInstance(serviceType).getDescr();
            sb.append(operUnitName).append(sourceDescr).append(serviceTypeDescr);
        }
        return sb.toString();
    }
}

