/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom;

import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnDetailMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.InvoiceReturn;
import com.tydic.fsc.settle.dao.po.InvoiceReturnDetail;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.vo.BillApplyInfoVO;
import com.tydic.fsc.settle.dao.vo.InvoiceReturnDetailVO;
import com.tydic.fsc.settle.dao.vo.InvoiceReturnVO;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.InvoiceReturnStatus;
import com.tydic.fsc.settle.enums.SaleInvoiceInfoInvoiceStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InvoiceReturnDzcsAtomService {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceReturnDzcsAtomService.class);
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    public void updateStatus(InvoiceReturnVO vo) {
        block14: {
            String status;
            String billNo;
            block11: {
                boolean ok;
                block13: {
                    List<InvoiceReturnDetail> details;
                    block12: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u66f4\u65b0\u72b6\u6001\u5165\u53c2\uff1a" + vo);
                        }
                        billNo = vo.getBillNo();
                        status = vo.getStatus();
                        if (!InvoiceReturnStatus.RETURNED.getCode().equals(status)) break block11;
                        ok = true;
                        InvoiceReturnDetailVO detailVO = new InvoiceReturnDetailVO();
                        detailVO.setBillNo(billNo);
                        details = this.invoiceReturnDetailMapper.selectList(detailVO);
                        logger.debug("\u9000\u7968\u7533\u8bf7\u660e\u7ec6\u6570\u76ee\uff1a" + details.size());
                        if (!"1".equals(vo.getInvoiceReturnChannel())) break block12;
                        ArrayList invoiceNo1s = new ArrayList();
                        for (InvoiceReturnDetail detail : details) {
                            invoiceNo1s.add(detail.getInvoiceNo1());
                        }
                        SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
                        saleInvoiceInfoVO.setInvoiceNoList(invoiceNo1s);
                        saleInvoiceInfoVO.setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode());
                        List<SaleInvoiceInfo> invoice1s = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
                        if (invoice1s.isEmpty()) break block13;
                        ok = false;
                        break block13;
                    }
                    for (InvoiceReturnDetail detail : details) {
                        if (StringUtils.hasText((String)detail.getInvoiceNo2())) continue;
                        ok = false;
                        break;
                    }
                }
                if (ok) {
                    InvoiceReturn record = new InvoiceReturn();
                    record.setBillNo(billNo);
                    record.setStatus(status);
                    record.setProcessUser(vo.getProcessUser());
                    record.setProcessDate(new Date());
                    this.invoiceReturnMapper.updateByPrimaryKeySelective(record);
                }
                break block14;
            }
            if (InvoiceReturnStatus.BILLING.getCode().equals(status)) {
                InvoiceReturn record = new InvoiceReturn();
                record.setBillNo(billNo);
                record.setStatus(status);
                this.invoiceReturnMapper.updateByPrimaryKeySelective(record);
            } else if (InvoiceReturnStatus.BILLED.getCode().equals(status)) {
                InvoiceReturnDetailVO detailVO = new InvoiceReturnDetailVO();
                detailVO.setBillNo(billNo);
                List<InvoiceReturnDetail> details = this.invoiceReturnDetailMapper.selectList(detailVO);
                HashSet<String> applyNo3s = new HashSet<String>();
                for (InvoiceReturnDetail detail : details) {
                    if (!StringUtils.hasText((String)detail.getApplyNo3())) continue;
                    applyNo3s.add(detail.getApplyNo3());
                }
                if (!applyNo3s.isEmpty()) {
                    BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
                    billApplyInfoVO.setApplyNoList(new ArrayList<String>(applyNo3s));
                    List<BillApplyInfo> apply3s = this.billApplyInfoMapper.getList(billApplyInfoVO);
                    boolean ok = true;
                    for (BillApplyInfo apply3 : apply3s) {
                        if (BillStatus.SEND_BILL.getCode().equals(apply3.getBillStatus())) continue;
                        ok = false;
                        break;
                    }
                    if (ok) {
                        InvoiceReturn record = new InvoiceReturn();
                        record.setBillNo(billNo);
                        record.setStatus(status);
                        this.invoiceReturnMapper.updateByPrimaryKeySelective(record);
                    }
                }
            }
        }
    }
}

