/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.file.FileProcessing;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.QueryDictKeyValueService;
import com.tydic.fsc.settle.atom.SourceMappingService;
import com.tydic.fsc.settle.atom.SubAccountService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.atom.WorkFlowFinishEvent;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.dao.AdvanceReceiveExtMapper;
import com.tydic.fsc.settle.dao.AdvanceReceiveMapper;
import com.tydic.fsc.settle.dao.FinanceConfigMapper;
import com.tydic.fsc.settle.dao.RecAmtConfirmMapper;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.AdvanceReceive;
import com.tydic.fsc.settle.dao.po.FinanceConfig;
import com.tydic.fsc.settle.dao.po.PurchaseUnitInfo;
import com.tydic.fsc.settle.dao.po.RecAmtConfirm;
import com.tydic.fsc.settle.dao.po.SaleOrderInfo;
import com.tydic.fsc.settle.dao.po.WorkFlowDataInfo;
import com.tydic.fsc.settle.dao.vo.AdvanceReceiveExtVO;
import com.tydic.fsc.settle.dao.vo.AdvanceReceiveVO;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import com.tydic.fsc.settle.dao.vo.WFEventResult;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.ReceiveType;
import com.tydic.fsc.settle.enums.YuanGuangType;
import com.tydic.fsc.settle.utils.ContactUtils;
import com.tydic.fsc.settle.utils.FileUtils;
import com.tydic.fsc.settle.utils.FscStringUtils;
import com.tydic.fsc.supplier.BusiTransferRecAmtConfirmService;
import com.tydic.fsc.supplier.bo.BusiTransferRecAmtConfirmAttachDetailReqBO;
import com.tydic.fsc.supplier.bo.BusiTransferRecAmtConfirmDetailReqBO;
import com.tydic.fsc.supplier.bo.BusiTransferRecAmtConfirmReqBO;
import com.tydic.fsc.supplier.bo.BusiTransferRecAmtConfirmRspBO;
import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="recAmtConfirmWorkFlowFinshEventImpl")
public class RecAmtConfirmWorkFlowFinshEventImpl
implements WorkFlowFinishEvent {
    private static final Logger logger = LoggerFactory.getLogger(RecAmtConfirmWorkFlowFinshEventImpl.class);
    @Autowired
    private BusiTransferRecAmtConfirmService busiTransferRecAmtConfirmService;
    @Autowired
    private RecAmtConfirmMapper recAmtConfirmMapper;
    @Autowired
    private FinanceConfigMapper financeConfigMapper;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private QueryDictKeyValueService queryDictKeyValueService;
    @Autowired
    private SubAccountService subAccountService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SourceMappingService sourceMappingService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private AdvanceReceiveExtMapper advanceReceiveExtMapper;

    @Override
    public WFEventResult process(WorkFlowDataInfo workFlowDataInfo, String billType, String billNo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u6536\u6b3e\u786e\u8ba4\u5355\u5ba1\u6279\u6d41\u5b8c\u6210\u4e8b\u4ef6\u5904\u7406\u5165\u53c2\uff1aworkFlowDataInfo=" + workFlowDataInfo + ";billType=" + billType + ";billNo=" + billNo);
        }
        if (!StringUtils.hasText((String)billNo)) {
            throw new BusinessException("0001", "\u6536\u6b3e\u5355\u6d41\u6c34\u53f7[billNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Long docNum = Long.valueOf(billNo);
        RecAmtConfirm recAmtConfirm = this.recAmtConfirmMapper.selectByPrimaryKey(docNum);
        if (recAmtConfirm == null) {
            logger.debug("\u6839\u636e\u6536\u6b3e\u5355\u6d41\u6c34\u53f7\uff1a" + docNum + "\u5728\u6536\u6b3e\u5355\u4fe1\u606f\u8868d_rec_amt_confirm\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
            throw new BusinessException("18001", "\u6839\u636e\u6536\u6b3e\u5355\u6d41\u6c34\u53f7\uff1a" + docNum + "\u5728\u6536\u6b3e\u5355\u4fe1\u606f\u8868d_rec_amt_confirm\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
        }
        String source = recAmtConfirm.getSource();
        String targetSource = this.sourceMappingService.queryYuanguangTargetSource(source);
        AdvanceReceiveVO vo = new AdvanceReceiveVO();
        vo.setDocNum(docNum);
        BusiTransferRecAmtConfirmReqBO reqBO = new BusiTransferRecAmtConfirmReqBO();
        FinanceConfig financeConfig = this.financeConfigMapper.selectByPrimaryKey(targetSource, recAmtConfirm.getOrgId(), YuanGuangType.COL_RECEIVABLE_BUSINESS.getCode());
        if (financeConfig == null) {
            throw new BusinessException("18001", "\u4e13\u4e1a\u516c\u53f8\u672a\u914d\u7f6e\u8d22\u52a1\u53c2\u6570\uff08\u6765\u6e90\uff1a" + this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)source)) + "\uff0c\u4e13\u4e1a\u516c\u53f8\uff1a" + this.organizationInfoService.queryOrgName(recAmtConfirm.getOrgId()) + "\uff0c\u5355\u636e\u7c7b\u578b\uff1a" + YuanGuangType.COL_RECEIVABLE_BUSINESS.getDescr() + "\uff09");
        }
        reqBO.setSeqid("PAY" + YuanGuangType.COL_RECEIVABLE_BUSINESS.getCode() + billNo);
        reqBO.setSsdw(financeConfig.getUnitName());
        reqBO.setYhdm(this.userInfoService.queryFinanceUserCodeByUserId(source, financeConfig, recAmtConfirm.getLoginId()));
        reqBO.setFlowid(financeConfig.getProcessId());
        StringBuilder postDate = new StringBuilder();
        LinkedList<BusiTransferRecAmtConfirmDetailReqBO> items = new LinkedList<BusiTransferRecAmtConfirmDetailReqBO>();
        Map<String, String> map = this.queryDictKeyValueService.queryDictKeyValue(targetSource, YuanGuangType.COL_RECEIVABLE_BUSINESS.getCode());
        HashSet<String> receipts = new HashSet<String>();
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            List<AdvanceReceive> advanceReceiveList = this.advanceReceiveMapper.selectByCondition(vo);
            if (advanceReceiveList == null || advanceReceiveList.size() == 0) {
                logger.error("\u6839\u636e\u6536\u6b3e\u5355\u6d41\u6c34\u53f7\uff1a" + docNum + "\u5728\u9884\u6536\u6b3e\u4fe1\u606f\u8868d_advance_receive\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
                throw new BusinessException("18001", "\u6839\u636e\u6536\u6b3e\u5355\u6d41\u6c34\u53f7\uff1a" + docNum + "\u5728\u9884\u6536\u6b3e\u4fe1\u606f\u8868d_advance_receive\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
            }
            for (AdvanceReceive advanceReceive : advanceReceiveList) {
                if (StringUtils.hasText((String)advanceReceive.getReceipt())) {
                    receipts.add(advanceReceive.getReceipt());
                }
                BusiTransferRecAmtConfirmDetailReqBO item = new BusiTransferRecAmtConfirmDetailReqBO();
                item.setYwlx(map.get("\u4e1a\u52a1\u7c7b\u578b\uff08\u9884\u6536\uff09"));
                SubAcctInfoExt subAcctInfoExt = this.subAccountService.getWithMainAccount(advanceReceive.getRecSubAcct());
                if (subAcctInfoExt == null) {
                    logger.error("\u6839\u636e\u8f6c\u5165\u65b9\u5b50\u8d26\u53f7\uff1a" + advanceReceive.getRecSubAcct() + "\u5728\u5b50\u8d26\u6237\u4fe1\u606f\u8868d_sub_acct_info\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
                    throw new BusinessException("18001", "\u6839\u636e\u8f6c\u5165\u65b9\u5b50\u8d26\u53f7\uff1a" + advanceReceive.getRecSubAcct() + "\u5728\u5b50\u8d26\u6237\u4fe1\u606f\u8868d_sub_acct_info\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
                }
                PurchaseUnitInfo purchaseUnitInfo = this.organizationInfoService.queryParentAccount(subAcctInfoExt.getProjectId());
                if (purchaseUnitInfo == null) {
                    String projectName = this.organizationInfoService.queryProjectName(subAcctInfoExt.getProjectId()).getAccountName();
                    logger.error("\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957[\u8d26\u5957ID=" + subAcctInfoExt.getProjectId() + "\uff0c\u8d26\u5957\u540d\u79f0=" + projectName + "]\u6216\u5176\u7236\u8d26\u5957\u67e5\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u914d\u7f6e");
                    throw new BusinessException("18004", "\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957[\u8d26\u5957ID=" + subAcctInfoExt.getProjectId() + "\uff0c\u8d26\u5957\u540d\u79f0=" + projectName + "]\u6216\u5176\u7236\u8d26\u5957\u67e5\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u914d\u7f6e");
                }
                String xshtbh = ContactUtils.obtainXshtbh(financeConfig, purchaseUnitInfo, source);
                item.setHtbh(xshtbh);
                item.setCppzfl(map.get("\u4ea7\u54c1\u54c1\u79cd\u5206\u7c7b"));
                item.setFkf(advanceReceive.getTransferAcctName());
                item.setSkf(financeConfig.getUnitNameNormal());
                item.setYwsx(map.get("\u4e1a\u52a1\u4e8b\u9879"));
                if (ReceiveType.BANK_RECEIVE.getCode().equals(advanceReceive.getRecType())) {
                    item.setSkfs(map.get("\u6536\u6b3e\u65b9\u5f0f\uff08\u94f6\u884c\u6536\u6b3e\uff09"));
                } else {
                    item.setSkfs(map.get("\u6536\u6b3e\u65b9\u5f0f\uff08\u7968\u636e\uff09"));
                }
                item.setSkyhzh(advanceReceive.getRecAcct());
                item.setXjllfl(map.get("\u73b0\u91d1\u6d41\u91cf\u5206\u7c7b"));
                item.setSkje(advanceReceive.getTranAmt() == null ? BigDecimal.ZERO : advanceReceive.getTranAmt());
                item.setSkqyskje(BigDecimal.ZERO);
                item.setBcysje(advanceReceive.getTranAmt() == null ? BigDecimal.ZERO : advanceReceive.getTranAmt());
                item.setBz("\u4ed8\u6b3e\u65f6\u95f4\uff1a" + sdf.format(advanceReceive.getPostDate()) + ";" + advanceReceive.getRemark());
                items.add(item);
            }
        } else {
            BusiTransferRecAmtConfirmDetailReqBO item;
            List<AdvanceReceiveVO> advanceReceiveListDlzq = this.advanceReceiveMapper.selectListDlzq(docNum);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy\u5e74M\u6708d\u65e5");
            for (AdvanceReceiveVO advanceReceiveVO : advanceReceiveListDlzq) {
                if (advanceReceiveVO.getAmount() == null || advanceReceiveVO.getAmount().compareTo(BigDecimal.ZERO) == 0) continue;
                if (StringUtils.hasText((String)advanceReceiveVO.getReceipt())) {
                    receipts.add(advanceReceiveVO.getReceipt());
                }
                postDate.append(dateFormat.format(advanceReceiveVO.getPostDate())).append(";");
                item = new BusiTransferRecAmtConfirmDetailReqBO();
                item.setCppzfl(map.get("\u4ea7\u54c1\u54c1\u79cd\u5206\u7c7b"));
                Long projectId = null;
                if (OrderSource.CONSULT_PRICE.getCode().equals(source)) {
                    SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
                    saleOrderInfoVO.setOrderId(advanceReceiveVO.getOrderId());
                    List<SaleOrderInfo> orders = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
                    projectId = orders.get(0).getPurchaseProjectId();
                } else {
                    SubAcctInfoExt subAcctInfoExt = this.subAccountService.getWithMainAccount(advanceReceiveVO.getRecSubAcct());
                    if (subAcctInfoExt == null) {
                        logger.error("\u6839\u636e\u8f6c\u5165\u65b9\u5b50\u8d26\u53f7\uff1a" + advanceReceiveVO.getRecSubAcct() + "\u672a\u627e\u5230\u5b50\u8d26\u6237");
                        throw new BusinessException("18001", "\u6839\u636e\u8f6c\u5165\u65b9\u5b50\u8d26\u53f7\uff1a" + advanceReceiveVO.getRecSubAcct() + "\u672a\u627e\u5230\u5b50\u8d26\u6237");
                    }
                    projectId = subAcctInfoExt.getProjectId();
                }
                PurchaseUnitInfo purchaseUnitInfo = this.organizationInfoService.queryParentAccount(projectId);
                if (purchaseUnitInfo == null) {
                    String projectName = this.organizationInfoService.queryProjectName(projectId).getAccountName();
                    logger.error("\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957[\u8d26\u5957ID=" + projectId + "\uff0c\u8d26\u5957\u540d\u79f0=" + projectName + "]\u6216\u5176\u7236\u8d26\u5957\u67e5\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u914d\u7f6e");
                    throw new BusinessException("18004", "\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957[\u8d26\u5957ID=" + projectId + "\uff0c\u8d26\u5957\u540d\u79f0=" + projectName + "]\u6216\u5176\u7236\u8d26\u5957\u67e5\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u914d\u7f6e");
                }
                item.setFkf(advanceReceiveVO.getTransferAcctName());
                item.setSkf(financeConfig.getUnitNameNormal());
                item.setYwsx(map.get("\u4e1a\u52a1\u4e8b\u9879"));
                if (ReceiveType.BANK_RECEIVE.getCode().equals(advanceReceiveVO.getRecType())) {
                    item.setSkfs(map.get("\u6536\u6b3e\u65b9\u5f0f\uff08\u94f6\u884c\u6536\u6b3e\uff09"));
                } else {
                    item.setSkfs(map.get("\u6536\u6b3e\u65b9\u5f0f\uff08\u7968\u636e\uff09"));
                }
                item.setSkyhzh(advanceReceiveVO.getRecAcct());
                item.setXjllfl(map.get("\u73b0\u91d1\u6d41\u91cf\u5206\u7c7b"));
                item.setSkje(advanceReceiveVO.getAmount() == null ? BigDecimal.ZERO : advanceReceiveVO.getAmount());
                String xshtbh = ContactUtils.obtainXshtbh(financeConfig, purchaseUnitInfo, source);
                item.setHtbh(xshtbh);
                item.setSkqyskje(BigDecimal.ZERO);
                item.setBcysje(advanceReceiveVO.getAmount() == null ? BigDecimal.ZERO : advanceReceiveVO.getAmount());
                item.setYwlx(map.get("\u4e1a\u52a1\u7c7b\u578b\uff08\u9884\u6536\uff09"));
                item.setBz("\u4ed8\u6b3e\u65f6\u95f4\uff1a" + sdf.format(advanceReceiveVO.getPostDate()) + ";" + advanceReceiveVO.getRemark());
                items.add(item);
            }
            AdvanceReceiveExtVO advanceReceiveExtVO = new AdvanceReceiveExtVO();
            advanceReceiveExtVO.setDocNum(docNum);
            List<AdvanceReceiveExtVO> advanceReceiveExtList = this.advanceReceiveExtMapper.selectListDlzq(advanceReceiveExtVO);
            if (!CollectionUtils.isEmpty(advanceReceiveExtList)) {
                item = advanceReceiveExtList.iterator();
                while (item.hasNext()) {
                    AdvanceReceiveExtVO advanceExt = item.next();
                    if (advanceExt.getAmount() == null || advanceExt.getAmount().compareTo(BigDecimal.ZERO) == 0) continue;
                    postDate.append(dateFormat.format(advanceExt.getPostDate())).append(";");
                    BusiTransferRecAmtConfirmDetailReqBO item2 = new BusiTransferRecAmtConfirmDetailReqBO();
                    item2.setCppzfl(map.get("\u4ea7\u54c1\u54c1\u79cd\u5206\u7c7b"));
                    SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
                    saleOrderInfoVO.setOrderId(advanceExt.getOrderId());
                    List<SaleOrderInfo> orders = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
                    Long projectId = orders.get(0).getPurchaseProjectId();
                    PurchaseUnitInfo purchaseUnitInfo = this.organizationInfoService.queryParentAccount(projectId);
                    if (purchaseUnitInfo == null) {
                        String projectName = this.organizationInfoService.queryProjectName(projectId).getAccountName();
                        logger.error("\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957[\u8d26\u5957ID=" + projectId + "\uff0c\u8d26\u5957\u540d\u79f0=" + projectName + "]\u6216\u5176\u7236\u8d26\u5957\u67e5\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u914d\u7f6e");
                        throw new BusinessException("18004", "\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957[\u8d26\u5957ID=" + projectId + "\uff0c\u8d26\u5957\u540d\u79f0=" + projectName + "]\u6216\u5176\u7236\u8d26\u5957\u67e5\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u914d\u7f6e");
                    }
                    item2.setFkf(advanceExt.getTransferAcctName());
                    item2.setSkf(financeConfig.getUnitNameNormal());
                    item2.setYwsx(map.get("\u4e1a\u52a1\u4e8b\u9879"));
                    item2.setSkfs(map.get("\u6536\u6b3e\u65b9\u5f0f\uff08\u94f6\u884c\u6536\u6b3e\uff09"));
                    item2.setSkyhzh(advanceExt.getRecAcct());
                    item2.setXjllfl(map.get("\u73b0\u91d1\u6d41\u91cf\u5206\u7c7b"));
                    item2.setSkje(advanceExt.getAmount() == null ? BigDecimal.ZERO : advanceExt.getAmount());
                    String xshtbh = ContactUtils.obtainXshtbh(financeConfig, purchaseUnitInfo, source);
                    item2.setHtbh(xshtbh);
                    item2.setSkqyskje(BigDecimal.ZERO);
                    item2.setBcysje(advanceExt.getAmount() == null ? BigDecimal.ZERO : advanceExt.getAmount());
                    item2.setYwlx(map.get("\u4e1a\u52a1\u7c7b\u578b\uff08\u9884\u6536\uff09"));
                    if (!StringUtils.hasText((String)advanceExt.getRemark())) {
                        advanceExt.setRemark("");
                    }
                    item2.setBz("\u4ed8\u6b3e\u65f6\u95f4\uff1a" + sdf.format(advanceExt.getPostDate()) + ";" + advanceExt.getRemark());
                    items.add(item2);
                }
            }
            if (CollectionUtils.isEmpty(advanceReceiveListDlzq) && CollectionUtils.isEmpty(advanceReceiveExtList)) {
                logger.error("\u6839\u636e\u6536\u6b3e\u5355\u6d41\u6c34\u53f7\uff1a" + docNum + "\u5728\u9884\u6536\u6b3e\u4fe1\u606f\u8868d_advance_receive\u6216\u8005\u5176\u4ed6\u94f6\u884c\u9884\u6536\u6b3e\u4fe1\u606f\u8868d_advance_receive_ext\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
                throw new BusinessException("18001", "\u6839\u636e\u6536\u6b3e\u5355\u6d41\u6c34\u53f7\uff1a" + docNum + "\u5728\u9884\u6536\u6b3e\u4fe1\u606f\u8868\u6216\u8005\u5176\u4ed6\u94f6\u884c\u9884\u6536\u6b3e\u4fe1\u606f\u8868\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
            }
        }
        reqBO.setItems(items);
        StringBuilder summary = new StringBuilder();
        if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source)) {
            if (postDate.length() > 0) {
                postDate.deleteCharAt(postDate.lastIndexOf(";"));
            }
            summary.append("\u6536\u5230\u5546\u57ce").append(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)source))).append("\u9884\u5b58\u6b3e(").append((CharSequence)postDate).append(")");
        } else {
            summary.append("\u6536\u91c7\u8d2d\u5355\u4f4d\u7535\u5546\u9884\u6536\u8d26\u6b3e");
        }
        String summaryStr = summary.toString();
        summaryStr = FscStringUtils.cutStringByByte(summaryStr, "UTF-8", 200);
        reqBO.setSummary(summaryStr);
        ArrayList<BusiTransferRecAmtConfirmAttachDetailReqBO> arrayList = new ArrayList<BusiTransferRecAmtConfirmAttachDetailReqBO>();
        reqBO.setAttachItems(arrayList);
        for (String receipt : receipts) {
            File file = null;
            try {
                file = FileProcessing.downloadFile((String)receipt, (String)"PAY", null);
            }
            catch (Exception e) {
                logger.error("\u4eceOSS\u4e0b\u8f7d\u6587\u4ef6\u51fa\u9519\u3002\u6587\u4ef6\u540d\uff1a" + receipt);
            }
            if (file != null) {
                String content = FileUtils.fileToBase64(file);
                BusiTransferRecAmtConfirmAttachDetailReqBO fjxx = new BusiTransferRecAmtConfirmAttachDetailReqBO();
                fjxx.setName(receipt);
                fjxx.setContent(content);
                arrayList.add(fjxx);
            }
            org.apache.commons.io.FileUtils.deleteQuietly((File)file);
        }
        WFEventResult wfEventResult = new WFEventResult();
        BusiTransferRecAmtConfirmRspBO rspBO = null;
        try {
            rspBO = this.busiTransferRecAmtConfirmService.transfer(reqBO);
            wfEventResult.setSsn(rspBO.getCwdjid());
            if ("1".equals(rspBO.getRspcode())) {
                wfEventResult.setSuccess(true);
            } else {
                wfEventResult.setSuccess(false);
            }
            wfEventResult.setRespDesc(rspBO.getRspmsg());
            wfEventResult.setRespCode(rspBO.getRspcode());
        }
        catch (Exception e) {
            wfEventResult.setSuccess(false);
            wfEventResult.setRespDesc("\u9519\u8bef\u4fe1\u606f\uff1a" + e);
            logger.error("\u6536\u6b3e\u5355\uff08\u6536\u6b3e\u4e1a\u52a1\u5904\u7406\u5355\uff09\u8c03\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25\uff01 ", (Throwable)e);
        }
        return wfEventResult;
    }
}

