/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.ElectronicInvoiceAtomService;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiApplyBillApplyInfoXbjService;
import com.tydic.fsc.settle.busi.api.bo.BusiApplyBillApplyInfoXbjReqBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.vo.BillApplyInfoVO;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.InvoiceClasses;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BusiApplyBillApplyInfoXbjServiceImpl
implements BusiApplyBillApplyInfoXbjService {
    private static final Logger logger = LoggerFactory.getLogger(BusiApplyBillApplyInfoXbjServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private ElectronicInvoiceAtomService electronicInvoiceAtomService;

    public FscBaseRspBo update(BusiApplyBillApplyInfoXbjReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u63a8\u9001\u7a0e\u63a7\u670d\u52a1(\u8be2\u6bd4\u4ef7)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List applyNoList = reqBO.getApplyNoList();
        if (applyNoList == null || applyNoList.isEmpty()) {
            throw new BusinessException("0001", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        ArrayList<String> billStatusNotIn = new ArrayList<String>();
        billStatusNotIn.add(BillStatus.NO_APPLY.getCode());
        billApplyInfoVO.setBillStatusNotIn(billStatusNotIn);
        int count = this.billApplyInfoMapper.selectCount(billApplyInfoVO);
        if (count > 0) {
            throw new BusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u5355\u7684\u5f00\u7968\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u63d0\u4ea4");
        }
        ArrayList<String> validApplyNos = new ArrayList<String>();
        ArrayList<String> batchApplyNoList = new ArrayList<String>();
        for (String applyNo : applyNoList) {
            BillApplyInfo billApply = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
            String invoiceClasses = billApply.getInvoiceClasses();
            if (InvoiceClasses.ELECTRONIC_INVOICE.getCode().equals(invoiceClasses)) {
                validApplyNos.add(applyNo);
                continue;
            }
            if (!InvoiceClasses.PAPER_INVOICE.getCode().equals(invoiceClasses)) continue;
            batchApplyNoList.add(applyNo);
        }
        if (!CollectionUtils.isEmpty(batchApplyNoList)) {
            BillApplyInfoVO applyInfoVO = new BillApplyInfoVO();
            applyInfoVO.setApplyNoList(batchApplyNoList);
            applyInfoVO.setBillStatus(BillStatus.NO_APPLY.getCode());
            BillApplyInfo billApplyInfo = new BillApplyInfo();
            billApplyInfo.setBillStatus(BillStatus.APPLIED.getCode());
            this.billApplyInfoMapper.updateByCondition(applyInfoVO, billApplyInfo);
        }
        if (!CollectionUtils.isEmpty(validApplyNos)) {
            this.electronicInvoiceAtomService.applyBlueInvoice(validApplyNos);
        }
        BillApplyInfoVO applyInfo = new BillApplyInfoVO();
        applyInfo.setApplyNoList(applyNoList);
        BillApplyInfo updateBillApply = new BillApplyInfo();
        updateBillApply.setPushPeopleId(reqBO.getUserId());
        this.billApplyInfoMapper.updateByCondition(applyInfo, updateBillApply);
        return new FscBaseRspBo();
    }
}

