/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.BusiCancelInvoiceService;
import com.tydic.fsc.settle.busi.api.bo.BusiCancelInvoiceReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiCancelInvoiceRspBO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceDetailMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.PayInvoiceInfo;
import com.tydic.fsc.settle.dao.po.PayItemInfo;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import com.tydic.fsc.settle.enums.OrderStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiCancelInvoiceServiceImpl
implements BusiCancelInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCancelInvoiceServiceImpl.class);
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;

    public BusiCancelInvoiceRspBO cancelInvoices(BusiCancelInvoiceReqBO reqBO) {
        logger.info("\u53d6\u6d88\u53d1\u7968\u8bf7\u6c42BO=" + reqBO);
        String notificationNo = reqBO.getNotificationNo();
        Long companyId = reqBO.getCompanyId();
        if (!StringUtils.hasText((String)notificationNo)) {
            throw new BusinessException("0001", "\u901a\u77e5\u5355\u53f7\u5fc5\u987b\u8f93\u5165(notificationNo)");
        }
        if (companyId == null) {
            throw new BusinessException("0001", "\u5728\u8bf7\u6c42\u6570\u636e\u4e2d\u65e0\u6cd5\u786e\u5b9a\u4e13\u4e1a\u516c\u53f8");
        }
        BillNotificationInfo bill = this.billNotificationInfoMapper.selectByPrimaryAndCompany(notificationNo, companyId);
        if (bill == null) {
            throw new BusinessException("0001", "\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        }
        if (!NotificationInvoiceStatus.HAS_MAKE.getCode().equals(bill.getInvoiceStatus())) {
            throw new BusinessException("0001", "\u53ea\u6709\u5df2\u5f00\u7968\u72b6\u6001\u7684\u901a\u77e5\u5355\u624d\u53ef\u4ee5\u9000\u53d1\u7968");
        }
        List<PayInvoiceInfo> invs = this.payInvoiceInfoMapper.selectByNotifyNo(notificationNo);
        int ivCnt = invs.size();
        if (ivCnt == 0) {
            throw new BusinessException("0001", "\u901a\u77e5\u5355\u4e2d\u672a\u53d1\u73b0\u53d1\u7968\u4fe1\u606f");
        }
        this.doCancelInv(notificationNo, invs);
        BusiCancelInvoiceRspBO rsp = new BusiCancelInvoiceRspBO();
        rsp.setRemark("\u53d1\u7968\u4f5c\u5e9f\u6210\u529f");
        return rsp;
    }

    private void doCancelInv(String notificationNo, List<PayInvoiceInfo> invs) {
        this.payInvoiceInfoMapper.deleteByNotificationNo(notificationNo, null);
        ArrayList<String> invoiceCodeAndNoList = new ArrayList<String>();
        Date invDate = null;
        for (PayInvoiceInfo iv : invs) {
            if (invDate == null) {
                invDate = iv.getInvoiceDate();
            }
            invoiceCodeAndNoList.add(iv.getInvoiceCode() + iv.getInvoiceNo());
        }
        this.payInvoiceDetailMapper.deleteByInvoiceList(invDate, invoiceCodeAndNoList);
        BillNotificationInfo updBill = new BillNotificationInfo();
        updBill.setNotificationNo(notificationNo);
        updBill.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
        this.billNotificationInfoMapper.updateByPrimaryKeySelective(updBill);
        PayItemInfo payItemUpd = new PayItemInfo();
        payItemUpd.setNotificationNo(notificationNo);
        payItemUpd.setItemStatus(OrderStatus.APPLIED.getCode());
        this.payItemInfoMapper.updateByPrimaryKeySelective(payItemUpd);
    }
}

