/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiCheckSignService;
import com.tydic.fsc.settle.busi.api.bo.BusiCheckSignServiceReqBO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiCheckSignServiceImpl
implements BusiCheckSignService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCheckSignServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;

    public FscBaseRspBo query(BusiCheckSignServiceReqBO reqBO) {
        List notificationNos;
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f00\u7968\u901a\u77e5\u5355\u6279\u91cf\u6838\u5bf9\u7b7e\u6536\u6821\u9a8c\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)(notificationNos = reqBO.getNotificationNos()))) {
            throw new BusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        for (String notificationNo : notificationNos) {
            BillNotificationInfo bill = this.billNotificationInfoMapper.selectByPrimaryKey(notificationNo);
            if (null == bill) {
                throw new BusinessException("0001", "\u5f00\u7968\u901a\u77e5\u5355" + notificationNo + "\u4e0d\u5b58\u5728");
            }
            NotificationInvoiceStatus nowSta = NotificationInvoiceStatus.getInstance(bill.getInvoiceStatus());
            if (null == nowSta) {
                throw new BusinessException("0001", "\u5f00\u7968\u901a\u77e5\u5355" + notificationNo + "\u65e0\u6548\u7684\u53d1\u7968\u72b6\u6001\u503c");
            }
            if (NotificationInvoiceStatus.HAS_MAKE == nowSta) continue;
            throw new BusinessException("0001", "\u53ea\u6709\u5df2\u5f00\u7968\u72b6\u6001\u7684\u5f00\u7968\u901a\u77e5\u5355\u624d\u53ef\u8fdb\u884c\u6838\u5bf9\u7b7e\u6536\u64cd\u4f5c");
        }
        FscBaseRspBo rspBo = new FscBaseRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6279\u91cf\u6838\u5bf9\u7b7e\u6536\u6821\u9a8c\u6210\u529f");
        return rspBo;
    }
}

