/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.BillSNService;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.FscWfStartAtomService;
import com.tydic.fsc.settle.atom.bo.FscWfStartAtomReqBO;
import com.tydic.fsc.settle.atom.bo.FscWfStartAtomRspBO;
import com.tydic.fsc.settle.busi.api.BusiCreateOutstockTotalService;
import com.tydic.fsc.settle.busi.api.bo.BusiCreateOutstockTotalReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiCreateOutstockTotalRspBO;
import com.tydic.fsc.settle.dao.OutstockInfoMapper;
import com.tydic.fsc.settle.dao.OutstockTotalMapper;
import com.tydic.fsc.settle.dao.po.OutstockInfo;
import com.tydic.fsc.settle.dao.po.OutstockTotal;
import com.tydic.fsc.settle.dao.vo.OutStockWithItemVO;
import com.tydic.fsc.settle.dao.vo.OutstockInfoVO;
import com.tydic.fsc.settle.enums.BillType;
import com.tydic.fsc.settle.enums.OutstockInfoStatus;
import com.tydic.fsc.settle.enums.WFBillType;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusiCreateOutstockTotalServiceImpl
implements BusiCreateOutstockTotalService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCreateOutstockTotalServiceImpl.class);
    private final BillSNService billSNService;
    private final OutstockInfoMapper outstockInfoMapper;
    private final OutstockTotalMapper outstockTotalMapper;
    private final FscWfStartAtomService fscWfStartAtomService;
    private final EnumsService enumsService;

    @Autowired
    public BusiCreateOutstockTotalServiceImpl(BillSNService billSNService, OutstockInfoMapper outstockInfoMapper, OutstockTotalMapper outstockTotalMapper, FscWfStartAtomService fscWfStartAtomService, EnumsService enumsService) {
        this.billSNService = billSNService;
        this.outstockInfoMapper = outstockInfoMapper;
        this.outstockTotalMapper = outstockTotalMapper;
        this.fscWfStartAtomService = fscWfStartAtomService;
        this.enumsService = enumsService;
    }

    public BusiCreateOutstockTotalRspBO createOutstockTotal(BusiCreateOutstockTotalReqBO reqBO) {
        BusiCreateOutstockTotalRspBO rspBO = new BusiCreateOutstockTotalRspBO();
        StringBuilder sb = new StringBuilder();
        List<OutStockWithItemVO> outstockInfos = this.queryOutstockInfos(reqBO);
        int limitCount = this.enumsService.queryOstGroupByOsdLimit();
        BigDecimal sumUntaxAmt = BigDecimal.ZERO;
        BigDecimal sumTaxAmt = BigDecimal.ZERO;
        int count = 0;
        int detailCounts = 0;
        String totalNo = this.billSNService.getSnAsString(BillType.MATERIAL_COLLECT);
        for (int i = 0; i < outstockInfos.size(); ++i) {
            OutStockWithItemVO outstockInfo = outstockInfos.get(i);
            String outstockNo = outstockInfos.get(i).getOutstockNo();
            if (OutstockInfoStatus.SUMMED.getCode().equals(outstockInfo.getStatus())) {
                logger.error("\u751f\u6210\u51fa\u5e93\u6c47\u603b\u5355\u5931\u8d25\uff1a\u51fa\u5e93\u5355\u53f7\u4e3a" + outstockNo + "\u7684\u51fa\u5e93\u5355\u5df2\u6c47\u603b");
                continue;
            }
            String source = outstockInfo.getSource();
            int detailCount = outstockInfo.getCount();
            if (detailCounts + detailCount > limitCount && count > 0) {
                this.doCollectOutstock(totalNo, reqBO, source, sumUntaxAmt, sumTaxAmt, sb);
                sumUntaxAmt = BigDecimal.ZERO;
                sumTaxAmt = BigDecimal.ZERO;
                count = 0;
                detailCounts = 0;
                totalNo = this.billSNService.getSnAsString(BillType.MATERIAL_COLLECT);
            }
            sumUntaxAmt = sumUntaxAmt.add(outstockInfo.getUntaxAmt());
            sumTaxAmt = sumTaxAmt.add(outstockInfo.getTaxAmt());
            ++count;
            detailCounts += detailCount;
            OutstockInfo updateOutstock = new OutstockInfo();
            updateOutstock.setOutstockNo(outstockInfo.getOutstockNo());
            updateOutstock.setTotalNo(totalNo);
            updateOutstock.setStatus(OutstockInfoStatus.SUMMED.getCode());
            this.outstockInfoMapper.updateByPrimaryKeySelective(updateOutstock);
            if (i != outstockInfos.size() - 1) continue;
            this.doCollectOutstock(totalNo, reqBO, source, sumUntaxAmt, sumTaxAmt, sb);
        }
        if (sb.length() <= 0) {
            throw new BusinessException("18000", "\u672a\u751f\u6210\u6709\u6548\u7684\u51fa\u5e93\u6c47\u603b\u5355\uff0c\u8bf7\u68c0\u67e5\u51fa\u5e93\u5355\u72b6\u6001");
        }
        sb.setLength(sb.length() - 1);
        rspBO.setTotalNo(sb.toString());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u751f\u6210\u51fa\u5e93\u6c47\u603b\u5355\u6210\u529f");
        return rspBO;
    }

    private List<OutStockWithItemVO> queryOutstockInfos(BusiCreateOutstockTotalReqBO reqBO) {
        OutstockInfoVO outstockInfoVO = new OutstockInfoVO();
        if ("1".equals(reqBO.getAllFlag())) {
            if (!StringUtils.hasText((String)reqBO.getSource())) {
                throw new BusinessException("0001", "\u6765\u6e90\u5fc5\u9009");
            }
            outstockInfoVO.setSource(reqBO.getSource());
            outstockInfoVO.setCompanyOrg(reqBO.getCompanyId());
            outstockInfoVO.setStatus(OutstockInfoStatus.NO_SUM.getCode());
        } else {
            if (CollectionUtils.isEmpty((Collection)reqBO.getOutstockNoList())) {
                throw new BusinessException("0001", "\u8bf7\u52fe\u9009\u51fa\u5e93\u5355");
            }
            outstockInfoVO.setStatus(OutstockInfoStatus.NO_SUM.getCode());
            outstockInfoVO.setOutstockNos(reqBO.getOutstockNoList());
        }
        List<OutStockWithItemVO> outstockInfos = this.outstockInfoMapper.selectOutStockWithItemCountByCondition(outstockInfoVO);
        if (CollectionUtils.isEmpty(outstockInfos)) {
            throw new BusinessException("18000", "\u6ca1\u6709\u672a\u6c47\u603b\u7684\u51fa\u5e93\u5355\uff0c\u6216\u8005\u51fa\u5e93\u5355\u6ca1\u6709\u6709\u6548\u7684\u53d1\u7968");
        }
        return outstockInfos;
    }

    private void doCollectOutstock(String totalNo, BusiCreateOutstockTotalReqBO reqBO, String source, BigDecimal sumUntaxAmt, BigDecimal sumTaxAmt, StringBuilder sb) {
        OutstockTotal outstockTotal = new OutstockTotal();
        outstockTotal.setTotalNo(totalNo);
        outstockTotal.setCreateDate(new Date());
        outstockTotal.setOrgId(reqBO.getCompanyId());
        outstockTotal.setUserId(reqBO.getUserId());
        outstockTotal.setSource(source);
        outstockTotal.setUntaxAmt(sumUntaxAmt);
        outstockTotal.setTaxAmt(sumTaxAmt);
        this.outstockTotalMapper.insertSelective(outstockTotal);
        sb.append(totalNo).append(",");
        FscWfStartAtomReqBO atomReqBO = new FscWfStartAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)atomReqBO));
        atomReqBO.setBillType(WFBillType.OUTBOUND_COLLECTION);
        atomReqBO.setFinishEvtServiceId("outstockTotalWorkFlowFinishEventImpl");
        atomReqBO.setBillNo(totalNo);
        FscWfStartAtomRspBO atomRspBO = this.fscWfStartAtomService.dealStartApproval(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new BusinessException("18000", "\u751f\u6210\u51fa\u5e93\u6c47\u603b\u5355\u670d\u52a1\u5931\u8d25\uff0c\u53d1\u8d77\u5ba1\u6279\u5931\u8d25");
        }
    }
}

