/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.tydic.fsc.settle.atom.PayInvoiceService;
import com.tydic.fsc.settle.busi.api.BusiGetInvoiceService;
import com.tydic.fsc.settle.busi.api.BusiInvoiceWayBillService;
import com.tydic.fsc.settle.busi.api.bo.BusiInvoiceWayBillReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiInvoiceWayBillRspBO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.PayInvoiceInfo;
import com.tydic.fsc.settle.enums.InvoiceMailStatus;
import com.tydic.fsc.settle.utils.DatesUtils;
import com.tydic.fsc.settle.vo.BusiInvoiceWayBillVO;
import com.tydic.fsc.supplier.BusiInvoiceWayDataService;
import com.tydic.fsc.supplier.bo.BusiInvoiceWayDataReqBO;
import com.tydic.fsc.supplier.bo.BusiInvoiceWayDataVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiInvoiceWayBillServiceImpl
implements BusiInvoiceWayBillService {
    private static final Log log = LogFactory.getLog(BusiInvoiceWayBillServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper notificationInfomapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private BusiInvoiceWayDataService apiBusiInvoiceWayDataService;
    @Autowired(required=false)
    private BusiGetInvoiceService busiGetInvoiceService;
    @Autowired
    private PayInvoiceService payInvoiceService;

    public BusiInvoiceWayBillRspBO getInvoiceWayBill(BusiInvoiceWayBillReqBO reqBO) {
        BusiInvoiceWayBillRspBO rspBO = new BusiInvoiceWayBillRspBO();
        if (this.busiGetInvoiceService.isBusy()) {
            log.info((Object)"---invoice info query is busy,skip process.");
            return rspBO;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" \u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reqBO.toString()));
        }
        PayInvoiceInfo payInvocieInfo = new PayInvoiceInfo();
        payInvocieInfo.setMailStatus(InvoiceMailStatus.NOT_SENT.getCode());
        payInvocieInfo.setInvoiceDate(DatesUtils.dateBefore(-5));
        List<PayInvoiceInfo> payInvoiceInfoList = this.payInvoiceInfoMapper.selectUnsentInvoices(payInvocieInfo);
        if (null == payInvoiceInfoList || payInvoiceInfoList.isEmpty()) {
            log.info((Object)"\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u8868\u4e2d\u90ae\u5bc4\u72b6\u6001\u4e3a00\uff0c\u6700\u8fd15\u5929\u7684\u53d1\u7968\u4fe1\u606f\u8bb0\u5f55\u4e3a\u7a7a");
            return rspBO;
        }
        log.info((Object)("\u9700\u8865\u5145\u90ae\u5bc4\u4fe1\u606f\u7684\u53d1\u7968,\u6570\u91cf=" + payInvoiceInfoList.size()));
        HashMap<String, String> queryData = new HashMap<String, String>();
        BusiInvoiceWayDataReqBO invoiceWayBillReqBO = new BusiInvoiceWayDataReqBO();
        for (PayInvoiceInfo invoiceInfo : payInvoiceInfoList) {
            BillNotificationInfo notificationInfo = this.notificationInfomapper.selectByPrimaryKey(invoiceInfo.getNotificationNo());
            if (notificationInfo == null) {
                log.error((Object)("\u627e\u4e0d\u5230\u53d1\u7968\u5bf9\u5e94\u7684\u901a\u77e5\u5355,\u53d1\u7968\u53f7\u7801=" + invoiceInfo.getInvoiceNo() + ",\u901a\u77e5\u5355\u53f7=" + invoiceInfo.getNotificationNo()));
                continue;
            }
            String supplierId = String.valueOf(notificationInfo.getSupplierNo());
            queryData.put(invoiceInfo.getNotificationNo(), supplierId);
        }
        if (queryData.isEmpty()) {
            log.error((Object)"\u627e\u4e0d\u5230\u901a\u77e5\u5355\u53ca\u5176\u4f9b\u5e94\u5546ID,\u9000\u51fa\u83b7\u53d6\u90ae\u5bc4\u4fe1\u606f\u5904\u7406");
            return rspBO;
        }
        log.info((Object)("\u67e5\u8be2\u53d1\u7968\u90ae\u5bc4\u4fe1\u606f,\u6d89\u53ca\u901a\u77e5\u5355\u53f7:" + queryData));
        invoiceWayBillReqBO.setQueryData(queryData);
        List dataVOList = this.apiBusiInvoiceWayDataService.getInvoiceWayData(invoiceWayBillReqBO).getMailStatusList();
        if (null == dataVOList || dataVOList.isEmpty()) {
            log.error((Object)"\u67e5\u8be2\u53d1\u7968\u90ae\u5bc4\u4fe1\u606f,API\u63a5\u53e3\u672a\u8fd4\u56de\u6570\u636e\u884c");
            return rspBO;
        }
        ArrayList<BusiInvoiceWayBillVO> billVOList = new ArrayList<BusiInvoiceWayBillVO>();
        for (BusiInvoiceWayDataVO dataVO : dataVOList) {
            log.info((Object)("\u67e5\u8be2\u53d1\u7968\u90ae\u5bc4\u4fe1\u606f\u8fd4\u56de:" + dataVO.getNotificationNo() + "-->" + dataVO));
            if (dataVO.getResultCode() == null || dataVO.getResultCode().equals("3305")) continue;
            BusiInvoiceWayBillVO billVO = new BusiInvoiceWayBillVO();
            BeanUtils.copyProperties((Object)dataVO, (Object)billVO);
            billVOList.add(billVO);
        }
        ArrayList<String> mailStatusList = new ArrayList<String>();
        for (BusiInvoiceWayBillVO mailStatusVO : billVOList) {
            StringBuilder builder = new StringBuilder();
            builder.append("--\u8fd0\u5355\u53f7:" + mailStatusVO.getDeliveryId());
            builder.append("--\u914d\u9001\u516c\u53f8:" + mailStatusVO.getPostCompany());
            builder.append("--\u914d\u9001\u65f6\u95f4:" + mailStatusVO.getPostTime());
            builder.append("--\u914d\u9001\u72b6\u6001:" + mailStatusVO.getState());
            String mailInfo = builder.toString();
            PayInvoiceInfo updateInvoice = new PayInvoiceInfo();
            updateInvoice.setNotificationNo(mailStatusVO.getNotificationNo());
            this.payInvoiceService.updateMailSendStatus(updateInvoice, mailInfo);
            mailStatusList.add(builder.toString());
        }
        rspBO.setMailStatusList(mailStatusList);
        return rspBO;
    }
}

