/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.BillSNService;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.SequenceNoService;
import com.tydic.fsc.settle.atom.SmsService;
import com.tydic.fsc.settle.busi.api.BusiNotificationDlzqService;
import com.tydic.fsc.settle.busi.api.bo.BusiNotificationDlzqReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiNotificationDlzqRspBO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfoExt;
import com.tydic.fsc.settle.dao.po.PayItemInfo;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.dao.vo.PayItemInfoVO;
import com.tydic.fsc.settle.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.fsc.settle.enums.BillType;
import com.tydic.fsc.settle.enums.InvoiceStatus;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.OrderStatus;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiNotificationDlzqServiceImpl
implements BusiNotificationDlzqService {
    private static final Logger logger = LoggerFactory.getLogger(BusiNotificationDlzqServiceImpl.class);
    private SequenceNoService notificationSeqNoService;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private EnumsService enumsService;

    public BusiNotificationDlzqRspBO makeNotify(BusiNotificationDlzqReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7535\u529b\u4e13\u533a-\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getInvoiceInfo() || !StringUtils.hasText((String)reqBO.getInvoiceInfo().getInvoiceTitle())) {
            throw new BusinessException("0001", "\u53d1\u7968\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (null == reqBO.getMailAddrInfo() || !StringUtils.hasText((String)reqBO.getMailAddrInfo().getName())) {
            throw new BusinessException("0001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (null == reqBO.getCompanyId()) {
            throw new BusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-Session\u4e13\u4e1a\u516c\u53f8\u673a\u6784ID[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List seqNos = reqBO.getSeqNos();
        if (seqNos == null || seqNos.isEmpty()) {
            throw new BusinessException("0001", "\u8bf7\u9009\u62e9\u5546\u54c1\u660e\u7ec6");
        }
        PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
        payItemInfoVO.setSeqList(seqNos);
        payItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
        List<PayItemInfo> payItemList = this.payItemInfoMapper.selectBy(payItemInfoVO);
        if (payItemList.size() != seqNos.size()) {
            throw new BusinessException("18001", "\u72b6\u6001\u5df2\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
        }
        PayPurchaseOrderInfo order = new PayPurchaseOrderInfo();
        order.setInspectionId(payItemList.get(0).getInspectionId());
        order = this.payPurchaseOrderInfoMapper.getModelBy(order);
        String source = order.getSource();
        HashSet<Long> inspectionIds = new HashSet<Long>();
        for (PayItemInfo payItemInfo : payItemList) {
            inspectionIds.add(payItemInfo.getInspectionId());
        }
        payItemInfoVO = new PayItemInfoVO();
        payItemInfoVO.setInspectionIds(new ArrayList<Long>(inspectionIds));
        payItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
        int total = this.payItemInfoMapper.selectCount(payItemInfoVO);
        if (payItemList.size() < total) {
            throw new BusinessException("18000", "\u8ba2\u5355\u7684\u5546\u54c1\u660e\u7ec6\u5fc5\u987b\u5168\u9009");
        }
        LinkedList<String> notificationNos = new LinkedList<String>();
        List<List<PayItemInfo>> groupList = null;
        groupList = OrderSource.CONSULT_PRICE.getCode().equals(source) || OrderSource.CONSULT_PRICE_FRAME.getCode().equals(source) ? this.getGroupBySupplierNo(payItemList, new ArrayList<Long>(inspectionIds)) : this.getGroupByOrderId(payItemList);
        if (CollectionUtils.isEmpty(groupList)) {
            throw new BusinessException("18001", "\u8bf7\u9009\u62e9\u5546\u54c1\u660e\u7ec6");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("groupList========\uff1a" + groupList.size());
            logger.debug("groupList.tostring========\uff1a" + groupList.toString());
        }
        HashSet<Long> inspectionIdSet = new HashSet<Long>();
        LinkedList<BillNotificationInfoExt> insertList = new LinkedList<BillNotificationInfoExt>();
        for (List<PayItemInfo> payItems : groupList) {
            if (CollectionUtils.isEmpty(payItems)) continue;
            PayItemInfo firstPayItemInfo = payItems.get(0);
            PayPurchaseOrderInfo payPurchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelByPrimaryKey(firstPayItemInfo.getOrderId(), firstPayItemInfo.getInspectionId());
            if (payPurchaseOrderInfo == null) {
                throw new BusinessException("18001", "\u8ba2\u5355\u53f7\u4e3a\uff1a" + payItems.get(0).getOrderId() + "\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            source = payPurchaseOrderInfo.getSource();
            Long operUnitNo = payPurchaseOrderInfo.getOperUnitNo();
            if (!operUnitNo.equals(reqBO.getCompanyId())) {
                throw new BusinessException("18001", "\u4e0d\u80fd\u529e\u7406\u5176\u4ed6\u516c\u53f8\u7684\u4e1a\u52a1");
            }
            String notifyNo = this.billSNService.getSnAsString(BillType.INVOICE_NOTIFYCATION);
            BillNotificationInfoExt notifyInfo = new BillNotificationInfoExt();
            BigDecimal sumAmt = BigDecimal.ZERO;
            notifyInfo.setNotificationNo(notifyNo);
            notifyInfo.setApplyDate(new Date());
            notifyInfo.setOperNo(operUnitNo);
            if (OrderSource.CONSULT_PRICE.getCode().equals(payPurchaseOrderInfo.getSource()) || OrderSource.CONSULT_PRICE_FRAME.getCode().equals(payPurchaseOrderInfo.getSource())) {
                notifyInfo.setSource(OrderSource.CONSULT_PRICE.getCode());
            } else {
                notifyInfo.setSource(payPurchaseOrderInfo.getSource());
            }
            notifyInfo.setSupplierNo(payPurchaseOrderInfo.getSupplierNo());
            notifyInfo.setUserId(reqBO.getUserId());
            notifyInfo.setAddr(reqBO.getInvoiceInfo().getAddress());
            notifyInfo.setBankAccNo(reqBO.getInvoiceInfo().getAccount());
            notifyInfo.setBankName(reqBO.getInvoiceInfo().getBank());
            notifyInfo.setInvoceName(reqBO.getInvoiceInfo().getInvoiceTitle());
            notifyInfo.setInvoceType(reqBO.getInvoiceInfo().getInvoiceType());
            notifyInfo.setInvoiceStatus(InvoiceStatus.HAS_MAKE.getCode());
            notifyInfo.setPhone(reqBO.getInvoiceInfo().getPhone());
            notifyInfo.setTaxNo(reqBO.getInvoiceInfo().getTaxpayerId());
            notifyInfo.setAddrDesc(reqBO.getMailAddrInfo().getAddrDesc());
            notifyInfo.setProvince(reqBO.getMailAddrInfo().getProvince());
            notifyInfo.setCity(reqBO.getMailAddrInfo().getCity());
            notifyInfo.setCounty(reqBO.getMailAddrInfo().getCounty());
            notifyInfo.setTown(reqBO.getMailAddrInfo().getTown());
            notifyInfo.setProvId(reqBO.getMailAddrInfo().getProvId());
            notifyInfo.setCityId(reqBO.getMailAddrInfo().getCityId());
            notifyInfo.setCountyId(reqBO.getMailAddrInfo().getCountyId());
            notifyInfo.setTownId(reqBO.getMailAddrInfo().getTownId());
            notifyInfo.setCompany(reqBO.getMailAddrInfo().getCompany());
            notifyInfo.setMobile(reqBO.getMailAddrInfo().getTel());
            notifyInfo.setTel(reqBO.getMailAddrInfo().getSpecialPlane());
            notifyInfo.setName(reqBO.getMailAddrInfo().getName());
            notifyInfo.setPostCode(reqBO.getMailAddrInfo().getPostCode());
            notifyInfo.setProfessionalDepartId(payPurchaseOrderInfo.getProfessionalDepartId());
            notifyInfo.setServiceDepartId(payPurchaseOrderInfo.getServiceDepartId());
            notifyInfo.setBranchCompany(payPurchaseOrderInfo.getBranchCompany());
            for (PayItemInfo singleItem : payItems) {
                if (singleItem.getInspectionId() == null || singleItem.getInspectionId() <= 0L) {
                    throw new BusinessException("18001", "\u672a\u627e\u5230\u5546\u54c1\u660e\u7ec6\u5bf9\u5e94\u7684\u91c7\u8d2d\u8ba2\u5355\uff0c\u8bf7\u6838\u5b9e");
                }
                inspectionIdSet.add(singleItem.getInspectionId());
                PayItemInfo item = new PayItemInfo();
                item.setSeq(singleItem.getSeq());
                item.setNotificationNo(notifyNo);
                item.setItemStatus(OrderStatus.APPLIED.getCode());
                this.payItemInfoMapper.updateByPKSeqUnsent(item);
                sumAmt = sumAmt.add(singleItem.getAmount());
            }
            notifyInfo.setAmt(sumAmt);
            insertList.add(notifyInfo);
            notificationNos.add(notifyNo);
        }
        this.payPurchaseOrderInfoMapper.updateOrderStatusByInspectionIds(new ArrayList<Long>(inspectionIdSet), OrderStatus.APPLIED.getCode());
        this.billNotificationInfoMapper.insertBatch(insertList);
        BusiNotificationDlzqRspBO rspBO = new BusiNotificationDlzqRspBO();
        rspBO.setNotificationNos(notificationNos);
        if (reqBO.getIsSendSms() != null && reqBO.getIsSendSms() == 1) {
            this.sendSms(payItemList, inspectionIds);
        }
        return rspBO;
    }

    private void sendSms(List<PayItemInfo> payItemList, Set<Long> inspectionIds) {
    }

    private List<List<PayItemInfo>> getGroupByOrderId(List<PayItemInfo> payItemList) {
        LinkedList<List<PayItemInfo>> groupList = new LinkedList<List<PayItemInfo>>();
        HashMap dataMap = new HashMap(16);
        for (PayItemInfo payItemInfo : payItemList) {
            if (payItemInfo.getOrderId() == null || payItemInfo.getOrderId() <= 0L) {
                throw new BusinessException("18001", "\u672a\u627e\u5230\u5546\u54c1\u660e\u7ec6\u5bf9\u5e94\u7684\u91c7\u8d2d\u8ba2\u5355\uff0c\u8bf7\u6838\u5b9e");
            }
            if (dataMap.get(payItemInfo.getOrderId()) != null) {
                ((List)dataMap.get(payItemInfo.getOrderId())).add(payItemInfo);
                continue;
            }
            LinkedList<PayItemInfo> dataList = new LinkedList<PayItemInfo>();
            dataList.add(payItemInfo);
            dataMap.put(payItemInfo.getOrderId(), dataList);
        }
        for (Map.Entry entry : dataMap.entrySet()) {
            groupList.add((List<PayItemInfo>)entry.getValue());
        }
        return groupList;
    }

    private List<List<PayItemInfo>> getGroupBySupplierNo(List<PayItemInfo> payItemList, List<Long> inspectionIds) {
        LinkedList<List<PayItemInfo>> groupList = new LinkedList<List<PayItemInfo>>();
        HashMap dataMap = new HashMap(16);
        PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
        payPurchaseOrderInfoVO.setInspectionIds(inspectionIds);
        List<PayPurchaseOrderInfo> purchaseOrderInfoList = this.payPurchaseOrderInfoMapper.getListByVO(payPurchaseOrderInfoVO);
        for (PayItemInfo payItemInfo : payItemList) {
            for (PayPurchaseOrderInfo payPurchaseOrder : purchaseOrderInfoList) {
                if (!payPurchaseOrder.getInspectionId().equals(payItemInfo.getInspectionId())) continue;
                if (dataMap.get(payPurchaseOrder.getSupplierNo()) != null) {
                    ((List)dataMap.get(payPurchaseOrder.getSupplierNo())).add(payItemInfo);
                    continue;
                }
                LinkedList<PayItemInfo> dataList = new LinkedList<PayItemInfo>();
                dataList.add(payItemInfo);
                dataMap.put(payPurchaseOrder.getSupplierNo(), dataList);
            }
        }
        for (Map.Entry entry : dataMap.entrySet()) {
            groupList.add((List<PayItemInfo>)entry.getValue());
        }
        return groupList;
    }
}

