/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.SubAccountRespInitService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.busi.api.BusiProSubAccountListService;
import com.tydic.fsc.settle.busi.api.bo.BusiSubAccountInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiSubAccountInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiSubAccountListRspBO;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.dao.SubAcctInfoMapper;
import com.tydic.fsc.settle.dao.po.Pagination;
import com.tydic.fsc.settle.enums.SubAccountServiceType;
import com.tydic.fsc.settle.utils.BusinessUtils;
import com.tydic.fsc.supplier.FscUmcQryEnterpriseAccountsAbilityService;
import com.tydic.fsc.supplier.bo.ProjectInfoBO;
import com.tydic.fsc.supplier.bo.UserDetailInfoBO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusiProSubAccountListServiceImpl
implements BusiProSubAccountListService {
    private static final Logger logger = LoggerFactory.getLogger(BusiProSubAccountListServiceImpl.class);
    private SubAcctInfoMapper mapper;
    private OrganizationInfoService orgService;
    private SubAccountRespInitService initSerivce;
    private OrganizationInfoService organizationInfoService;
    private UserInfoService userInfoService;
    private FscUmcQryEnterpriseAccountsAbilityService fscUmcQryEnterpriseAccountsAbilityService;

    @Autowired
    private BusiProSubAccountListServiceImpl(SubAcctInfoMapper mapper, OrganizationInfoService orgService, SubAccountRespInitService initSerivce, OrganizationInfoService organizationInfoService, UserInfoService userInfoService, FscUmcQryEnterpriseAccountsAbilityService fscUmcQryEnterpriseAccountsAbilityService) {
        this.mapper = mapper;
        this.orgService = orgService;
        this.initSerivce = initSerivce;
        this.organizationInfoService = organizationInfoService;
        this.userInfoService = userInfoService;
        this.fscUmcQryEnterpriseAccountsAbilityService = fscUmcQryEnterpriseAccountsAbilityService;
    }

    public BusiSubAccountListRspBO listSubAccount(BusiSubAccountInfoReqBO reqBO) {
        Long oprOrgId;
        if (logger.isDebugEnabled()) {
            logger.debug("\u5b50\u8d26\u53f7\u5217\u8868\u67e5\u8be2\u5165\u53c2:" + reqBO);
        }
        BusiSubAccountListRspBO retBo = new BusiSubAccountListRspBO();
        String validateArgStr = this.validateArg(reqBO);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("18051");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        Long acctOrgId = reqBO.getAcctOrgId();
        Long superiorOrgId = reqBO.getSuperiorOrgId();
        Long companyId = reqBO.getCompanyId();
        Long operUnitNo = reqBO.getOperUnitNo();
        UserDetailInfoBO userDetailInfoBO = this.userInfoService.queryUserInfoByUserId(reqBO.getUserId());
        if (null != userDetailInfoBO) {
            reqBO.setOrgId(userDetailInfoBO.getOrgId());
            reqBO.setCompanyId(userDetailInfoBO.getCompanyId());
            companyId = reqBO.getCompanyId();
        }
        if ((oprOrgId = reqBO.getOrgId()) == null) {
            throw new BusinessException("18998", "\u65e0\u6cd5\u8bc6\u522b\u64cd\u4f5c\u5458\u6240\u5728\u7684\u673a\u6784\u53f7");
        }
        Integer channelType = reqBO.getChannelType();
        Pagination pageInfo = new Pagination();
        pageInfo.setPage(reqBO.getPageNo());
        pageInfo.setPageSize(reqBO.getPageSize());
        SubAcctInfoExt record = new SubAcctInfoExt();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setOrgId(reqBO.getAcctOrgId());
        record.setCompanyType(reqBO.getAcctCompanyType());
        BusiSubAccountListRspBO resp = new BusiSubAccountListRspBO();
        if (channelType > 10 && channelType < 20) {
            if (companyId == null) {
                throw new BusinessException("18998", "\u8bf7\u6c42\u4e2d\u627e\u4e0d\u5230\u516c\u53f8\u673a\u6784\u53f7(companyId)");
            }
            superiorOrgId = BusinessUtils.judgeOperUnitNo(operUnitNo, companyId, false);
            record.setSuperiorOrgId(superiorOrgId);
            if (channelType == 11) {
                record.setOrgId(superiorOrgId);
            } else if (channelType == 12) {
                List<ProjectInfoBO> projectInfoBOList;
                if (null != reqBO.getServiceDepartId() && !CollectionUtils.isEmpty(projectInfoBOList = this.organizationInfoService.queryProjectInfoByServDepartId(Collections.singletonList(reqBO.getServiceDepartId())))) {
                    ArrayList<Long> projectIdList = new ArrayList<Long>();
                    for (ProjectInfoBO accountInfoBO : projectInfoBOList) {
                        projectIdList.add(accountInfoBO.getAccountId());
                    }
                    record.setProjectIdList(projectIdList);
                }
                record.setProjectId(reqBO.getProjectId());
                record.setServiceType(SubAccountServiceType.DEFAULT.getCode());
            }
        } else if (channelType > 20 && channelType < 30) {
            if (acctOrgId == null && (acctOrgId = reqBO.getOrgId()) == null) {
                throw new BusinessException("18998", "\u673a\u6784\u53f7(acctOrgId)\u5fc5\u987b\u8f93\u5165");
            }
            record.setServiceType(SubAccountServiceType.DEFAULT.getCode());
            record.setOrgId(acctOrgId);
            List<Long> childrenOrgIds = this.orgService.getChildrenOrgIds(acctOrgId);
            List purchaseOrgIds = this.fscUmcQryEnterpriseAccountsAbilityService.qryOrgIdList(acctOrgId);
            if (purchaseOrgIds != null && purchaseOrgIds.size() > 0) {
                childrenOrgIds.addAll(purchaseOrgIds);
                logger.debug("\u641c\u7d22\u914d\u9001\u4e2d\u5fc3\u6240\u5c5e\u8be5\u4e13\u4e1a\u516c\u53f8\u7684\u91c7\u8d2d\u5355\u4f4d\u673a\u6784\u96c6\u5408\uff1a" + purchaseOrgIds.toString());
            }
            record.setMultiOrgIds(childrenOrgIds);
            if (childrenOrgIds != null && childrenOrgIds.size() > 0) {
                record.setOrgId(null);
            }
            if (StringUtils.isEmpty((Object)record.getSuperiorOrgId())) {
                record.setSuperiorOrgId(oprOrgId);
            }
        } else {
            throw new BusinessException("18998", "\u672a\u77e5\u7684\u64cd\u4f5c\u6e20\u9053\u7c7b\u578bchannelType");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u5b50\u8d26\u53f7\u67e5\u8be2\u53c2\u6570" + record);
        }
        int tot = this.mapper.selectCountWihtMainAcct(record);
        pageInfo.setTotalCount(tot);
        int rowIndex = pageInfo.getRowIndex();
        record.setPageSize(pageInfo.getPageSize());
        record.setRowIndex(Integer.valueOf(rowIndex));
        record.setOrderBy("SUB_ACCT_NAME ASC");
        List<SubAcctInfoExt> ls = this.mapper.selectWihtMainAcct(record);
        resp.setTotal(pageInfo.getPageCount().intValue());
        resp.setRecordsTotal(pageInfo.getTotalCount().intValue());
        resp.setRows(new ArrayList());
        resp.setPageNo(pageInfo.getPage().intValue());
        Map<Object, Object> serviceDepartNameMap = new HashMap();
        if (channelType == 12) {
            HashSet<Long> accountIdsSet = new HashSet<Long>();
            for (SubAcctInfoExt subAcctInfoExt : ls) {
                accountIdsSet.add(subAcctInfoExt.getProjectId());
            }
            serviceDepartNameMap = this.orgService.queryServiceDepartNameByAccountIds(new ArrayList<Long>(accountIdsSet));
        }
        for (SubAcctInfoExt inf : ls) {
            BusiSubAccountInfoRspBO respBo = new BusiSubAccountInfoRspBO();
            ProjectInfoBO projectInfoBO = this.organizationInfoService.queryProjectName(inf.getProjectId());
            if (null != projectInfoBO) {
                respBo.setProjectDescr(projectInfoBO.getAccountName());
                respBo.setVirtual(projectInfoBO.getIsShadowAccount());
            }
            resp.getRows().add(respBo);
            this.initSerivce.initRespBo(inf, respBo);
            if (null == serviceDepartNameMap || serviceDepartNameMap.isEmpty()) continue;
            logger.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u670d\u52a1\u90e8\u95e8\u7ed3\u679c\uff1a" + JSON.toJSONString(serviceDepartNameMap));
            respBo.setServiceDepartDescr((String)serviceDepartNameMap.get(inf.getProjectId()));
        }
        return resp;
    }

    private String validateArg(BusiSubAccountInfoReqBO reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getChannelType())) {
            return "channelType\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

