/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.BusiQueryDetailRecAmtConfirmService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailHeadRecAmtConfirmRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailListRecAmtConfirmRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailRecAmtConfirmReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailRecAmtConfirmRspBO;
import com.tydic.fsc.settle.dao.AdvanceReceiveMapper;
import com.tydic.fsc.settle.dao.RecAmtConfirmMapper;
import com.tydic.fsc.settle.dao.RecvAmtDetailMapper;
import com.tydic.fsc.settle.dao.po.AdvanceReceive;
import com.tydic.fsc.settle.dao.po.RecAmtConfirm;
import com.tydic.fsc.settle.dao.vo.AdvanceReceiveVO;
import com.tydic.fsc.settle.dao.vo.RecvAmtDetailVO;
import com.tydic.fsc.settle.enums.AdvanceReceiveStatus;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.ReceiveType;
import com.tydic.fsc.settle.utils.FileUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiQueryDetailRecAmtConfirmServiceImpl
implements BusiQueryDetailRecAmtConfirmService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryDetailRecAmtConfirmServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private RecAmtConfirmMapper recAmtConfirmMapper;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private RecvAmtDetailMapper recvAmtDetailMapper;

    public BusiQueryDetailRecAmtConfirmRspBO queryDetailRecAmtConfirm(BusiQueryDetailRecAmtConfirmReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u6536\u6b3e\u5355\u8be6\u60c5\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getDocNum() == null) {
            throw new BusinessException("0001", "\u5355\u636e\u7f16\u53f7[docNum]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RecAmtConfirm recAmtConfirm = this.recAmtConfirmMapper.selectByPrimaryKey(reqBO.getDocNum());
        if (recAmtConfirm == null) {
            throw new BusinessException("0001", "\u672a\u67e5\u8be2\u5230\u8be5\u6536\u6b3e\u5355[" + reqBO.getDocNum() + "]");
        }
        AdvanceReceiveVO advanceReceiveVO = new AdvanceReceiveVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)advanceReceiveVO);
        advanceReceiveVO.setOrderBy("tt.SEQ desc");
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<AdvanceReceive> rows = null;
        rows = OrderSource.ELECTRIC_MARKET.getCode().equals(recAmtConfirm.getSource()) ? this.advanceReceiveMapper.selectListPage(advanceReceiveVO, (Page<Map<String, Object>>)page) : this.advanceReceiveMapper.selectListPageDlzq(advanceReceiveVO, (Page<Map<String, Object>>)page);
        BusiQueryDetailRecAmtConfirmRspBO rspBO = new BusiQueryDetailRecAmtConfirmRspBO();
        BusiQueryDetailHeadRecAmtConfirmRspBO head = new BusiQueryDetailHeadRecAmtConfirmRspBO();
        rspBO.setHead(head);
        ArrayList<BusiQueryDetailListRecAmtConfirmRspBO> detailRows = new ArrayList<BusiQueryDetailListRecAmtConfirmRspBO>();
        rspBO.setRows(detailRows);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        BeanUtils.copyProperties((Object)recAmtConfirm, (Object)head);
        head.setDocNum(String.valueOf(recAmtConfirm.getDocNum()));
        String orgName = this.organizationInfoService.queryOrgName(recAmtConfirm.getOrgId());
        head.setOrgName(orgName);
        for (AdvanceReceive row : rows) {
            BusiQueryDetailListRecAmtConfirmRspBO detail = new BusiQueryDetailListRecAmtConfirmRspBO();
            BeanUtils.copyProperties((Object)row, (Object)detail);
            detail.setPayOrgName(this.organizationInfoService.obtainOrgNameByAdvanceReceive(row));
            orgName = this.organizationInfoService.queryOrgName(row.getRecOrgId());
            detail.setRecOrgName(orgName);
            detail.setRecTypeDescr(this.enumsService.getDescr(ReceiveType.getInstance(row.getRecType())));
            detail.setStatusDescr(AdvanceReceiveStatus.getInstance(row.getStatus()).getCodeDescr());
            detail.setSourceName(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)row.getSource())));
            detail.setToReceiveAmt(detail.getTranAmt().subtract(detail.getWriteoffAmt()));
            if (OrderSource.ELECTRIC_MARKET.getCode().equals(row.getSource())) {
                detail.setWriteoffAmtThisTime(row.getTranAmt());
            } else {
                RecvAmtDetailVO recvAmtDetailVO = new RecvAmtDetailVO();
                recvAmtDetailVO.setDocNum(recAmtConfirm.getDocNum());
                recvAmtDetailVO.setAdvRecvSeq(row.getSeq());
                RecvAmtDetailVO queryAmtDetailVO = this.recvAmtDetailMapper.selectSum2(recvAmtDetailVO);
                detail.setWriteoffAmtThisTime(queryAmtDetailVO.getAmount());
            }
            detail.setReceiptUrl(FileUtils.obtainOSSUrl(detail.getReceipt()));
            detailRows.add(detail);
        }
        return rspBO;
    }
}

