/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.BusiQueryOutstockDetailService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryOutstockDetaiReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryOutstockDetaiRspBO;
import com.tydic.fsc.settle.busi.api.vo.OutstockDetailVO;
import com.tydic.fsc.settle.dao.OutstockDetailMapper;
import com.tydic.fsc.settle.dao.OutstockInfoMapper;
import com.tydic.fsc.settle.dao.po.OutstockDetail;
import com.tydic.fsc.settle.dao.po.OutstockInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryOutstockDetailServiceImpl
implements BusiQueryOutstockDetailService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryOutstockDetailServiceImpl.class);
    private final OutstockDetailMapper outstockDetailMapper;
    private final OutstockInfoMapper outstockInfoMapper;
    private final OrganizationInfoService organizationInfoService;

    public BusiQueryOutstockDetailServiceImpl(OutstockDetailMapper outstockDetailMapper, OutstockInfoMapper outstockInfoMapper, OrganizationInfoService organizationInfoService) {
        this.outstockDetailMapper = outstockDetailMapper;
        this.outstockInfoMapper = outstockInfoMapper;
        this.organizationInfoService = organizationInfoService;
    }

    public BusiQueryOutstockDetaiRspBO<OutstockDetailVO> queryOutstockDetail(BusiQueryOutstockDetaiReqBO reqBO) {
        List<OutstockDetail> outstockDetailList;
        OutstockInfo outstockInfo;
        if (!StringUtils.hasText((String)reqBO.getOutstockNo())) {
            throw new BusinessException("0001", "\u51fa\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiQueryOutstockDetaiRspBO rspPageBO = new BusiQueryOutstockDetaiRspBO();
        rspPageBO.setRespCode("0000");
        String orderBy = "t.SEQ ASC";
        try {
            outstockInfo = this.outstockInfoMapper.selectByPrimaryKey(reqBO.getOutstockNo());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u51fa\u5e93\u5355\u53f7\u4e3a" + reqBO.getOutstockNo() + "\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            throw new BusinessException("18000", "\u67e5\u8be2\u51fa\u5e93\u5355\u53f7\u4e3a" + reqBO.getOutstockNo() + "\u8bb0\u5f55\u5931\u8d25");
        }
        if (outstockInfo == null) {
            rspPageBO.setRespCode("18000");
            rspPageBO.setRespDesc("\u51fa\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u51fa\u5e93\u5355\u4e0d\u5b58\u5728");
            return rspPageBO;
        }
        BeanUtils.copyProperties((Object)outstockInfo, (Object)rspPageBO);
        String purchaseName = this.organizationInfoService.queryOrgName(outstockInfo.getPurchaseNo());
        rspPageBO.setPurchaseName(purchaseName);
        OutstockDetail outstockDetail = new OutstockDetail();
        outstockDetail.setOutstockNo(reqBO.getOutstockNo());
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        try {
            outstockDetailList = this.outstockDetailMapper.getListPage(outstockDetail, (Page<Map<String, Object>>)page, orderBy);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u5e93\u51fa\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u51fa\u5e93\u8be6\u60c5\u8bb0\u5f55\u5931\u8d25\uff0c\u51fa\u5e93\u5355\u53f7\u4e3a\uff1a" + reqBO.getOutstockNo(), (Throwable)e);
            throw new BusinessException("18000", "\u67e5\u8be2\u6570\u636e\u5e93\u51fa\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u51fa\u5e93\u8be6\u60c5\u8bb0\u5f55\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(outstockDetailList)) {
            rspPageBO.setRespDesc("\u51fa\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u51fa\u5e93\u8be6\u60c5\u4e0d\u5b58\u5728");
            return rspPageBO;
        }
        ArrayList<OutstockDetailVO> outstockDetailVOList = new ArrayList<OutstockDetailVO>();
        for (OutstockDetail returnOutstock : outstockDetailList) {
            OutstockDetailVO outstockDetailVO = new OutstockDetailVO();
            BeanUtils.copyProperties((Object)returnOutstock, (Object)outstockDetailVO);
            outstockDetailVOList.add(outstockDetailVO);
        }
        rspPageBO.setRespDesc("\u51fa\u5e93\u5355\u8be6\u60c5\u67e5\u8be2\u6210\u529f");
        rspPageBO.setRows(outstockDetailVOList);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }
}

